/*
 * Decompiled with CFR 0.152.
 */
package fileselectdialog;

import Tools.Comparator;
import Tools.VectorSorter;
import data.LocalizationSupport;
import fileselectdialog.MTFileSelectDialogListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;

public class MTFileSelectDialog
implements CommandListener {
    private String currentRoot = "/";
    private String[] extensions;
    private Vector currentContent;
    private List listBrowser;
    private Command backFromFileSelect;
    private Command screenCommandEnter;
    private Command screenCommandSelect;
    private Command screenCommandSelectFolder;
    private Image imageDisc;
    private Image imageRoot;
    private Image imageFolder;
    private Image imageFile;
    private Display display;
    private MTFileSelectDialogListener fileSelectDialogListener;
    private boolean fileSelection = true;

    private void refreshListByCurrentRoot() {
        block12: {
            try {
                this.currentContent.removeAllElements();
                this.get_listBrowser().deleteAll();
                this.get_listBrowser().setTitle(this.currentRoot);
                if (this.currentRoot.equals("/")) {
                    Enumeration enumeration = FileSystemRegistry.listRoots();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        this.currentContent.addElement(new MyNode(string, true));
                    }
                    VectorSorter.sort(this.currentContent, new DefualtComparator());
                    for (int i = 0; i < this.currentContent.size(); ++i) {
                        this.get_listBrowser().append(((MyNode)this.currentContent.elementAt(i)).getName(), this.get_imageDisc());
                    }
                    break block12;
                }
                FileConnection fileConnection = null;
                try {
                    fileConnection = (FileConnection)Connector.open((String)("file:///" + this.currentRoot), (int)1);
                    if (fileConnection.isDirectory()) {
                        this.get_listBrowser().append("..", this.get_imageRoot());
                        Enumeration enumeration = fileConnection.list();
                        while (enumeration.hasMoreElements()) {
                            String string = (String)enumeration.nextElement();
                            if (string.endsWith("/")) {
                                this.currentContent.addElement(new MyNode(string, true));
                                continue;
                            }
                            if (!this.fileSelection || !this.endsWithExtensions(string)) continue;
                            this.currentContent.addElement(new MyNode(string, false));
                        }
                        VectorSorter.sort(this.currentContent, new DefualtComparator());
                        for (int i = 0; i < this.currentContent.size(); ++i) {
                            MyNode myNode = (MyNode)this.currentContent.elementAt(i);
                            Image image = myNode.isDir() ? this.get_imageFolder() : this.get_imageFile();
                            this.get_listBrowser().append(myNode.getName(), image);
                        }
                        fileConnection.close();
                        break block12;
                    }
                    fileConnection.close();
                    this.currentRoot = "/";
                    this.refreshListByCurrentRoot();
                }
                catch (IOException iOException) {
                    this.showAlert(iOException.getMessage());
                }
                catch (SecurityException securityException) {
                    this.showAlert(securityException.getMessage());
                }
            }
            catch (Exception exception) {
                this.showAlert(exception.getMessage());
                this.get_listBrowser().setTitle(exception.getMessage());
            }
        }
    }

    private void refreshList() {
        int n = this.get_listBrowser().getSelectedIndex() - 1;
        boolean bl = false;
        if (this.currentRoot.equals("/")) {
            bl = true;
            ++n;
        }
        if (this.get_listBrowser().getSelectedIndex() != 0 || bl) {
            MyNode myNode = (MyNode)this.currentContent.elementAt(n);
            if (myNode.isDir()) {
                String string = myNode.getName();
                this.currentRoot = bl ? string : this.currentRoot + string;
                new MyRootRefresher().start();
            }
        } else {
            boolean bl2 = false;
            if (this.getPerNums(this.currentRoot) == 1) {
                this.currentRoot = "/";
                bl2 = true;
            } else if (this.currentRoot.charAt(this.currentRoot.length() - 1) == '/') {
                this.currentRoot = this.currentRoot.substring(0, this.currentRoot.length() - 1);
            }
            if (!bl2) {
                this.currentRoot = this.currentRoot.substring(0, this.currentRoot.lastIndexOf(47) + 1);
            }
            new MyRootRefresher().start();
        }
    }

    private int getPerNums(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '/') continue;
            ++n;
        }
        return n;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.backFromFileSelect) {
            this.fileSelectDialogListener.selectionCancelled();
        } else if (command == this.get_screenCommandSelect() || command == List.SELECT_COMMAND) {
            if (!this.currentRoot.equals("/") && this.get_listBrowser().getSelectedIndex() != 0) {
                MyNode myNode = (MyNode)this.currentContent.elementAt(this.get_listBrowser().getSelectedIndex() - 1);
                if (!myNode.isDir()) {
                    this.fileSelectDialogListener.fileSelected(this.currentRoot + myNode.getName(), myNode.getName());
                } else {
                    this.refreshList();
                }
            } else {
                this.refreshList();
            }
        } else if (command == this.get_screenCommandSelectFolder()) {
            MyNode myNode;
            if (this.currentRoot.equals("/")) {
                MyNode myNode2 = (MyNode)this.currentContent.elementAt(this.get_listBrowser().getSelectedIndex());
                if (myNode2.isDir()) {
                    this.fileSelectDialogListener.folderSelected(myNode2.getName(), myNode2.getName());
                }
            } else if (!this.currentRoot.equals("/") && this.get_listBrowser().getSelectedIndex() != 0 && (myNode = (MyNode)this.currentContent.elementAt(this.get_listBrowser().getSelectedIndex() - 1)).isDir()) {
                this.fileSelectDialogListener.folderSelected(this.currentRoot + myNode.getName(), myNode.getName());
            }
        }
    }

    public MTFileSelectDialog(Display display, MTFileSelectDialogListener mTFileSelectDialogListener) {
        this.display = display;
        this.fileSelectDialogListener = mTFileSelectDialogListener;
    }

    public void showFileSelectDialog(String[] stringArray, boolean bl) {
        this.extensions = stringArray;
        this.fileSelection = bl;
        this.currentContent = new Vector();
        this.display.setCurrent((Displayable)this.get_listBrowser());
        if (this.fileSelection) {
            this.get_listBrowser().removeCommand(this.get_screenCommandSelectFolder());
        } else {
            this.get_listBrowser().addCommand(this.get_screenCommandSelectFolder());
        }
        new MyRootRefresher().start();
    }

    private boolean endsWithExtensions(String string) {
        if (this.extensions == null) {
            return true;
        }
        for (int i = 0; i < this.extensions.length; ++i) {
            if (!string.endsWith(this.extensions[i])) continue;
            return true;
        }
        return false;
    }

    private void showAlert(String string) {
        Alert alert = new Alert(LocalizationSupport.getMessage("title_fileBrowser"), string, null, AlertType.ERROR);
        alert.setTimeout(-2);
        this.display.setCurrent(alert, (Displayable)this.get_listBrowser());
    }

    private List get_listBrowser() {
        if (this.listBrowser == null) {
            this.listBrowser = new List(LocalizationSupport.getMessage("title_fileBrowser"), 3, new String[0], new Image[0]);
            this.listBrowser.addCommand(this.get_backCommandBackToList());
            this.listBrowser.addCommand(this.get_screenCommandSelect());
            this.listBrowser.addCommand(this.get_screenCommandSelectFolder());
            this.listBrowser.setCommandListener((CommandListener)this);
            this.listBrowser.setSelectedFlags(new boolean[0]);
        }
        return this.listBrowser;
    }

    private Command get_backCommandBackToList() {
        if (this.backFromFileSelect == null) {
            this.backFromFileSelect = new Command(LocalizationSupport.getMessage("command_back"), 2, 1);
        }
        return this.backFromFileSelect;
    }

    private Command get_screenCommandSelect() {
        if (this.screenCommandSelect == null) {
            this.screenCommandSelect = new Command(LocalizationSupport.getMessage("command_open"), 1, 2);
        }
        return this.screenCommandSelect;
    }

    private Command get_screenCommandSelectFolder() {
        if (this.screenCommandSelectFolder == null) {
            this.screenCommandSelectFolder = new Command(LocalizationSupport.getMessage("command_selectFolder"), 1, 3);
        }
        return this.screenCommandSelectFolder;
    }

    private Image get_imageFolder() {
        if (this.imageFolder == null) {
            try {
                this.imageFolder = Image.createImage((String)"/resources/folder.png");
            }
            catch (IOException iOException) {
                this.showAlert(iOException.getMessage());
            }
        }
        return this.imageFolder;
    }

    private Image get_imageFile() {
        if (this.imageFile == null) {
            try {
                this.imageFile = Image.createImage((String)"/resources/file.png");
            }
            catch (IOException iOException) {
                this.showAlert(iOException.getMessage());
            }
        }
        return this.imageFile;
    }

    private Image get_imageDisc() {
        if (this.imageDisc == null) {
            try {
                this.imageDisc = Image.createImage((String)"/resources/disc.png");
            }
            catch (IOException iOException) {
                this.showAlert(iOException.getMessage());
            }
        }
        return this.imageDisc;
    }

    private Image get_imageRoot() {
        if (this.imageRoot == null) {
            try {
                this.imageRoot = Image.createImage((String)"/resources/root.png");
            }
            catch (IOException iOException) {
                this.showAlert(iOException.getMessage());
            }
        }
        return this.imageRoot;
    }

    private class MyRootRefresher
    extends Thread {
        private MyRootRefresher() {
        }

        public void run() {
            MTFileSelectDialog.this.refreshListByCurrentRoot();
            MTFileSelectDialog.this.get_listBrowser().setSelectedIndex(0, true);
        }
    }

    private static class DefualtComparator
    implements Comparator {
        private DefualtComparator() {
        }

        public int compare(Object object, Object object2) {
            MyNode myNode = (MyNode)object;
            MyNode myNode2 = (MyNode)object2;
            if (myNode.isDir() == myNode2.isDir()) {
                return myNode.getName().toLowerCase().compareTo(myNode2.getName().toLowerCase());
            }
            return myNode.isDir() ? -1 : 1;
        }
    }

    private class MyNode {
        private String name;
        private boolean dir;

        MyNode(String string, boolean bl) {
            this.setName(string);
            this.setDir(bl);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public boolean isDir() {
            return this.dir;
        }

        public void setDir(boolean bl) {
            this.dir = bl;
        }
    }
}

