/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.basket.tools;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class SFXPlayer {
    public static final int SOUND_EFFECT__CAR_CRASH = 2;
    public static final int SOUND_EFFECT__ENGINE_START = 1;
    private static Hashtable mapSound = new Hashtable();
    private static long timeLastSound = 0L;
    private InputStream[] stream;
    private boolean on = false;
    private VolumeControl volumeControl;
    private int volume = 100;

    private SFXPlayer() {
    }

    public static SFXPlayer getInstance() {
        return SFXPlayerHolder.instance;
    }

    public void open() {
        this.stream = new InputStream[2];
        for (int i = this.stream.length - 1; i >= 0; --i) {
            this.stream[i] = this.getClass().getResourceAsStream("/res/sfx/" + (i + 1) + ".mid");
            this.getPlayer(i + 1);
        }
        this.on = true;
    }

    public void close() {
        this.stream = null;
        mapSound.clear();
        this.on = false;
    }

    private Player getPlayer(int soundEffectType) {
        Player player = (Player)mapSound.get(Integer.toString(soundEffectType));
        if (player == null) {
            try {
                player = Manager.createPlayer((InputStream)this.stream[soundEffectType - 1], (String)"audio/midi");
                mapSound.put(Integer.toString(soundEffectType), player);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return player;
    }

    public void playEffect(int soundEffectType) {
        if (!this.on) {
            return;
        }
        if (Math.abs(System.currentTimeMillis() - timeLastSound) < 250L) {
            return;
        }
        timeLastSound = System.currentTimeMillis();
        Player player = this.getPlayer(soundEffectType);
        try {
            Enumeration enumValues = mapSound.elements();
            while (enumValues.hasMoreElements()) {
                Player playerOther = (Player)enumValues.nextElement();
                if (playerOther == player || playerOther.getState() != 400) continue;
                playerOther.deallocate();
            }
            if (player.getState() == 400) {
                return;
            }
            player.realize();
            this.volumeControl = (VolumeControl)player.getControl("VolumeControl");
            if (this.volumeControl != null) {
                this.volumeControl.setLevel(this.volume);
            }
            player.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setVolume(int volume) {
        this.volume = volume < 0 ? 0 : (volume > 100 ? 100 : volume);
    }

    private static class SFXPlayerHolder {
        private static final SFXPlayer instance = new SFXPlayer();

        private SFXPlayerHolder() {
        }
    }
}

