/*
 * Decompiled with CFR 0.152.
 */
package bbs.framework.menu;

import bbs.framework.helper.BBSKeys;
import bbs.framework.models.BBSGame;
import bbs.framework.models.BBSLoader;
import javax.microedition.lcdui.Graphics;

public abstract class BBSStripeLoader
extends BBSLoader {
    private String loadText;
    private String readyText;
    private int timer;
    public static final int bubles = 1;
    public static final int caution = 2;
    public static final int lines = 3;
    public static final int boxes = 4;
    private int cr;
    private int cg;
    private int cb;
    private int temp;
    private int temp2;

    public BBSStripeLoader(BBSGame game, int effect) {
        super(game, effect);
    }

    public void doAnimation(BBSGame game, int time) {
        this.timer = time / 20;
    }

    public void initialize(BBSGame game) {
        this.cr = 0;
        this.cg = 200;
        this.cb = 0;
    }

    public void setColor(int r, int g, int b) {
        this.cr = r;
        this.cg = g;
        this.cb = b;
    }

    public void drawScreen(BBSGame game, Graphics g, int stage) {
        int perc = 100 * this.percentage / Math.max(1, this.maxValue);
        if (perc < 100) {
            if (this.loadText == null) {
                this.loadText = "LOADING " + String.valueOf(stage);
            }
        } else if (this.readyText == null) {
            this.readyText = "LEVEL " + String.valueOf(stage);
        }
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, game.w, game.h);
        switch (this.loadEffect) {
            case 1: {
                for (int cnt = 6; cnt < 60; ++cnt) {
                    g.setColor((this.timer + cnt * 127) % 777 % 256, (this.timer + cnt * 227) % 917 % 256, (this.timer + cnt * 327) % 313 % 256);
                    g.fillArc((this.timer + cnt * 127) % 1777 % (game.w + 2 * cnt) - cnt, (this.timer + cnt * 327) % 1123 % (game.h + 2 * cnt) - cnt, cnt, cnt, 0, 360);
                }
                break;
            }
            case 2: {
                for (int cnt = 2 * Math.max(game.w, game.h); cnt > 0; cnt -= 20) {
                    if ((cnt / 20 % 2 + this.timer / 10 % 2) % 2 == 0) {
                        g.setColor(255, 200, 0);
                    } else {
                        g.setColor(0, 0, 0);
                    }
                    g.fillTriangle(0, 0, 0, cnt, cnt, 0);
                }
                break;
            }
            case 3: {
                for (int cnt = 0; cnt < 60; ++cnt) {
                    this.temp = (this.timer + cnt * 12171) % 1777 % game.h;
                    g.setColor((this.timer + cnt * 127) % 777 % 256, (this.timer + cnt * 127) % 777 % 256, (this.timer + cnt * 127) % 777 % 256);
                    g.drawLine(0, this.temp, game.w, this.temp);
                }
                break;
            }
            case 4: {
                for (int cnt = 0; cnt < 60; ++cnt) {
                    this.temp = (this.timer + cnt * 23741) / 60;
                    this.temp2 = (this.timer + cnt) % 30;
                    g.setColor(0, (this.timer + cnt * 77) % 777 % 256, 0);
                    g.fillRoundRect((this.temp + cnt * 177) % game.w - this.temp2, (this.temp + cnt * 321) % game.h - this.temp2, 2 * this.temp2, 2 * this.temp2, 10, 10);
                }
                break;
            }
        }
        g.setColor(255, 255, 255);
        g.fillRect(20, 20, game.w - 40, game.h - 40);
        g.setColor(0, 0, 0);
        g.fillRect(21, 21, game.w - 42, game.h - 42);
        if (perc < 100) {
            game.drawText(g, game.w / 2, game.h / 2 - 20, this.loadText, null, 4, 1);
            g.setColor(82, 97, 82);
            g.fillRect(game.w / 2 - 50, game.h / 2, 100, 4);
            g.setColor(this.cr, this.cg, this.cb);
            g.fillRect(game.w / 2 - 50, game.h / 2, perc, 4);
            g.setColor(0, 0, 0);
            g.drawRect(game.w / 2 - 50, game.h / 2, 100, 4);
        } else if (game.w == 128) {
            game.drawText(g, game.w / 2, game.h / 2 - 30, this.readyText, null, 2, 1);
            game.drawText(g, game.w / 2, game.h / 2 + 10, "READY", null, 4, 1);
        } else {
            game.drawText(g, game.w / 2, game.h / 2 - 30, this.readyText, null, 1, 1);
            game.drawText(g, game.w / 2, game.h / 2 + 10, "READY", null, 3, 1);
        }
    }

    public void keyPress(BBSGame game, BBSKeys kcol, int time) {
        if ((kcol.fire || kcol.lfire) && game.gameState == 4) {
            this.freeResources(game);
        }
    }

    protected void freeResources(BBSGame game) {
        super.freeResources(game);
        this.loadText = null;
        this.readyText = null;
    }
}

