/*
 * Decompiled with CFR 0.152.
 */
package wedesoft.mobinav;

import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import wedesoft.mobinav.About;
import wedesoft.mobinav.CacheEntry;

class MapCanvas
extends Canvas
implements CommandListener {
    MIDlet midlet;
    private Display dpy;
    Command cmdExit;
    Command cmdBack;
    Command cmdZoomIn;
    Command cmdZoomOut;
    Command cmdSetMarker;
    Command cmdOk;
    Command cmdCancel;
    Command cmdReset;
    Command cmdAbout;
    Image mapVendorImage;
    int zoom;
    int posx;
    int posy;
    int maxtiles;
    boolean markerMode;
    boolean hasMarker;
    int markX;
    int markY;
    int oldPosX;
    int oldPosY;
    CacheEntry[] cache;
    static final int tilesize = 128;
    static final int markerSize = 15;

    public MapCanvas(MIDlet mIDlet) {
        this.midlet = mIDlet;
        this.dpy = Display.getDisplay((MIDlet)this.midlet);
        this.cache = new CacheEntry[0];
        this.markerMode = false;
        this.cmdExit = new Command("Exit", 7, 1);
        this.cmdCancel = new Command("Cancel", 2, 1);
        this.cmdOk = new Command("Ok", 1, 2);
        this.cmdZoomIn = new Command("Zoom In", 1, 3);
        this.cmdZoomOut = new Command("Zoom Out", 1, 4);
        this.cmdSetMarker = new Command("Set Marker", 1, 5);
        this.cmdReset = new Command("Reset", 1, 10);
        this.cmdAbout = new Command("About", 5, 30);
        this.loadOptions();
        try {
            this.mapVendorImage = Image.createImage((String)"/wedesoft/mobinav/mapvendor.png");
        }
        catch (IOException iOException) {
            this.reset();
        }
        this.setMarkerMode(false);
        this.setCommandListener(this);
    }

    protected void updateEnabled() {
        if (this.maxtiles >= 10) {
            this.addCommand(this.cmdZoomOut);
        } else {
            this.removeCommand(this.cmdZoomOut);
        }
        if (this.zoom > 1) {
            this.addCommand(this.cmdZoomIn);
        } else {
            this.removeCommand(this.cmdZoomIn);
        }
    }

    protected void reset() {
        this.zoom = 1;
        this.maxtiles = 10;
        while (this.loadTile(0, 0) != null) {
            this.maxtiles *= 10;
        }
        this.maxtiles /= 10;
        this.posx = this.getWidth() / 2;
        this.posy = this.getHeight() / 2;
        this.hasMarker = false;
        this.markX = this.getWidth() / 2;
        this.markY = this.getHeight() / 2;
        this.updateEnabled();
    }

    public void showNotify() {
    }

    public void hideNotify() {
    }

    public void paint(Graphics graphics) {
        if (this.mapVendorImage != null) {
            int n;
            int n2;
            int n3 = this.getWidth();
            int n4 = this.getHeight();
            int n5 = this.posx / this.zoom - n3 / 2;
            int n6 = this.posy / this.zoom - n4 / 2;
            int n7 = n5 + n3 - 1;
            int n8 = n6 + n4 - 1;
            int n9 = this.sample(n5, 128);
            int n10 = this.sample(n6, 128);
            int n11 = this.sample(n7, 128);
            int n12 = this.sample(n8, 128);
            int n13 = 0;
            CacheEntry[] cacheEntryArray = new CacheEntry[(n11 + 1 - n9) * (n12 + 1 - n10)];
            graphics.setColor(0xFFFFFF);
            int n14 = n10 * 128 - n6;
            for (n2 = n10; n2 <= n12; ++n2) {
                n = n9 * 128 - n5;
                for (int i = n9; i <= n11; ++i) {
                    Image image = this.loadTile(i, n2);
                    cacheEntryArray[n13++] = new CacheEntry(i, n2, this.zoom, image);
                    if (image == null) {
                        image = this.mapVendorImage;
                    }
                    graphics.drawImage(image, n, n14, 20);
                    if (image.getWidth() < 128) {
                        graphics.fillRect(n + image.getWidth(), n14, 128 - image.getWidth(), image.getHeight());
                    }
                    if (image.getHeight() < 128) {
                        graphics.fillRect(n, n14 + image.getHeight(), 128, 128 - image.getHeight());
                    }
                    n += 128;
                }
                n14 += 128;
            }
            if (this.hasMarker) {
                n2 = (this.markX - this.posx) / this.zoom + this.getWidth() / 2;
                n = (this.markY - this.posy) / this.zoom + this.getHeight() / 2;
                graphics.setColor(0xFF0000);
                graphics.drawArc(n2 - 7, n - 7, 15, 15, 0, 360);
                graphics.drawLine(n2, n - 7, n2, n + 7);
                graphics.drawLine(n2 - 7, n, n2 + 7, n);
                graphics.setStrokeStyle(1);
                graphics.drawLine(this.getWidth() / 2, this.getHeight() / 2, n2, n);
                graphics.setStrokeStyle(0);
            }
            this.cache = cacheEntryArray;
        } else {
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(0xFF0000);
            graphics.drawString("File '/wedesoft/mobinav/mapvendor.png' not found", (this.getWidth() / 2 - this.posx) / this.zoom + this.getWidth() / 2, (this.getHeight() / 2 - this.posy) / this.zoom + this.getHeight() / 2, 65);
        }
    }

    public void keyPressed(int n) {
        boolean bl = true;
        int n2 = this.markerMode ? 7 * this.zoom : this.getWidth() / 4 * this.zoom;
        block0 : switch (n) {
            case 50: {
                this.posy -= n2;
                break;
            }
            case 56: {
                this.posy += n2;
                break;
            }
            case 52: {
                this.posx -= n2;
                break;
            }
            case 54: {
                this.posx += n2;
                break;
            }
            case 42: 
            case 49: 
            case 55: {
                if (this.maxtiles >= 10) {
                    this.zoomOut();
                    break;
                }
                bl = false;
                break;
            }
            case 35: 
            case 51: 
            case 57: {
                if (this.zoom >= 2) {
                    this.zoomIn();
                    break;
                }
                bl = false;
                break;
            }
            default: {
                switch (this.getGameAction(n)) {
                    case 1: {
                        this.posy -= n2;
                        break block0;
                    }
                    case 6: {
                        this.posy += n2;
                        break block0;
                    }
                    case 2: {
                        this.posx -= n2;
                        break block0;
                    }
                    case 5: {
                        this.posx += n2;
                        break block0;
                    }
                }
                bl = false;
            }
        }
        if (this.markerMode) {
            this.markX = this.posx;
            this.markY = this.posy;
        }
        if (bl) {
            this.repaint();
        }
    }

    Image loadTile(int n, int n2) {
        Image image = null;
        if (n >= 0 && n2 >= 0 && n < this.maxtiles && n2 < this.maxtiles) {
            String string = "/wedesoft/mobinav/" + (this.maxtiles + n) + (this.maxtiles + n2) + ".png";
            try {
                for (int i = 0; i < this.cache.length; ++i) {
                    if (!this.cache[i].match(n, n2, this.zoom)) continue;
                    image = this.cache[i].getImage();
                    break;
                }
                if (image == null) {
                    image = Image.createImage((String)string);
                }
            }
            catch (IOException iOException) {
                image = null;
            }
        }
        return image;
    }

    protected int sample(int n, int n2) {
        int n3 = n >= 0 ? n / n2 : -this.sample(n2 - 1 - n, n2);
        return n3;
    }

    protected void zoomIn() {
        if (this.zoom > 1) {
            this.zoom /= 2;
            this.maxtiles *= 10;
            this.updateEnabled();
        }
    }

    protected void zoomOut() {
        if (this.maxtiles >= 10) {
            this.zoom *= 2;
            this.maxtiles /= 10;
            this.updateEnabled();
        }
    }

    protected void loadOptions() {
        this.reset();
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"Settings", (boolean)true);
            try {
                this.posx = Integer.valueOf(new String(recordStore.getRecord(1)));
                this.posy = Integer.valueOf(new String(recordStore.getRecord(2)));
                this.zoom = Integer.valueOf(new String(recordStore.getRecord(3)));
                this.hasMarker = Integer.valueOf(new String(recordStore.getRecord(4))) != 0;
                this.markX = Integer.valueOf(new String(recordStore.getRecord(5)));
                this.markY = Integer.valueOf(new String(recordStore.getRecord(6)));
                for (int i = this.zoom; i > 1; i /= 2) {
                    this.maxtiles /= 10;
                }
                this.updateEnabled();
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void saveOptions() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"Settings", (boolean)true);
            String string = String.valueOf(this.posx);
            String string2 = String.valueOf(this.posy);
            String string3 = String.valueOf(this.zoom);
            String string4 = this.hasMarker ? "1" : "0";
            String string5 = String.valueOf(this.markX);
            String string6 = String.valueOf(this.markY);
            try {
                recordStore.setRecord(1, string.getBytes(), 0, string.length());
                recordStore.setRecord(2, string2.getBytes(), 0, string2.length());
                recordStore.setRecord(3, string3.getBytes(), 0, string3.length());
                recordStore.setRecord(4, string4.getBytes(), 0, string4.length());
                recordStore.setRecord(5, string5.getBytes(), 0, string5.length());
                recordStore.setRecord(6, string6.getBytes(), 0, string6.length());
            }
            catch (RecordStoreException recordStoreException) {
                recordStore.addRecord(string.getBytes(), 0, string.length());
                recordStore.addRecord(string2.getBytes(), 0, string2.length());
                recordStore.addRecord(string3.getBytes(), 0, string3.length());
                recordStore.addRecord(string4.getBytes(), 0, string4.length());
                recordStore.addRecord(string5.getBytes(), 0, string5.length());
                recordStore.addRecord(string6.getBytes(), 0, string6.length());
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setMarkerMode(boolean bl) {
        if (bl) {
            this.removeCommand(this.cmdExit);
            this.addCommand(this.cmdOk);
            this.addCommand(this.cmdCancel);
            this.removeCommand(this.cmdSetMarker);
            this.removeCommand(this.cmdReset);
            this.removeCommand(this.cmdAbout);
        } else {
            this.addCommand(this.cmdExit);
            this.removeCommand(this.cmdOk);
            this.removeCommand(this.cmdCancel);
            if (this.mapVendorImage != null) {
                this.addCommand(this.cmdSetMarker);
            } else {
                this.removeCommand(this.cmdSetMarker);
            }
            this.addCommand(this.cmdReset);
            this.addCommand(this.cmdAbout);
        }
        this.markerMode = bl;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmdExit) {
            this.saveOptions();
            this.midlet.notifyDestroyed();
        } else if (command == this.cmdZoomIn) {
            this.zoomIn();
            this.repaint();
        } else if (command == this.cmdZoomOut) {
            this.zoomOut();
            this.repaint();
        } else if (command == this.cmdReset) {
            this.reset();
            try {
                RecordStore.deleteRecordStore((String)"Settings");
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
            this.repaint();
        } else if (command == this.cmdAbout) {
            About.showAbout(this.dpy);
        } else if (command == this.cmdSetMarker) {
            this.setMarkerMode(true);
            this.oldPosX = this.posx;
            this.oldPosY = this.posy;
            if (this.hasMarker) {
                this.posx = this.markX;
                this.posy = this.markY;
            } else {
                this.markX = this.posx;
                this.markY = this.posy;
                this.hasMarker = true;
            }
            this.repaint();
        } else if (command == this.cmdOk) {
            this.setMarkerMode(false);
            this.posx = this.oldPosX;
            this.posy = this.oldPosY;
            this.hasMarker = true;
            this.repaint();
        } else if (command == this.cmdCancel) {
            this.setMarkerMode(false);
            this.posx = this.oldPosX;
            this.posy = this.oldPosY;
            this.hasMarker = false;
            this.repaint();
        }
    }
}

