/*
 * Decompiled with CFR 0.152.
 */
package net.sf.zipme;

import net.sf.zipme.StreamManipulator;

class OutputWindow {
    private static final int WINDOW_SIZE = 32768;
    private static final int WINDOW_MASK = Short.MAX_VALUE;
    private byte[] window = new byte[32768];
    private int window_end = 0;
    private int window_filled = 0;

    OutputWindow() {
    }

    public void write(int abyte) {
        if (this.window_filled++ == 32768) {
            throw new IllegalStateException("Window full");
        }
        this.window[this.window_end++] = (byte)abyte;
        this.window_end &= Short.MAX_VALUE;
    }

    private void slowRepeat(int rep_start, int len, int dist) {
        while (len-- > 0) {
            this.window[this.window_end++] = this.window[rep_start++];
            this.window_end &= Short.MAX_VALUE;
            rep_start &= Short.MAX_VALUE;
        }
    }

    public void repeat(int len, int dist) {
        if ((this.window_filled += len) > 32768) {
            throw new IllegalStateException("Window full");
        }
        int rep_start = this.window_end - dist & Short.MAX_VALUE;
        int border = 32768 - len;
        if (rep_start <= border && this.window_end < border) {
            if (len <= dist) {
                System.arraycopy(this.window, rep_start, this.window, this.window_end, len);
                this.window_end += len;
            } else {
                while (len-- > 0) {
                    this.window[this.window_end++] = this.window[rep_start++];
                }
            }
        } else {
            this.slowRepeat(rep_start, len, dist);
        }
    }

    public int copyStored(StreamManipulator input, int len) {
        int copied;
        int tailLen;
        if ((len = Math.min(Math.min(len, 32768 - this.window_filled), input.getAvailableBytes())) > (tailLen = 32768 - this.window_end)) {
            copied = input.copyBytes(this.window, this.window_end, tailLen);
            if (copied == tailLen) {
                copied += input.copyBytes(this.window, 0, len - tailLen);
            }
        } else {
            copied = input.copyBytes(this.window, this.window_end, len);
        }
        this.window_end = this.window_end + copied & Short.MAX_VALUE;
        this.window_filled += copied;
        return copied;
    }

    public void copyDict(byte[] dict, int offset, int len) {
        if (this.window_filled > 0) {
            throw new IllegalStateException();
        }
        if (len > 32768) {
            offset += len - 32768;
            len = 32768;
        }
        System.arraycopy(dict, offset, this.window, 0, len);
        this.window_end = len & Short.MAX_VALUE;
    }

    public int getFreeSpace() {
        return 32768 - this.window_filled;
    }

    public int getAvailable() {
        return this.window_filled;
    }

    public int copyOutput(byte[] output, int offset, int len) {
        int copy_end = this.window_end;
        if (len > this.window_filled) {
            len = this.window_filled;
        } else {
            copy_end = this.window_end - this.window_filled + len & Short.MAX_VALUE;
        }
        int copied = len;
        int tailLen = len - copy_end;
        if (tailLen > 0) {
            System.arraycopy(this.window, 32768 - tailLen, output, offset, tailLen);
            offset += tailLen;
            len = copy_end;
        }
        System.arraycopy(this.window, copy_end - len, output, offset, len);
        this.window_filled -= copied;
        if (this.window_filled < 0) {
            throw new IllegalStateException();
        }
        return copied;
    }

    public void reset() {
        this.window_end = 0;
        this.window_filled = 0;
    }
}

