/*
 * Decompiled with CFR 0.152.
 */
package ru.andrew.jclazz.core.code;

import ru.andrew.jclazz.core.attributes.Code;
import ru.andrew.jclazz.core.code.ops.Arithmetic;
import ru.andrew.jclazz.core.code.ops.ArrayLength;
import ru.andrew.jclazz.core.code.ops.ArrayPush;
import ru.andrew.jclazz.core.code.ops.BitArithmetic;
import ru.andrew.jclazz.core.code.ops.CheckCast;
import ru.andrew.jclazz.core.code.ops.Dup;
import ru.andrew.jclazz.core.code.ops.Dup2;
import ru.andrew.jclazz.core.code.ops.GetField;
import ru.andrew.jclazz.core.code.ops.GoTo;
import ru.andrew.jclazz.core.code.ops.If;
import ru.andrew.jclazz.core.code.ops.Iinc;
import ru.andrew.jclazz.core.code.ops.InstanceOf;
import ru.andrew.jclazz.core.code.ops.Invoke;
import ru.andrew.jclazz.core.code.ops.Jsr;
import ru.andrew.jclazz.core.code.ops.MonitorEnter;
import ru.andrew.jclazz.core.code.ops.MonitorExit;
import ru.andrew.jclazz.core.code.ops.MultiNewArray;
import ru.andrew.jclazz.core.code.ops.New;
import ru.andrew.jclazz.core.code.ops.NewArray;
import ru.andrew.jclazz.core.code.ops.Nop;
import ru.andrew.jclazz.core.code.ops.Operation;
import ru.andrew.jclazz.core.code.ops.Pop;
import ru.andrew.jclazz.core.code.ops.PushConst;
import ru.andrew.jclazz.core.code.ops.PushVariable;
import ru.andrew.jclazz.core.code.ops.PutField;
import ru.andrew.jclazz.core.code.ops.Ret;
import ru.andrew.jclazz.core.code.ops.Return;
import ru.andrew.jclazz.core.code.ops.Signum;
import ru.andrew.jclazz.core.code.ops.Swap;
import ru.andrew.jclazz.core.code.ops.Switch;
import ru.andrew.jclazz.core.code.ops.Throw;
import ru.andrew.jclazz.core.code.ops.TypeConversion;
import ru.andrew.jclazz.core.code.ops.Wide;

public class OperationFactory {
    private static OperationFactory a = new OperationFactory();

    private OperationFactory() {
    }

    public static OperationFactory getInstance() {
        return a;
    }

    public Operation createOperation(int n, long l, Code code) {
        if (n == 0) {
            return new Nop(n, l, code);
        }
        if (n >= 1 && n <= 20) {
            return new PushConst(n, l, code);
        }
        if (n >= 21 && n <= 45) {
            return new PushVariable(n, l, code);
        }
        if (n >= 46 && n <= 53) {
            return new ArrayPush(n, l, code);
        }
        if (n >= 54 && n <= 88) {
            return new Pop(n, l, code);
        }
        if (n >= 89 && n <= 91) {
            return new Dup(n, l, code);
        }
        if (n >= 92 && n <= 94) {
            return new Dup2(n, l, code);
        }
        if (n == 95) {
            return new Swap(n, l, code);
        }
        if (n >= 96 && n <= 119) {
            return new Arithmetic(n, l, code);
        }
        if (n >= 120 && n <= 131) {
            return new BitArithmetic(n, l, code);
        }
        if (n == 132) {
            return new Iinc(n, l, code);
        }
        if (n >= 133 && n <= 147) {
            return new TypeConversion(n, l, code);
        }
        if (n >= 148 && n <= 152) {
            return new Signum(n, l, code);
        }
        if (n >= 153 && n <= 166 || n == 198 || n == 199) {
            return new If(n, l, code);
        }
        if (n == 167 || n == 200) {
            return new GoTo(n, l, code);
        }
        if (n == 168 || n == 201) {
            return new Jsr(n, l, code);
        }
        if (n == 169) {
            return new Ret(n, l, code);
        }
        if (n >= 170 && n <= 171) {
            return new Switch(n, l, code);
        }
        if (n >= 172 && n <= 177) {
            return new Return(n, l, code);
        }
        if (n == 178 || n == 180) {
            return new GetField(n, l, code);
        }
        if (n == 179 || n == 181) {
            return new PutField(n, l, code);
        }
        if (n >= 182 && n <= 186) {
            return new Invoke(n, l, code);
        }
        if (n == 187) {
            return new New(n, l, code);
        }
        if (n >= 188 && n <= 189) {
            return new NewArray(n, l, code);
        }
        if (n == 190) {
            return new ArrayLength(n, l, code);
        }
        if (n == 191) {
            return new Throw(n, l, code);
        }
        if (n == 192) {
            return new CheckCast(n, l, code);
        }
        if (n == 193) {
            return new InstanceOf(n, l, code);
        }
        if (n == 194) {
            return new MonitorEnter(n, l, code);
        }
        if (n == 195) {
            return new MonitorExit(n, l, code);
        }
        if (n == 196) {
            return new Wide(n, l, code).loadOperation();
        }
        if (n == 197) {
            return new MultiNewArray(n, l, code);
        }
        return new Operation(n, l, code);
    }
}

