/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MenuCanvas
extends AppCanvas
implements Runnable {
    private final int APP_STOP;
    private final int APP_RUN;
    private final int APP_PAUSE;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_RIGHT = 1;
    public static final int ALIGN_CENTER = 2;
    Object pauseMonitor = new Object();
    Thread gameThread;
    int appState = 1;
    int index;
    Vector elements = new Vector();
    int orgx = 46;
    int orgy = 40;
    int title_x;
    int title_y;
    int itemSpace = 0;
    int menuAlign = 0;
    Image background;
    Graphics gbck;
    Image inlayImage;
    String titleString;
    Image titleImage;
    int m_org_y;
    Image markerImage;
    int markerX = 20;
    int markerY = 0;

    public MenuCanvas(String string) {
        this.APP_STOP = 0;
        this.APP_RUN = 1;
        this.APP_PAUSE = 2;
        try {
            AppCanvas.width = this.getWidth();
            AppCanvas.height = this.getHeight();
            this.titleString = string;
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        this.init();
    }

    public MenuCanvas(Image image) {
        this.APP_STOP = 0;
        this.APP_RUN = 1;
        this.APP_PAUSE = 2;
        try {
            AppCanvas.width = this.getWidth();
            AppCanvas.height = this.getHeight();
            this.titleImage = image;
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        this.init();
    }

    public MenuCanvas(String string, String[] stringArray, Image[] imageArray) {
        this.APP_STOP = 0;
        this.APP_RUN = 1;
        this.APP_PAUSE = 2;
        try {
            AppCanvas.width = this.getWidth();
            AppCanvas.height = this.getHeight();
            this.titleString = string;
            int n = 0;
            int n2 = 0;
            if (stringArray != null && imageArray != null) {
                while (n < stringArray.length || n2 < imageArray.length) {
                    Image image;
                    String string2;
                    if (n < stringArray.length) {
                        string2 = stringArray[n];
                        ++n;
                    } else {
                        string2 = null;
                    }
                    if (n2 < imageArray.length) {
                        image = imageArray[n2];
                        ++n2;
                    } else {
                        image = null;
                    }
                    MenuItem menuItem = new MenuItem(string2, image);
                    menuItem.setLocation(this.orgx, this.size() * Font.getDefaultFont().getHeight());
                    this.elements.addElement(menuItem);
                }
            } else if (stringArray != null) {
                while (n < stringArray.length) {
                    String string3 = stringArray[n];
                    ++n;
                    Image image = null;
                    MenuItem menuItem = new MenuItem(string3, image);
                    menuItem.setLocation(this.orgx, this.size() * Font.getDefaultFont().getHeight());
                    this.elements.addElement(menuItem);
                }
            } else if (imageArray != null) {
                while (n2 < imageArray.length) {
                    String string4 = null;
                    Image image = imageArray[n2];
                    ++n2;
                    MenuItem menuItem = new MenuItem(string4, image);
                    menuItem.setLocation(this.orgx, this.size() * Font.getDefaultFont().getHeight());
                    this.elements.addElement(menuItem);
                }
            }
            this.init();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public MenuCanvas(Image image, String[] stringArray, Image[] imageArray) {
        this.APP_STOP = 0;
        this.APP_RUN = 1;
        this.APP_PAUSE = 2;
        try {
            AppCanvas.width = this.getWidth();
            AppCanvas.height = this.getHeight();
            this.titleImage = image;
            int n = 0;
            int n2 = 0;
            if (stringArray != null && imageArray != null) {
                while (n < stringArray.length || n2 < imageArray.length) {
                    Image image2;
                    String string;
                    if (n < stringArray.length) {
                        string = stringArray[n];
                        ++n;
                    } else {
                        string = null;
                    }
                    if (n2 < imageArray.length) {
                        image2 = imageArray[n2];
                        ++n2;
                    } else {
                        image2 = null;
                    }
                    MenuItem menuItem = new MenuItem(string, image2);
                    menuItem.setLocation(this.orgx, this.size() * Font.getDefaultFont().getHeight());
                    this.elements.addElement(menuItem);
                }
            } else if (stringArray != null) {
                while (n < stringArray.length) {
                    String string = stringArray[n];
                    ++n;
                    Image image3 = null;
                    MenuItem menuItem = new MenuItem(string, image3);
                    menuItem.setLocation(this.orgx, this.size() * Font.getDefaultFont().getHeight());
                    this.elements.addElement(menuItem);
                }
            } else if (imageArray != null) {
                while (n2 < imageArray.length) {
                    String string = null;
                    Image image4 = imageArray[n2];
                    ++n2;
                    MenuItem menuItem = new MenuItem(string, image4);
                    menuItem.setLocation(this.orgx, this.size() * Font.getDefaultFont().getHeight());
                    this.elements.addElement(menuItem);
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        this.init();
    }

    private void init() {
        try {
            MenuItem.setMarkedColor(0xFFFFFF);
            MenuItem.setUnmarkedColor(0);
            this.itemSpace = 5;
            this.background = Image.createImage((int)AppCanvas.width, (int)AppCanvas.height);
            this.gbck = this.background.getGraphics();
            this.setSelectedIndex(0, true);
            int n = 0;
            Enumeration enumeration = this.elements.elements();
            while (enumeration.hasMoreElements()) {
                MenuItem menuItem = (MenuItem)enumeration.nextElement();
                menuItem.setLocation(this.orgx, this.orgy + n * (Font.getDefaultFont().getHeight() + this.itemSpace));
                ++n;
            }
            this.markerY = this.orgy + this.index * (Font.getDefaultFont().getHeight() + this.itemSpace);
            this.start();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public Graphics getBKGraphics() {
        return this.gbck;
    }

    public void setAlign(int n) {
        this.menuAlign = n;
    }

    public void setBackground(Image image) {
        try {
            this.gbck.drawImage(image, 0, 0, 20);
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
            this.background = null;
        }
    }

    public void setBackground(String string) {
        try {
            Image image = Image.createImage((String)string);
            this.gbck.drawImage(image, 0, 0, 20);
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
            this.background = null;
        }
    }

    public void setInlay(Image image) {
        try {
            this.inlayImage = image;
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
            this.inlayImage = null;
        }
    }

    public void setInlay(String string) {
        try {
            this.inlayImage = Image.createImage((String)string);
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
            this.inlayImage = null;
        }
    }

    public void setMarkerImage(Image image) {
        this.markerImage = image;
    }

    public void setTitle(String string) {
        this.titleString = string;
    }

    public void setOrigin(int n, int n2) {
        this.orgx = n;
        this.orgy = n2;
        int n3 = 0;
        Enumeration enumeration = this.elements.elements();
        while (enumeration.hasMoreElements()) {
            MenuItem menuItem = (MenuItem)enumeration.nextElement();
            menuItem.setLocation(this.orgx, this.orgy + n3 * (Font.getDefaultFont().getHeight() + this.itemSpace));
            ++n3;
        }
        this.markerY = this.orgy + this.index * (Font.getDefaultFont().getHeight() + this.itemSpace);
    }

    public void setTitleLocation(int n, int n2) {
        this.title_x = n;
        this.title_y = n2;
    }

    protected void paint(Graphics graphics) {
        if (this.background != null) {
            graphics.drawImage(this.background, 0, 0, 20);
        }
        if (this.inlayImage != null) {
            graphics.drawImage(this.inlayImage, 0, 0, 20);
        }
        this.drawTitle(graphics);
        Enumeration enumeration = this.elements.elements();
        while (enumeration.hasMoreElements()) {
            MenuItem menuItem = (MenuItem)enumeration.nextElement();
            menuItem.paint(graphics);
        }
        this.drawMarker(graphics);
        super.paint(graphics);
    }

    private void drawTitle(Graphics graphics) {
        try {
            if (this.titleString != null) {
                int n = (AppCanvas.width >> 1) - (Font.getDefaultFont().stringWidth(this.titleString) >> 1);
                graphics.setColor(255, 204, 51);
                graphics.drawString(this.titleString, this.title_x, this.title_y, 20);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    private void drawMarker(Graphics graphics) {
        try {
            if (this.markerImage != null) {
                graphics.drawImage(this.markerImage, this.markerX, this.markerY, 20);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    public void run() {
        while (this.gameThread == Thread.currentThread()) {
            switch (this.appState) {
                case 0: {
                    return;
                }
                case 2: {
                    Object object = this.pauseMonitor;
                    synchronized (object) {
                        try {
                            this.pauseMonitor.wait();
                        }
                        catch (Exception exception) {
                            System.out.println(exception);
                        }
                        break;
                    }
                }
            }
            this.repaint();
            this.serviceRepaints();
            this.pause();
        }
    }

    public void pause() {
        try {
            this.appState = 2;
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void resume() {
        try {
            this.appState = 1;
            Object object = this.pauseMonitor;
            synchronized (object) {
                this.pauseMonitor.notify();
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void stop() {
        try {
            this.resume();
            this.appState = 0;
            this.gameThread.join();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void start() {
        try {
            this.resume();
            this.appState = 1;
            this.gameThread = new Thread(this);
            this.gameThread.start();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void hideNotify() {
        this.pause();
    }

    public void showNotify() {
        this.resume();
    }

    public void keyPressed(int n) {
        super.keyPressed(n);
        switch (n) {
            case -21: {
                MenuItem menuItem = (MenuItem)this.elements.elementAt(this.index);
                menuItem.selectItem();
                break;
            }
        }
        int n2 = this.getGameAction(n);
        switch (n2) {
            case 1: {
                this.setSelectedIndex(this.index, false);
                int n3 = this.index = this.index > 0 ? this.index - 1 : this.size() - 1;
                if (this.index < 0) {
                    this.index = 0;
                }
                this.setSelectedIndex(this.index, true);
                break;
            }
            case 6: {
                this.setSelectedIndex(this.index, false);
                this.index = this.index < this.size() - 1 ? this.index + 1 : 0;
                this.setSelectedIndex(this.index, true);
            }
        }
        this.markerY = this.orgy + this.index * (Font.getDefaultFont().getHeight() + this.itemSpace);
        System.out.println(this.index);
        this.resume();
    }

    private void delay(int n) {
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private void clearScreen(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, 240, 240);
        graphics.setColor(0);
    }

    public void append(String string, Image image) {
        MenuItem menuItem = new MenuItem(string, image);
        this.elements.addElement(menuItem);
    }

    public void append(MenuItem menuItem) {
        menuItem.setLocation(10, this.size() * Font.getDefaultFont().getHeight());
        this.elements.addElement(menuItem);
    }

    public void delete(int n) {
        if (n >= 0 && n < this.elements.size()) {
            this.elements.removeElementAt(n);
        }
    }

    int getSelectedIndex() {
        return this.index;
    }

    public MenuItem getSelectedMenuItem() {
        return (MenuItem)this.elements.elementAt(this.index);
    }

    public boolean isSelected(int n) {
        return n == this.index;
    }

    public void set(int n, String string, Image image) {
        if (n >= 0 && n < this.elements.size()) {
            MenuItem menuItem = (MenuItem)this.elements.elementAt(n);
            menuItem.setName(string);
            menuItem.setIco(image);
        }
    }

    public void setSelectedIndex(int n, boolean bl) {
        if (n >= 0 && n < this.elements.size()) {
            MenuItem menuItem = (MenuItem)this.elements.elementAt(n);
            menuItem.setMarked(bl);
        }
    }

    public void reset() {
        int n = 0;
        Enumeration enumeration = this.elements.elements();
        while (enumeration.hasMoreElements()) {
            MenuItem menuItem = (MenuItem)enumeration.nextElement();
            this.setSelectedIndex(n, false);
            ++n;
        }
        this.setSelectedIndex(0, true);
        this.index = 0;
    }

    public int size() {
        return this.elements.size();
    }
}

