/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui.game;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import org.recompile.mobile.PlatformGraphics;

public class TiledLayer
extends Layer {
    private Image image;
    private Image canvas;
    private PlatformGraphics gc;
    private int rows;
    private int cols;
    private int width;
    private int height;
    private int tileWidth;
    private int tileHeight;
    private int tilesWidth;
    private int tilesHeight;
    private int[] animatedTiles;
    private int animatedTileCount = 0;
    private int[][] tiles;

    public TiledLayer(int colsw, int rowsh, Image baseimage, int tilewidth, int tileheight) {
        System.out.println("Tiled Layer");
        this.setStaticTileSet(baseimage, tilewidth, tileheight);
        this.rows = rowsh;
        this.cols = colsw;
        this.x = 0;
        this.y = 0;
        this.width = this.tileWidth * this.cols;
        this.height = this.tileHeight * this.rows;
        this.canvas = Image.createImage(this.width, this.height);
        this.gc = this.canvas.platformImage.getGraphics();
        this.gc.clearRect(0, 0, this.width, this.height);
        this.animatedTiles = new int[255];
        this.tiles = new int[colsw][rowsh];
    }

    int createAnimatedTile(int staticTileIndex) {
        ++this.animatedTileCount;
        this.animatedTiles[this.animatedTileCount] = staticTileIndex;
        return 0 - this.animatedTileCount;
    }

    public void fillCells(int col, int row, int numCols, int numRows, int tileIndex) {
        for (int c = 0; c < numCols; ++c) {
            for (int r = 0; r < numRows; ++r) {
                this.tiles[col + c][row + r] = tileIndex;
            }
        }
    }

    public int getAnimatedTile(int animatedTileIndex) {
        return this.animatedTiles[0 - animatedTileIndex];
    }

    public int getCell(int col, int row) {
        return this.tiles[col][row];
    }

    public int getCellHeight() {
        return this.tileHeight;
    }

    public int getCellWidth() {
        return this.tileHeight;
    }

    public int getColumns() {
        return this.cols;
    }

    public int getRows() {
        return this.rows;
    }

    @Override
    public void paint(Graphics g) {
        g.drawImage(this.canvas, this.x, this.y, 0);
    }

    private void drawTiles() {
        for (int c = 0; c < this.cols; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                int tile = this.tiles[c][r];
                if (tile < 0) {
                    tile = this.animatedTiles[0 - tile];
                }
                if (tile <= 0) continue;
                this.drawTile(tile, c * this.tileWidth, r * this.tileHeight);
            }
        }
    }

    private void drawTile(int tile, int xdest, int ydest) {
        int r = this.tileHeight * (--tile / this.tilesWidth);
        int c = this.tileWidth * (tile % this.tilesWidth);
        this.gc.drawRegion(this.image, c, r, this.tileWidth, this.tileHeight, 0, xdest, ydest, 0);
    }

    public void setAnimatedTile(int animatedTileIndex, int staticTileIndex) {
        this.animatedTiles[0 - animatedTileIndex] = staticTileIndex;
        for (int c = 0; c < this.cols; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                int tile = this.tiles[c][r];
                if (tile != animatedTileIndex) continue;
                this.drawTile(this.animatedTiles[0 - animatedTileIndex], c * this.tileWidth, r * this.tileHeight);
            }
        }
    }

    public void setCell(int col, int row, int tileIndex) {
        this.tiles[col][row] = tileIndex;
        this.drawTile(tileIndex, col * this.tileWidth, row * this.tileHeight);
    }

    public void setStaticTileSet(Image baseimage, int tilewidth, int tileheight) {
        this.image = baseimage;
        this.tileWidth = tilewidth;
        this.tileHeight = tileheight;
        this.tilesWidth = (int)Math.floor(this.image.getWidth() / tilewidth);
        this.tilesHeight = (int)Math.floor(this.image.getHeight() / tileheight);
    }
}

