/*
 * Decompiled with CFR 0.152.
 */
package org.recompile.freej2me;

import java.awt.image.BufferedImage;
import java.util.List;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Screen;
import javafx.stage.Stage;
import org.recompile.mobile.MIDletLoader;
import org.recompile.mobile.Mobile;
import org.recompile.mobile.MobilePlatform;

public class JavaFx
extends Application {
    private List<String> args;
    private MIDletLoader loader;
    private int lcdWidth = 240;
    private int lcdHeight = 320;
    private BufferedImage mobilelcd;
    private ImageView lcdview;
    private WritableImage[] frames;
    private PixelWriter[] pixelwriters;
    private int currentFrame = 0;
    private Stage stage;
    private boolean needsUpdated = true;
    Rectangle2D screenRect;

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    public void stop() {
        Platform.exit();
        System.exit(0);
    }

    public void start(Stage startStage) {
        this.stage = startStage;
        this.args = this.getParameters().getRaw();
        this.stage.setTitle("FreeJ2ME");
        this.stage.setOnCloseRequest(e -> this.stop());
        this.stage.getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getResourceAsStream("/org/recompile/icon.png")));
        this.screenRect = Screen.getPrimary().getVisualBounds();
        BorderPane Root = new BorderPane();
        BackgroundFill bgfill = new BackgroundFill((Paint)Color.rgb((int)0, (int)0, (int)64), null, null);
        Root.setBackground(new Background(new BackgroundFill[]{bgfill}));
        int argCount = 0;
        for (String arg : this.args) {
            ++argCount;
            System.out.print("Args: ");
            System.out.println(arg);
        }
        if (argCount == 3) {
            this.lcdWidth = Integer.parseInt(this.args.get(1));
            this.lcdHeight = Integer.parseInt(this.args.get(2));
        }
        Mobile.setPlatform(new MobilePlatform(this.lcdWidth, this.lcdHeight));
        this.mobilelcd = Mobile.getPlatform().getLCD();
        this.lcdview = new ImageView();
        this.setLCDViewSize();
        this.lcdview.setSmooth(false);
        this.lcdview.setPreserveRatio(false);
        this.stage.widthProperty().addListener((obs, oldVal, newVal) -> this.setLCDViewSize());
        this.stage.heightProperty().addListener((obs, oldVal, newVal) -> this.setLCDViewSize());
        Root.setCenter((Node)this.lcdview);
        this.frames = new WritableImage[]{new WritableImage(this.lcdWidth, this.lcdHeight), new WritableImage(this.lcdWidth, this.lcdHeight)};
        this.pixelwriters = new PixelWriter[]{this.frames[0].getPixelWriter(), this.frames[1].getPixelWriter()};
        Runnable painter = new Runnable(){

            @Override
            public void run() {
                if (JavaFx.this.needsUpdated) {
                    for (int y = 0; y < JavaFx.this.lcdHeight; ++y) {
                        for (int x = 0; x < JavaFx.this.lcdWidth; ++x) {
                            JavaFx.this.pixelwriters[JavaFx.this.currentFrame].setArgb(x, y, JavaFx.this.mobilelcd.getRGB(x, y));
                        }
                    }
                    JavaFx.this.lcdview.setImage((Image)JavaFx.this.frames[JavaFx.this.currentFrame]);
                    if (JavaFx.this.currentFrame > 0) {
                        JavaFx.this.currentFrame = 0;
                    } else {
                        JavaFx.this.currentFrame = 1;
                    }
                }
            }
        };
        Mobile.getPlatform().setPainter(painter);
        this.stage.setX(this.screenRect.getMinX());
        this.stage.setY(this.screenRect.getMinY());
        this.stage.setWidth(this.screenRect.getWidth());
        this.stage.setHeight(this.screenRect.getHeight());
        this.stage.setScene(new Scene((Parent)Root));
        this.stage.show();
        this.stage.addEventHandler(KeyEvent.KEY_PRESSED, e -> Mobile.getPlatform().keyPressed(this.findKeyCode(e.getCode())));
        this.stage.addEventHandler(KeyEvent.KEY_RELEASED, e -> Mobile.getPlatform().keyReleased(this.findKeyCode(e.getCode())));
        this.lcdview.addEventHandler(MouseEvent.MOUSE_PRESSED, e -> {
            double x = e.getX();
            double y = e.getY();
            double rw = (double)this.lcdWidth / this.lcdview.getFitWidth();
            double rh = (double)this.lcdHeight / this.lcdview.getFitHeight();
            Mobile.getPlatform().pointerPressed((int)(x * rw), (int)(y * rh));
        });
        this.lcdview.addEventHandler(MouseEvent.MOUSE_RELEASED, e -> {
            double x = e.getX();
            double y = e.getY();
            double rw = (double)this.lcdWidth / this.lcdview.getFitWidth();
            double rh = (double)this.lcdHeight / this.lcdview.getFitHeight();
            Mobile.getPlatform().pointerReleased((int)(x * rw), (int)(y * rh));
        });
        if (argCount > 0) {
            if (Mobile.getPlatform().loadJar(this.args.get(0))) {
                Mobile.getPlatform().runJar();
            } else {
                System.out.println("Couldn't load jar...");
            }
        }
    }

    private void setLCDViewSize() {
        double vh;
        double vw = this.stage.getWidth() * 0.9;
        double max = vh = this.stage.getHeight() * 0.9;
        if (vh > vw) {
            max = vw;
        }
        if (this.lcdWidth < this.lcdHeight) {
            this.lcdview.setFitHeight(max);
            this.lcdview.setFitWidth(max * (double)this.lcdWidth / (double)this.lcdHeight);
        } else {
            this.lcdview.setFitWidth(max);
            this.lcdview.setFitHeight(max * (double)this.lcdHeight / (double)this.lcdWidth);
        }
    }

    private int findKeyCode(KeyCode code) {
        if (code == KeyCode.DIGIT0) {
            return 48;
        }
        if (code == KeyCode.DIGIT1) {
            return 49;
        }
        if (code == KeyCode.DIGIT2) {
            return 50;
        }
        if (code == KeyCode.DIGIT3) {
            return 51;
        }
        if (code == KeyCode.DIGIT4) {
            return 52;
        }
        if (code == KeyCode.DIGIT5) {
            return 53;
        }
        if (code == KeyCode.DIGIT6) {
            return 54;
        }
        if (code == KeyCode.DIGIT7) {
            return 55;
        }
        if (code == KeyCode.DIGIT8) {
            return 56;
        }
        if (code == KeyCode.DIGIT9) {
            return 57;
        }
        if (code == KeyCode.ASTERISK) {
            return 42;
        }
        if (code == KeyCode.NUMBER_SIGN) {
            return 35;
        }
        if (code == KeyCode.UP) {
            return 1;
        }
        if (code == KeyCode.DOWN) {
            return 6;
        }
        if (code == KeyCode.LEFT) {
            return 2;
        }
        if (code == KeyCode.RIGHT) {
            return 5;
        }
        if (code == KeyCode.ENTER) {
            return 8;
        }
        if (code == KeyCode.Z) {
            return 9;
        }
        if (code == KeyCode.X) {
            return 10;
        }
        if (code == KeyCode.C) {
            return 11;
        }
        if (code == KeyCode.V) {
            return 12;
        }
        if (code == KeyCode.W) {
            return -1;
        }
        if (code == KeyCode.S) {
            return -2;
        }
        if (code == KeyCode.A) {
            return -3;
        }
        if (code == KeyCode.D) {
            return -4;
        }
        if (code == KeyCode.Q) {
            return -6;
        }
        if (code == KeyCode.E) {
            return -7;
        }
        if (code == KeyCode.R) {
            return -5;
        }
        if (code == KeyCode.M) {
            this.stop();
        }
        if (code == KeyCode.O) {
            this.needsUpdated = true;
        }
        if (code == KeyCode.P) {
            this.needsUpdated = false;
        }
        return 0;
    }
}

