/*
 * Decompiled with CFR 0.152.
 */
package org.recompile.freej2me;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import javax.microedition.lcdui.Graphics;
import org.recompile.mobile.Mobile;
import org.recompile.mobile.PlatformImage;

public class Config {
    public boolean isRunning = false;
    private PlatformImage lcd;
    private Graphics gc;
    private int width;
    private int height;
    private ArrayList<String[]> menu;
    private int menuid = 0;
    private int itemid = 0;
    private File file;
    private String configPath = "";
    private String configFile = "";
    public Runnable onChange;
    HashMap<String, String> settings = new HashMap(4);

    public Config() {
        this.width = Mobile.getPlatform().lcdWidth;
        this.height = Mobile.getPlatform().lcdHeight;
        this.lcd = new PlatformImage(this.width, this.height);
        this.gc = this.lcd.getGraphics();
        this.menu = new ArrayList();
        this.menu.add(new String[]{"Resume Game", "Display Size", "Sound", "Limit FPS", "Nokia", "Rotate", "Exit"});
        this.menu.add(new String[]{"96x65", "128x128", "128x160", "176x208", "208x208", "240x320", "320x240", "240x400", "360x640", "480x800"});
        this.menu.add(new String[]{"Quit", "Main Menu"});
        this.menu.add(new String[]{"On", "Off"});
        this.menu.add(new String[]{"On", "Off"});
        this.menu.add(new String[]{"On", "Off"});
        this.menu.add(new String[]{"Auto", "60 - Fast", "30 - Slow", "15 - Turtle"});
        this.onChange = new Runnable(){

            @Override
            public void run() {
            }
        };
    }

    public void init() {
        String appname = Mobile.getPlatform().loader.suitename;
        this.configPath = Mobile.getPlatform().dataPath + "config/" + appname;
        this.configFile = this.configPath + "/game.conf";
        try {
            Files.createDirectories(Paths.get(this.configPath, new String[0]), new FileAttribute[0]);
        }
        catch (Exception e) {
            System.out.println("Problem Creating Config Path " + this.configPath);
            System.out.println(e.getMessage());
        }
        try {
            this.file = new File(this.configFile);
            if (!this.file.exists()) {
                this.file.createNewFile();
                this.settings.put("width", "" + this.width);
                this.settings.put("height", "" + this.height);
                this.settings.put("sound", "on");
                this.settings.put("nokia", "on");
                this.settings.put("rotate", "off");
                this.settings.put("fps", "0");
                this.saveConfig();
            }
        }
        catch (Exception e) {
            System.out.println("Problem Opening Config " + this.configFile);
            System.out.println(e.getMessage());
        }
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(this.file));
            while ((line = reader.readLine()) != null) {
                String[] parts = line.split(":");
                if (parts.length != 2) continue;
                parts[0] = parts[0].trim();
                parts[1] = parts[1].trim();
                if (parts[0] == "" || parts[1] == "") continue;
                this.settings.put(parts[0], parts[1]);
            }
            if (!this.settings.containsKey("width")) {
                this.settings.put("width", "" + this.width);
            }
            if (!this.settings.containsKey("height")) {
                this.settings.put("height", "" + this.height);
            }
            if (!this.settings.containsKey("sound")) {
                this.settings.put("sound", "on");
            }
            if (!this.settings.containsKey("nokia")) {
                this.settings.put("nokia", "on");
            }
            if (!this.settings.containsKey("rotate")) {
                this.settings.put("rotate", "off");
            }
            if (!this.settings.containsKey("fps")) {
                this.settings.put("fps", "0");
            }
            int w = Integer.parseInt(this.settings.get("width"));
            int h = Integer.parseInt(this.settings.get("height"));
            if (this.width != w || this.height != h) {
                this.width = w;
                this.height = h;
                this.lcd = new PlatformImage(this.width, this.height);
                this.gc = this.lcd.getGraphics();
            }
        }
        catch (Exception e) {
            System.out.println("Problem Reading Config: " + this.configFile);
            System.out.println(e.getMessage());
        }
    }

    private void saveConfig() {
        try {
            FileOutputStream fout = new FileOutputStream(this.file);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(fout));
            for (String key : this.settings.keySet()) {
                writer.write(key + ":" + this.settings.get(key) + "\n");
            }
            writer.close();
        }
        catch (Exception e) {
            System.out.println("Problem Opening Config " + this.configFile);
            System.out.println(e.getMessage());
        }
    }

    public void start() {
        this.isRunning = true;
        this.render();
        Mobile.getPlatform().painter.run();
    }

    public void stop() {
        this.isRunning = false;
        Mobile.getPlatform().painter.run();
    }

    public void keyPressed(int key) {
        switch (key) {
            case 50: {
                --this.itemid;
                break;
            }
            case 56: {
                ++this.itemid;
                break;
            }
            case -1: {
                --this.itemid;
                break;
            }
            case -2: {
                ++this.itemid;
                break;
            }
            case -6: {
                --this.menuid;
                break;
            }
            case 53: {
                this.doMenuAction();
            }
        }
        if (this.menuid < 0) {
            this.menuid = 0;
            this.itemid = 0;
        }
        if (this.itemid >= this.menu.get(this.menuid).length) {
            this.itemid = this.menu.get(this.menuid).length - 1;
        }
        if (this.itemid < 0) {
            this.itemid = 0;
        }
        this.render();
    }

    public void keyReleased(int key) {
    }

    public void mousePressed(int key) {
    }

    public void mouseReleased(int key) {
    }

    public BufferedImage getLCD() {
        return this.lcd.getCanvas();
    }

    public void render() {
        String[] t;
        int ah;
        String title = "Game Options";
        switch (this.menuid) {
            case 1: {
                title = "Screen Size";
                break;
            }
            case 2: {
                title = "Restart Required";
                break;
            }
            case 3: {
                title = "Sound";
            }
        }
        this.gc.setColor(128);
        this.gc.fillRect(0, 0, this.width, this.height);
        this.gc.setColor(0xFFFFFF);
        this.gc.drawString(title, this.width / 2, 2, 1);
        this.gc.drawLine(0, 20, this.width, 20);
        this.gc.drawLine(0, this.height - 20, this.width, this.height - 20);
        if (this.menuid > 0) {
            this.gc.setColor(0xFFFFFF);
            this.gc.drawString("Back", 3, this.height - 17, 4);
        }
        if ((ah = (this.height - 50) / ((t = this.menu.get(this.menuid)).length + 1)) < 15) {
            ah = 15;
        }
        int space = 0;
        if (ah > 15) {
            space = (ah - 15) / 2;
        }
        int max = (int)Math.floor((this.height - 50) / ah);
        int page = (int)Math.floor(this.itemid / max);
        int start = max * page;
        int pages = (int)Math.ceil(t.length / max);
        if (pages >= 1) {
            this.gc.setColor(0xFFFFFF);
            this.gc.drawString("Page " + (page + 1) + " of " + (pages + 1), this.width - 3, this.height - 17, 8);
        }
        int i = start;
        while (i < start + max & i < t.length) {
            String label = t[i];
            if (this.menuid == 0 && i > 1 && i < 7) {
                switch (i) {
                    case 2: {
                        label = label + ": " + this.settings.get("sound");
                        break;
                    }
                    case 3: {
                        label = label + ": " + this.settings.get("fps");
                        break;
                    }
                    case 4: {
                        label = label + ": " + this.settings.get("nokia");
                        break;
                    }
                    case 5: {
                        label = label + ": " + this.settings.get("rotate");
                    }
                }
            }
            if (i == this.itemid) {
                this.gc.setColor(0xFFFF00);
                this.gc.drawString("> " + label + " <", this.width / 2, 25 + space + ah * (i - start), 1);
            } else {
                this.gc.setColor(0xFFFFFF);
                this.gc.drawString(label, this.width / 2, 25 + space + ah * (i - start), 1);
            }
            ++i;
        }
        Mobile.getPlatform().painter.run();
    }

    private void doMenuAction() {
        switch (this.menuid) {
            case 0: {
                switch (this.itemid) {
                    case 0: {
                        this.stop();
                        break;
                    }
                    case 1: {
                        this.menuid = 1;
                        this.itemid = 0;
                        break;
                    }
                    case 2: {
                        this.menuid = 3;
                        this.itemid = 0;
                        break;
                    }
                    case 3: {
                        this.menuid = 6;
                        this.itemid = 0;
                        break;
                    }
                    case 4: {
                        this.menuid = 4;
                        this.itemid = 0;
                        break;
                    }
                    case 5: {
                        this.menuid = 5;
                        this.itemid = 0;
                        break;
                    }
                    case 6: {
                        System.exit(0);
                    }
                }
                break;
            }
            case 1: {
                String[] t = this.menu.get(1)[this.itemid].split("x");
                this.updateDisplaySize(Integer.parseInt(t[0]), Integer.parseInt(t[1]));
                this.menuid = 2;
                this.itemid = 0;
                break;
            }
            case 2: {
                switch (this.itemid) {
                    case 0: {
                        System.exit(0);
                        break;
                    }
                    case 1: {
                        this.menuid = 0;
                        this.itemid = 0;
                    }
                }
                break;
            }
            case 3: {
                if (this.itemid == 0) {
                    this.updateSound("on");
                }
                if (this.itemid == 1) {
                    this.updateSound("off");
                }
                this.menuid = 0;
                this.itemid = 0;
                break;
            }
            case 4: {
                if (this.itemid == 0) {
                    this.updateNokia("on");
                }
                if (this.itemid == 1) {
                    this.updateNokia("off");
                }
                this.menuid = 0;
                this.itemid = 0;
                break;
            }
            case 5: {
                if (this.itemid == 0) {
                    this.updateRotate("on");
                }
                if (this.itemid == 1) {
                    this.updateRotate("off");
                }
                this.menuid = 0;
                this.itemid = 0;
                break;
            }
            case 6: {
                if (this.itemid == 0) {
                    this.updateFPS("0");
                }
                if (this.itemid == 1) {
                    this.updateFPS("60");
                }
                if (this.itemid == 2) {
                    this.updateFPS("30");
                }
                if (this.itemid == 3) {
                    this.updateFPS("15");
                }
                this.menuid = 0;
                this.itemid = 0;
            }
        }
        this.render();
    }

    private void updateDisplaySize(int w, int h) {
        this.settings.put("width", "" + w);
        this.settings.put("height", "" + h);
        this.saveConfig();
        this.onChange.run();
        this.width = w;
        this.height = h;
        this.lcd = new PlatformImage(this.width, this.height);
        this.gc = this.lcd.getGraphics();
    }

    private void updateSound(String value) {
        System.out.println("Config: sound " + value);
        this.settings.put("sound", value);
        this.saveConfig();
        this.onChange.run();
    }

    private void updateNokia(String value) {
        System.out.println("Config: nokia " + value);
        this.settings.put("nokia", value);
        this.saveConfig();
        this.onChange.run();
    }

    private void updateRotate(String value) {
        System.out.println("Config: rotate " + value);
        this.settings.put("rotate", value);
        this.saveConfig();
        this.onChange.run();
    }

    private void updateFPS(String value) {
        System.out.println("Config: fps " + value);
        this.settings.put("fps", value);
        this.saveConfig();
        this.onChange.run();
    }
}

