/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import org.recompile.mobile.Mobile;
import org.recompile.mobile.PlatformImage;

public abstract class Canvas
extends Displayable {
    public static final int UP = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 5;
    public static final int DOWN = 6;
    public static final int FIRE = 8;
    public static final int GAME_A = 9;
    public static final int GAME_B = 10;
    public static final int GAME_C = 11;
    public static final int GAME_D = 12;
    public static final int KEY_NUM0 = 48;
    public static final int KEY_NUM1 = 49;
    public static final int KEY_NUM2 = 50;
    public static final int KEY_NUM3 = 51;
    public static final int KEY_NUM4 = 52;
    public static final int KEY_NUM5 = 53;
    public static final int KEY_NUM6 = 54;
    public static final int KEY_NUM7 = 55;
    public static final int KEY_NUM8 = 56;
    public static final int KEY_NUM9 = 57;
    public static final int KEY_STAR = 42;
    public static final int KEY_POUND = 35;

    protected Canvas() {
        this.width = Mobile.getPlatform().lcdWidth;
        this.height = Mobile.getPlatform().lcdHeight;
        System.out.println("Create Canvas:" + this.width + ", " + this.height);
        this.platformImage = new PlatformImage(this.width, this.height);
    }

    public int getGameAction(int keyCode) {
        switch (keyCode) {
            case 50: {
                return 1;
            }
            case 56: {
                return 6;
            }
            case 52: {
                return 2;
            }
            case 54: {
                return 5;
            }
            case 53: {
                return 8;
            }
            case 49: {
                return 9;
            }
            case 51: {
                return 10;
            }
            case 55: {
                return 11;
            }
            case 57: {
                return 12;
            }
            case -1: {
                return 1;
            }
            case -2: {
                return 6;
            }
            case -3: {
                return 2;
            }
            case -4: {
                return 5;
            }
        }
        return 0;
    }

    public int getKeyCode(int gameAction) {
        switch (gameAction) {
            case 1: {
                return -1;
            }
            case 6: {
                return -2;
            }
            case 2: {
                return -3;
            }
            case 5: {
                return -4;
            }
            case 8: {
                return 53;
            }
            case 9: {
                return 49;
            }
            case 10: {
                return 51;
            }
            case 11: {
                return 55;
            }
            case 12: {
                return 57;
            }
        }
        return 53;
    }

    public String getKeyName(int keyCode) {
        if (keyCode < 0) {
            keyCode = 0 - keyCode;
        }
        switch (keyCode) {
            case 1: {
                return "UP";
            }
            case 2: {
                return "DOWN";
            }
            case 5: {
                return "LEFT";
            }
            case 6: {
                return "RIGHT";
            }
            case 8: {
                return "FIRE";
            }
            case 9: {
                return "A";
            }
            case 10: {
                return "B";
            }
            case 11: {
                return "C";
            }
            case 12: {
                return "D";
            }
            case 48: {
                return "0";
            }
            case 49: {
                return "1";
            }
            case 50: {
                return "2";
            }
            case 51: {
                return "3";
            }
            case 52: {
                return "4";
            }
            case 53: {
                return "5";
            }
            case 54: {
                return "6";
            }
            case 55: {
                return "7";
            }
            case 56: {
                return "8";
            }
            case 57: {
                return "9";
            }
            case 42: {
                return "*";
            }
            case 35: {
                return "#";
            }
        }
        return "-";
    }

    public boolean hasPointerEvents() {
        return true;
    }

    public boolean hasPointerMotionEvents() {
        return false;
    }

    public boolean hasRepeatEvents() {
        return false;
    }

    @Override
    public void hideNotify() {
    }

    public boolean isDoubleBuffered() {
        return true;
    }

    @Override
    public void keyPressed(int keyCode) {
    }

    @Override
    public void keyReleased(int keyCode) {
    }

    public void keyRepeated(int keyCode) {
    }

    protected abstract void paint(Graphics var1);

    @Override
    public void pointerDragged(int x, int y) {
    }

    @Override
    public void pointerPressed(int x, int y) {
    }

    @Override
    public void pointerReleased(int x, int y) {
    }

    public void repaint() {
        try {
            this.paint(this.platformImage.getGraphics());
            Mobile.getPlatform().repaint(this.platformImage, 0, 0, this.width, this.height);
        }
        catch (Exception e) {
            System.out.print("Canvas repaint(): " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void repaint(int x, int y, int width, int height) {
        this.paint(this.platformImage.getGraphics());
        Mobile.getPlatform().repaint(this.platformImage, x, y, width, height);
    }

    public void serviceRepaints() {
        Mobile.getPlatform().repaint(this.platformImage, 0, 0, this.width, this.height);
    }

    public void setFullScreenMode(boolean mode) {
        this.fullScreen = mode;
        if (this.fullScreen) {
            this.width = Mobile.getPlatform().lcdWidth;
            this.height = Mobile.getPlatform().lcdHeight;
        }
    }

    @Override
    public void showNotify() {
    }

    @Override
    protected void sizeChanged(int w, int h) {
        this.width = w;
        this.height = h;
    }

    @Override
    public void notifySetCurrent() {
        this.repaint();
    }
}

