/*
 * Decompiled with CFR 0.152.
 */
package code.Collision;

import code.Collision.Height;
import code.Math.MathUtils2;
import code.Math.Matrix;
import code.Math.Vector3D;
import code.Rendering.DirectX7;
import code.Rendering.Meshes.Mesh;
import code.Rendering.Meshes.Polygon3V;
import code.Rendering.Meshes.Polygon4V;
import code.Rendering.RenderObject;
import code.Rendering.Texture;
import code.Rendering.Vertex;

public class HeightComputer {
    private static final Vector3D nor = new Vector3D();
    private static final Height height = new Height();

    public static boolean isPointAABBCollision(int x, int z, int minx, int maxx, int minz, int maxz) {
        return x >= minx && z >= minz && x <= maxx && z <= maxz;
    }

    public static int computeHeight(Mesh mesh, int x, int y, int z) {
        height.reset();
        height.getPosition().set(x, y, z);
        HeightComputer.computeHeight(mesh, height);
        return height.getHeight();
    }

    public static void computeHeight(Mesh mesh, Matrix matrix, Height height) {
        HeightComputer.computeHeight(mesh, matrix, height, true);
    }

    public static void computeHeight(Mesh mesh, Height height) {
        HeightComputer.computeHeight(mesh, null, height, true);
    }

    public static void computeHeight(Mesh mesh, Matrix matrix, Height height, boolean updatePos) {
        if (matrix != null) {
            DirectX7.transformSave(mesh, matrix);
        }
        RenderObject[] polygons = mesh.getPolygons();
        Vector3D pos = height.getPosition();
        int x = pos.x;
        int y = pos.y;
        int z = pos.z;
        for (int i = 0; i < polygons.length; ++i) {
            Vertex c;
            Vertex b;
            Vertex a;
            RenderObject p;
            RenderObject el = polygons[i];
            int polyY = Integer.MAX_VALUE;
            int cx = Integer.MAX_VALUE;
            int cz = Integer.MAX_VALUE;
            int cy = Integer.MAX_VALUE;
            int mat = -1;
            if (el instanceof Polygon4V) {
                int minz;
                int maxz;
                int minx;
                p = (Polygon4V)el;
                a = p.a;
                b = p.b;
                c = p.c;
                Vertex d = p.d;
                mat = p.tex;
                int ax = a.x;
                int az = a.z;
                int bx = b.x;
                int bz = b.z;
                int dx = d.x;
                int dz = d.z;
                int maxx = ax;
                if (bx > maxx) {
                    maxx = bx;
                }
                if (c.x > maxx) {
                    maxx = c.x;
                }
                if (dx > maxx) {
                    maxx = dx;
                }
                if (bx < (minx = ax)) {
                    minx = bx;
                }
                if (c.x < minx) {
                    minx = c.x;
                }
                if (dx < minx) {
                    minx = dx;
                }
                if (bz > (maxz = az)) {
                    maxz = bz;
                }
                if (c.z > maxz) {
                    maxz = c.z;
                }
                if (dz > maxz) {
                    maxz = dz;
                }
                if (bz < (minz = az)) {
                    minz = bz;
                }
                if (c.z < minz) {
                    minz = c.z;
                }
                if (dz < minz) {
                    minz = dz;
                }
                if (minx > x || minz > z || maxx < x || maxz < z) continue;
                if (el.ny >= 0) {
                    if (el.ny <= 2048 || a.y + b.y + c.y + d.y >> 2 <= y) continue;
                    height.setUnderRoof(true);
                    continue;
                }
                if (MathUtils2.isPointOnPolygon(x, z, ax, az, bx, bz, c.x, c.z, dx, dz, p.ny)) {
                    polyY = y - ((x - ax) * p.nx + (y - a.y) * p.ny + (z - az) * p.nz) / p.ny;
                    cx = ax + bx + c.x + dx >> 2;
                    cz = az + bz + c.z + dz >> 2;
                    cy = a.y + b.y + c.y + d.y >> 2;
                }
            } else if (el instanceof Polygon3V) {
                int minz;
                int maxz;
                int minx;
                p = (Polygon3V)el;
                a = ((Polygon3V)p).a;
                b = ((Polygon3V)p).b;
                c = ((Polygon3V)p).c;
                mat = ((Polygon3V)p).tex;
                int ax = a.x;
                int az = a.z;
                int bx = b.x;
                int bz = b.z;
                int maxx = ax;
                if (bx > maxx) {
                    maxx = bx;
                }
                if (c.x > maxx) {
                    maxx = c.x;
                }
                if (bx < (minx = ax)) {
                    minx = bx;
                }
                if (c.x < minx) {
                    minx = c.x;
                }
                if (bz > (maxz = az)) {
                    maxz = bz;
                }
                if (c.z > maxz) {
                    maxz = c.z;
                }
                if (bz < (minz = az)) {
                    minz = bz;
                }
                if (c.z < minz) {
                    minz = c.z;
                }
                if (minx > x || minz > z || maxx < x || maxz < z) continue;
                if (el.ny >= 0) {
                    if (el.ny <= 2048 || (a.y + b.y + c.y) / 3 <= y) continue;
                    height.setUnderRoof(true);
                    continue;
                }
                if (MathUtils2.isPointOnPolygon(x, z, a.x, a.z, b.x, b.z, c.x, c.z, ((Polygon3V)p).ny)) {
                    polyY = y - ((x - ax) * ((Polygon3V)p).nx + (y - a.y) * ((Polygon3V)p).ny + (z - az) * ((Polygon3V)p).nz) / ((Polygon3V)p).ny;
                    cx = (a.x + b.x + c.x) / 3;
                    cz = (a.z + b.z + c.z) / 3;
                    cy = (a.y + b.y + c.y) / 3;
                }
            }
            if (mat != -1) {
                Texture tex = mesh.getTexture().textures[mat];
                if (!tex.collision) continue;
            }
            if (polyY >= y || polyY <= height.getHeight()) continue;
            height.set(polyY, el, cx, cz, cy, matrix, updatePos);
        }
    }
}

