/*
 * Decompiled with CFR 0.152.
 */
package code.Gameplay.Inventory;

import code.Gameplay.Inventory.ItemsEngine;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ItemList {
    private int[] items;
    private int[] itemsCount;
    private int maxItems = 0;

    public ItemList() {
        this.set(16);
    }

    public ItemList(int startSize) {
        this.set(startSize);
    }

    private void set(int count) {
        this.items = new int[count];
        this.itemsCount = new int[count];
        this.maxItems = 0;
    }

    public void addItem(String name, int count) {
        this.addItem(ItemsEngine.getItemId(name), count);
    }

    public void addItem(int id, int count) {
        if (count <= 0) {
            return;
        }
        for (int i = 0; i < this.maxItems; ++i) {
            if (this.items[i] != id) continue;
            int n = i;
            this.itemsCount[n] = this.itemsCount[n] + count;
            return;
        }
        if (this.maxItems >= this.items.length) {
            int[] newItems = new int[this.items.length / 64 * 64 + 64];
            int[] newItemsCount = new int[newItems.length];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            System.arraycopy(this.itemsCount, 0, newItemsCount, 0, this.itemsCount.length);
            this.items = newItems;
            this.itemsCount = newItemsCount;
        }
        this.items[this.maxItems] = id;
        this.itemsCount[this.maxItems] = count;
        ++this.maxItems;
    }

    public void removeItem(String name, int count) {
        this.removeItem(ItemsEngine.getItemId(name), count);
    }

    public void removeItem(int id, int count) {
        if (count <= 0) {
            return;
        }
        for (int i = 0; i < this.maxItems; ++i) {
            if (this.items[i] != id) continue;
            int n = i;
            this.itemsCount[n] = this.itemsCount[n] - count;
            if (this.itemsCount[i] <= 0) {
                --this.maxItems;
                this.items[i] = this.items[this.maxItems];
                this.itemsCount[i] = this.itemsCount[this.maxItems];
            }
            return;
        }
    }

    public int itemsCount(String name) {
        return this.itemsCount(ItemsEngine.getItemId(name));
    }

    public int itemsCount(int id) {
        int count = 0;
        for (int i = 0; i < this.maxItems; ++i) {
            if (this.items[i] != id) continue;
            count += this.itemsCount[i];
        }
        return count;
    }

    public int size() {
        return this.maxItems;
    }

    public int itemAt(int id) {
        return this.items[id];
    }

    public int itemAtCount(int id) {
        return this.itemsCount[id];
    }

    public void writeSave(DataOutputStream dos) throws IOException {
        dos.writeInt(this.maxItems);
        for (int i = 0; i < this.maxItems; ++i) {
            dos.writeInt(this.items[i]);
            dos.writeInt(this.itemsCount[i]);
        }
    }

    public void loadSave(DataInputStream dis) throws IOException {
        this.maxItems = dis.readInt();
        if (this.items.length < this.maxItems) {
            this.items = new int[this.maxItems / 16 * 16 + 16];
            this.itemsCount = new int[this.items.length];
        }
        for (int i = 0; i < this.maxItems; ++i) {
            this.items[i] = dis.readInt();
            this.itemsCount[i] = dis.readInt();
        }
    }
}

