/*
 * Decompiled with CFR 0.152.
 */
package code.Gameplay.Map;

import code.Collision.Height;
import code.Collision.Ray;
import code.Gameplay.Map.Light;
import code.Gameplay.Map.Portal;
import code.Gameplay.Map.Room;
import code.Gameplay.Map.RoomObject;
import code.Gameplay.Map.Skybox;
import code.Gameplay.Objects.MeshObject;
import code.HUD.DeveloperMenu;
import code.Math.Matrix;
import code.Math.Vector3D;
import code.Rendering.DirectX7;
import code.Rendering.Texture;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public final class House {
    public static boolean l2dRoomRendering;
    public static boolean boxRoomTesting;
    private Room[] rooms;
    private Room[][] neighbours;
    private Vector roomsToRender = new Vector();
    private final Vector renderedPortals = new Vector();
    private Skybox skybox;
    private final Vector tVec = new Vector();
    private final Vector tVec2 = new Vector();
    private final Vector tmpObj = new Vector();

    public House(Room[] rooms, Room[][] neighbours) {
        this.rooms = rooms;
        this.neighbours = neighbours;
    }

    public final void destroy() {
        for (int i = 0; i < this.rooms.length; ++i) {
            this.rooms[i].destroy();
            this.rooms[i] = null;
        }
        this.rooms = null;
        this.neighbours = null;
        this.roomsToRender.removeAllElements();
        this.renderedPortals.removeAllElements();
        this.roomsToRender = null;
        if (this.skybox != null) {
            this.skybox.destroy();
            this.skybox = null;
        }
        this.tVec.removeAllElements();
        this.tVec2.removeAllElements();
        this.tmpObj.removeAllElements();
    }

    public final void setTexture(Texture texture) {
        for (int i = 0; i < this.rooms.length; ++i) {
            this.rooms[i].getMesh().setTexture(texture);
        }
    }

    public final void setSkybox(Skybox skybox) {
        this.skybox = skybox;
    }

    public final Skybox getSkybox() {
        return this.skybox;
    }

    public final Room[] getRooms() {
        return this.rooms;
    }

    public final Room[] getNeighbourRooms(int part) {
        return this.neighbours[part];
    }

    private Vector getNearRooms(int part) {
        this.roomsToRender.removeAllElements();
        if (part != -1) {
            if (this.rooms[part] != null) {
                this.roomsToRender.addElement(this.rooms[part]);
            }
            Room[] nei = this.neighbours[part];
            for (int i = 0; i < nei.length; ++i) {
                if (nei[i] == null) continue;
                this.roomsToRender.addElement(nei[i]);
            }
        }
        return this.roomsToRender;
    }

    public final boolean sphereCast(int part, Vector3D pos, int rad) {
        int i;
        boolean col = false;
        Vector nearRms = this.getNearRooms(part);
        if (nearRms.size() > 0) {
            for (i = 0; i < nearRms.size(); ++i) {
                Room room = (Room)nearRms.elementAt(i);
                col |= room.sphereCast(pos, rad);
            }
        }
        this.getNearObjects(this.tVec, part);
        if (this.tVec.size() >= 1) {
            for (i = 0; i < this.tVec.size(); ++i) {
                Object obj = this.tVec.elementAt(i);
                if (!(obj instanceof MeshObject)) continue;
                MeshObject point = (MeshObject)obj;
                if (!point.precCol) continue;
                col |= point.sphereCollisionTest(pos, rad);
            }
        }
        return col;
    }

    public final boolean sphereCast(int[] parts, Vector3D pos, int rad) {
        int i;
        this.renderedPortals.removeAllElements();
        boolean col = false;
        for (i = 0; i < parts.length; ++i) {
            int part = parts[i];
            Vector nearRms = this.getNearRooms(part);
            if (nearRms.size() < 1) continue;
            for (int i2 = 0; i2 < nearRms.size(); ++i2) {
                Room room = (Room)nearRms.elementAt(i2);
                if (this.renderedPortals.contains(room)) continue;
                col |= room.sphereCast(pos, rad);
                this.renderedPortals.addElement(room);
            }
        }
        this.getNearObjects(this.tVec, parts[0]);
        if (this.tVec.size() >= 1) {
            for (i = 0; i < this.tVec.size(); ++i) {
                Object obj = this.tVec.elementAt(i);
                if (!(obj instanceof MeshObject)) continue;
                MeshObject point = (MeshObject)obj;
                if (!point.precCol) continue;
                col |= point.sphereCollisionTest(pos, rad);
            }
        }
        return col;
    }

    public final void rayCast(int part, Ray ray, boolean rayIsFromWeapons) {
        int i;
        if (part == -1) {
            return;
        }
        Vector nearRms = this.getNearRooms(part);
        for (i = 0; i < nearRms.size(); ++i) {
            ((Room)nearRms.elementAt(i)).rayCast(ray);
        }
        this.getNearObjects(this.tVec, part);
        for (i = 0; i < this.tVec.size(); ++i) {
            Object obj = this.tVec.elementAt(i);
            if (!(obj instanceof MeshObject)) continue;
            MeshObject point = (MeshObject)obj;
            if (!point.precCol || rayIsFromWeapons && point.ignoreWeaponRayCast) continue;
            point.rayCast(ray);
        }
    }

    public final void rayCastNoObjects(int part, Ray ray) {
        if (part == -1) {
            return;
        }
        Vector nearRms = this.getNearRooms(part);
        for (int i = 0; i < nearRms.size(); ++i) {
            ((Room)nearRms.elementAt(i)).rayCast(ray);
        }
    }

    public void computeHeight(int part, Height height) {
        if (part == -1) {
            return;
        }
        this.rooms[part].computeHeight(height);
        Room[] near = this.neighbours[part];
        for (int i = 0; i < near.length; ++i) {
            if (near[i] == null) continue;
            near[i].computeHeight(height);
        }
    }

    public void computeHeightFull(int part, Height height) {
        if (part == -1) {
            return;
        }
        this.computeHeight(part, height);
        this.getNearObjects(this.tVec, part);
        for (int i = 0; i < this.tVec.size(); ++i) {
            Object obj = this.tVec.elementAt(i);
            if (!(obj instanceof MeshObject)) continue;
            MeshObject point = (MeshObject)obj;
            if (!point.precCol) continue;
            point.computeHeight(height);
        }
    }

    public final void getNearObjects(Vector buf, int part) {
        buf.removeAllElements();
        if (part == -1) {
            return;
        }
        if (this.rooms.length == 1) {
            Vector list2 = this.rooms[0].getObjects();
            for (int i = list2.size() - 1; i >= 0; --i) {
                buf.addElement(list2.elementAt(i));
            }
            return;
        }
        this.rooms[part].getObjects(buf);
        Room[] near = this.neighbours[part];
        for (int i = 0; i < near.length; ++i) {
            if (near[i] == null) continue;
            near[i].getObjects(buf);
        }
    }

    public final Vector getNearObjects(int part) {
        this.tmpObj.removeAllElements();
        if (part == -1) {
            return this.tmpObj;
        }
        if (this.rooms.length == 1) {
            Vector list2 = this.rooms[0].getObjects();
            for (int i = list2.size() - 1; i >= 0; --i) {
                this.tmpObj.addElement(list2.elementAt(i));
            }
            return this.tmpObj;
        }
        this.rooms[part].getObjects(this.tmpObj);
        Room[] near = this.neighbours[part];
        if (near == null) {
            return this.tmpObj;
        }
        for (int i = 0; i < near.length; ++i) {
            if (near[i] == null) continue;
            near[i].getObjects(this.tmpObj);
        }
        return this.tmpObj;
    }

    private final void renderSkybox(Graphics g, DirectX7 g3d) {
        if (this.skybox != null && (this.skybox.draw || this.skybox.skyboxAlways)) {
            this.skybox.render(g, g3d);
            g3d.render();
            this.skybox.resetViewport();
        }
    }

    public final int render(Graphics g, DirectX7 g3d, int[] part, int cx, int cz) {
        int x;
        this.renderSkybox(g, g3d);
        if (part.length == 0) {
            return 0;
        }
        this.roomsToRender.removeAllElements();
        this.renderedPortals.removeAllElements();
        for (x = part.length - 1; x >= 0; --x) {
            if (part[x] == -1) continue;
            this.renderRoom(g3d, this.rooms[part[x]], 0, 0, g3d.getWidth(), g3d.getHeight(), cx, cz, false);
        }
        if (this.roomsToRender.size() > 0) {
            for (x = 0; x < this.roomsToRender.size(); ++x) {
                Room room = (Room)this.roomsToRender.elementAt(x);
                room.render(g3d, cx, cz);
                room.renderObjects(g3d);
            }
        }
        return this.roomsToRender.size();
    }

    public final int render(Graphics g, DirectX7 g3d, int part, int cx, int cz) {
        this.renderSkybox(g, g3d);
        if (part == -1) {
            return 0;
        }
        this.roomsToRender.removeAllElements();
        this.renderedPortals.removeAllElements();
        this.renderRoom(g3d, this.rooms[part], 0, 0, g3d.getWidth(), g3d.getHeight(), cx, cz, false);
        for (int i = 0; i < this.roomsToRender.size(); ++i) {
            Room room = (Room)this.roomsToRender.elementAt(i);
            room.render(g3d, cx, cz);
            room.renderObjects(g3d);
        }
        return this.roomsToRender.size();
    }

    private void renderRoom(DirectX7 g3d, Room mainRoom, int x1, int y1, int x2, int y2, int cx, int cz, boolean renderRooms) {
        Portal[] portals;
        if (mainRoom == null) {
            return;
        }
        if (!this.roomsToRender.contains(mainRoom)) {
            this.roomsToRender.addElement(mainRoom);
            mainRoom.setViewport(x1, y1, x2, y2);
        } else {
            mainRoom.addViewport(x1, y1, x2, y2);
        }
        if (renderRooms) {
            mainRoom.render(g3d, cx, cz);
        }
        if (mainRoom.isOpenSky() && this.skybox != null) {
            this.skybox.addViewport(x1, y1, x2, y2);
            this.skybox.draw = true;
        }
        if ((portals = mainRoom.getPortals()) == null) {
            return;
        }
        if (portals.length == 0) {
            return;
        }
        for (int i = 0; i < portals.length; ++i) {
            Portal portal = portals[i];
            if (!portal.isVisible(g3d, x1, y1, x2, y2)) continue;
            Room room = portal.getRoom();
            boolean renderedBefore = this.roomsToRender.contains(room);
            int pMinX = portal.getMinX();
            int pMinY = portal.getMinY();
            int pMaxX = portal.getMaxX();
            int pMaxY = portal.getMaxY();
            if (pMinX < x1) {
                pMinX = x1;
            }
            if (pMinY < y1) {
                pMinY = y1;
            }
            if (pMaxX > x2) {
                pMaxX = x2;
            }
            if (pMaxY > y2) {
                pMaxY = y2;
            }
            int sizex = pMaxX - pMinX;
            int sizey = pMaxY - pMinY;
            if (sizex <= 0 || sizey <= 0) continue;
            if (!this.renderedPortals.contains(portal)) {
                this.renderedPortals.addElement(portal);
            }
            if (room != null) {
                if (renderedBefore && room.viewportContains(pMinX, pMinY, pMaxX, pMaxY)) continue;
                this.renderRoom(g3d, room, pMinX, pMinY, pMaxX, pMaxY, cx, cz, renderRooms);
                continue;
            }
            if (this.skybox == null) continue;
            this.skybox.addViewport(pMinX, pMinY, pMaxX, pMaxY);
            this.skybox.draw = true;
        }
    }

    public void drawPortals(Graphics g, int x, int y) {
        int i;
        for (i = 0; i < this.renderedPortals.size(); ++i) {
            Portal p = (Portal)this.renderedPortals.elementAt(i);
            p.paint(g, x, y);
        }
        for (i = 0; i < this.roomsToRender.size(); ++i) {
            Room room = (Room)this.roomsToRender.elementAt(i);
            room.paint(g, x, y);
        }
    }

    public final Vector getObjects() {
        this.tVec2.removeAllElements();
        for (int i = 0; i < this.rooms.length; ++i) {
            this.rooms[i].getObjects(this.tVec2);
        }
        return this.tVec2;
    }

    public void addObject(RoomObject obj) {
        this.recomputePart(obj);
        if (obj.getPart() == -1) {
            this.recomputePart(obj, false);
        }
        if (obj.getPart() == -1 && DeveloperMenu.debugMode) {
            System.out.println("House: \u041e\u0431\u044a\u0435\u043a\u0442 " + obj.toString() + " \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432\u043d\u0435 \u043a\u0430\u0440\u0442\u044b \u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d");
            System.out.println(obj.getPosX() + " " + obj.getPosY() + " " + obj.getPosZ());
        }
    }

    public void removeObject(RoomObject obj) {
        if (obj.getPart() == -1) {
            return;
        }
        this.rooms[obj.getPart()].removeObject(obj);
    }

    public void recomputePart(RoomObject obj) {
        this.recomputePart(obj, true);
    }

    public void recomputePart(RoomObject obj, boolean rayCast) {
        if (!obj.isNeedRecomputePart()) {
            return;
        }
        int x = obj.getPosX();
        int z = obj.getPosZ();
        int y = obj.getPosY();
        int oldPart = obj.getPart();
        int newPart = this.calcPart(oldPart, x, y, z, rayCast);
        if (obj.getNewPart() != -1) {
            newPart = obj.getNewPart();
            obj.setNewPart(-1);
        }
        if (newPart == -1) {
            newPart = oldPart;
        }
        if (newPart != -1 && (newPart != oldPart || oldPart == -1)) {
            if (oldPart != -1) {
                this.rooms[oldPart].removeObject(obj);
            }
            this.rooms[newPart].addObject(obj);
            obj.setPart(newPart);
        }
    }

    public int calcPart(int oldPart, int x, int y, int z) {
        return this.calcPart(oldPart, x, y, z, true);
    }

    public int calcPart(int oldPart, int x, int y, int z, boolean rayCast) {
        if (this.rooms.length == 1) {
            return 0;
        }
        if (oldPart != -1) {
            if (rayCast && this.rooms[oldPart].isPointOnMesh(x, y, z) != -1) {
                return oldPart;
            }
            if (!rayCast && this.rooms[oldPart].isPointInRoomBox(x, y, z)) {
                return oldPart;
            }
            Room[] neighbours2 = this.neighbours[oldPart];
            for (int i = 0; i < neighbours2.length; ++i) {
                Room room = neighbours2[i];
                if (room == null) continue;
                if (rayCast && room.isPointOnMesh(x, y, z) != -1) {
                    return room.getId();
                }
                if (rayCast || !room.isPointInRoomBox(x, y, z)) continue;
                return room.getId();
            }
        }
        for (int i = 0; i < this.rooms.length; ++i) {
            Room room = this.rooms[i];
            if (rayCast && room.isPointOnMesh(x, y, z) != -1) {
                return i;
            }
            if (rayCast || !room.isPointInRoomBox(x, y, z)) continue;
            return i;
        }
        return -1;
    }

    public static int[] getParts(House house, int part, Matrix cam) {
        if (part == -1) {
            return new int[]{0};
        }
        Room[] rooms = house.getNeighbourRooms(part);
        if (rooms == null || rooms.length == 0) {
            return new int[]{part};
        }
        int[] out = new int[rooms.length + 1];
        out[0] = part;
        int roomsCount = 1;
        int x = cam.m03;
        int y = cam.m13;
        int z = cam.m23;
        for (int i = 0; i < rooms.length; ++i) {
            Room room = rooms[i];
            if (!boxRoomTesting && room.isPointOnMesh(x, y, z) != -1) {
                out[roomsCount] = room.getId();
                ++roomsCount;
                continue;
            }
            if (!boxRoomTesting || !room.isPointInRoomBox(x, y, z)) continue;
            out[roomsCount] = room.getId();
            ++roomsCount;
        }
        int[] out2 = new int[roomsCount];
        System.arraycopy(out, 0, out2, 0, roomsCount);
        return out2;
    }

    public boolean isNear(int id1, int id2) {
        if (id1 == -1 || id2 == -1) {
            return false;
        }
        if (id1 == id2) {
            return true;
        }
        if (id1 >= this.neighbours.length) {
            return false;
        }
        Room[] rooms = this.neighbours[id1];
        if (rooms == null) {
            return false;
        }
        for (int i = 0; i < rooms.length; ++i) {
            Room room = rooms[i];
            if (room == null || room.getId() != id2) continue;
            return true;
        }
        return false;
    }

    public void sortLights(Light[] lights) {
        for (int i = 0; i < lights.length; ++i) {
            if (lights[i].part != -1) continue;
            lights[i].part = this.calcPart(-1, lights[i].pos.x, lights[i].pos.y, lights[i].pos.z);
        }
        Vector<Light> lits = new Vector<Light>();
        for (int i = 0; i < this.rooms.length; ++i) {
            int x;
            Room room = this.rooms[i];
            if (room == null) continue;
            lits.removeAllElements();
            int id = room.getId();
            for (x = 0; x < lights.length; ++x) {
                if (!this.isNear(id, lights[x].part)) continue;
                lits.addElement(lights[x]);
            }
            if (lits.size() <= 0) continue;
            room.lights = new Light[lits.size()];
            for (x = 0; x < lits.size(); ++x) {
                room.lights[x] = (Light)lits.elementAt(x);
            }
        }
    }
}

