/*
 * Decompiled with CFR 0.152.
 */
package code.Rendering.Meshes;

import code.Math.MathUtils;
import code.Rendering.DirectX7;
import code.Rendering.Meshes.Polygon4V;
import code.Rendering.Texture;
import code.Rendering.TexturingAffine;
import code.Rendering.TexturingPers;
import code.Rendering.Vertex;
import code.utils.Main;

public class ColorLightedPolygon4V
extends Polygon4V {
    public volatile byte ar;
    public volatile byte ag;
    public volatile byte ab;
    public volatile byte br;
    public volatile byte bg;
    public volatile byte bb;
    public volatile byte cr;
    public volatile byte cg;
    public volatile byte cb;
    public volatile byte dr;
    public volatile byte dg;
    public volatile byte db;
    private static int q;
    private static int sz2;
    private static short sizex;
    private static short sizey;
    private static short sizeu;
    private static short sizev;
    private static byte addmip;
    private static byte fog;

    public ColorLightedPolygon4V(ColorLightedPolygon4V p) {
        super(p);
        this.ar = p.ar;
        this.ag = p.ag;
        this.ab = p.ab;
        this.br = p.br;
        this.bg = p.bg;
        this.bb = p.bb;
        this.cr = p.cr;
        this.cg = p.cg;
        this.cb = p.cb;
        this.dr = p.dr;
        this.dg = p.dg;
        this.db = p.db;
    }

    public ColorLightedPolygon4V(Vertex a2, Vertex b2, Vertex c2, Vertex d2, byte au, byte av, byte bu, byte bv, byte cu, byte cv, byte du, byte dv) {
        super(a2, b2, c2, d2, au, av, bu, bv, cu, cv, du, dv);
        this.db = (byte)127;
        this.dg = (byte)127;
        this.dr = (byte)127;
        this.cb = (byte)127;
        this.cg = (byte)127;
        this.cr = (byte)127;
        this.bb = (byte)127;
        this.bg = (byte)127;
        this.br = (byte)127;
        this.ab = (byte)127;
        this.ag = (byte)127;
        this.ar = (byte)127;
    }

    public final void render(DirectX7 g3d, Texture texture) {
        boolean pers;
        if (Main.persQ == 0 && !Main.mipMapping) {
            this.renderFast(g3d, texture);
            return;
        }
        fog = texture.drawmode;
        sizex = (short)ColorLightedPolygon4V.size(this.a.sx, this.b.sx, this.c.sx, this.d.sx);
        sizey = (short)ColorLightedPolygon4V.size(this.a.sy, this.b.sy, this.c.sy, this.d.sy);
        int[] al = this.getLight(this.a, this.ar, this.ag, this.ab, g3d);
        int[] bl = this.getLight(this.b, this.br, this.bg, this.bb, g3d);
        int[] cl = this.getLight(this.c, this.cr, this.cg, this.cb, g3d);
        int[] dl = this.getLight(this.d, this.dr, this.dg, this.db, g3d);
        if (fog == 5) {
            sz2 = 255 - MathUtils.calcLight(this.nx, this.ny, this.nz, DirectX7.lightdirx, DirectX7.lightdiry, DirectX7.lightdirz);
        }
        if (fog == 1) {
            this.szCalcfogAdd();
        }
        int n = q = this.ny > 4000 || this.ny < -4000 ? 9999999 : Main.q;
        if (Main.mipMapping && texture.mip != null) {
            texture.rImg = texture.mip[0];
            if (texture.drawmode < 10 || texture.drawmode > 12) {
                addmip = (byte)(q > 999 ? 2 : 3);
                if ((sizex + sizey >> 1) * addmip < (sizeu = (short)(ColorLightedPolygon4V.size(this.au & 0xFF, this.bu & 0xFF, this.cu & 0xFF, this.du & 0xFF) * texture.rImg.w >> 8)) + (sizev = (short)(ColorLightedPolygon4V.size(this.av & 0xFF, this.bv & 0xFF, this.cv & 0xFF, this.dv & 0xFF) * texture.rImg.h >> 8))) {
                    texture.rImg = texture.mip[1];
                    if (texture.mip != null && (sizex + sizey >> 1) * addmip < (sizeu = (short)(sizeu >> 1)) + (sizev = (short)(sizev >> 1))) {
                        texture.rImg = texture.mip[2];
                    }
                }
            } else if (sizex < texture.rImg.w || sizey < texture.rImg.w) {
                texture.rImg = texture.mip[1];
                if (texture.mip != null && (sizex < texture.rImg.w || sizey < texture.rImg.w)) {
                    texture.rImg = texture.mip[2];
                }
            }
        }
        boolean bl2 = texture.perspectiveCorrection && (sizex > 70 - (Main.persQ < 3 ? 0 : 20) || sizey > 100 - (Main.persQ < 3 ? 0 : 30)) && Main.persQ != 0 || Main.persQ == 4 ? true : (pers = false);
        if (pers) {
            if (this.a.rz < 0 || this.b.rz < 0 || this.d.rz < 0) {
                TexturingPers.paint(g3d, texture, this.a, this.au & 0xFF, this.av & 0xFF, this.b, this.bu & 0xFF, this.bv & 0xFF, this.d, this.du & 0xFF, this.dv & 0xFF, DirectX7.fogc, fog, sz2, q, al[0], bl[0], dl[0], al[1], bl[1], dl[1], al[2], bl[2], dl[2], this.nx, this.ny, this.nz);
            }
            if (this.c.rz < 0 || this.b.rz < 0 || this.d.rz < 0) {
                TexturingPers.paint(g3d, texture, this.b, this.bu & 0xFF, this.bv & 0xFF, this.c, this.cu & 0xFF, this.cv & 0xFF, this.d, this.du & 0xFF, this.dv & 0xFF, DirectX7.fogc, fog, sz2, q, bl[0], cl[0], dl[0], bl[1], cl[1], dl[1], bl[2], cl[2], dl[2], this.nx, this.ny, this.nz);
            }
        } else {
            if (this.a.rz < 0 || this.b.rz < 0 || this.d.rz < 0) {
                TexturingAffine.paint(g3d, texture, this.a, this.au & 0xFF, this.av & 0xFF, this.b, this.bu & 0xFF, this.bv & 0xFF, this.d, this.du & 0xFF, this.dv & 0xFF, DirectX7.fogc, fog, sz2, al[0], bl[0], dl[0], al[1], bl[1], dl[1], al[2], bl[2], dl[2], this.nx, this.ny, this.nz);
            }
            if (this.c.rz < 0 || this.b.rz < 0 || this.d.rz < 0) {
                TexturingAffine.paint(g3d, texture, this.b, this.bu & 0xFF, this.bv & 0xFF, this.c, this.cu & 0xFF, this.cv & 0xFF, this.d, this.du & 0xFF, this.dv & 0xFF, DirectX7.fogc, fog, sz2, bl[0], cl[0], dl[0], bl[1], cl[1], dl[1], bl[2], cl[2], dl[2], this.nx, this.ny, this.nz);
            }
        }
    }

    public final void renderFast(DirectX7 g3d, Texture texture) {
        if (texture.drawmode == 5 && (sz2 = 255 - MathUtils.calcLight(this.nx, this.ny, this.nz, DirectX7.lightdirx, DirectX7.lightdiry, DirectX7.lightdirz)) < 0) {
            sz2 = 0;
        }
        if (texture.drawmode == 1) {
            this.szCalcfogAdd();
        }
        TexturingAffine.paint(g3d, texture, this.a, this.au & 0xFF, this.av & 0xFF, this.b, this.bu & 0xFF, this.bv & 0xFF, this.d, this.du & 0xFF, this.dv & 0xFF, DirectX7.fogc, texture.drawmode, sz2, this.ar + 128, this.br + 128, this.dr + 128, this.ag + 128, this.bg + 128, this.dg + 128, this.ab + 128, this.bb + 128, this.db + 128, this.nx, this.ny, this.nz);
        TexturingAffine.paint(g3d, texture, this.b, this.bu & 0xFF, this.bv & 0xFF, this.c, this.cu & 0xFF, this.cv & 0xFF, this.d, this.du & 0xFF, this.dv & 0xFF, DirectX7.fogc, texture.drawmode, sz2, this.br + 128, this.cr + 128, this.dr + 128, this.bg + 128, this.cg + 128, this.dg + 128, this.bb + 128, this.cb + 128, this.db + 128, this.nx, this.ny, this.nz);
    }

    private static int size(int a, int b, int c, int d) {
        int t;
        if (b < a) {
            t = a;
            a = b;
            b = t;
        }
        if (c < a) {
            t = c;
            c = a;
            a = t;
        }
        if (c < b) {
            t = b;
            b = c;
            c = t;
        }
        int min = a < d ? a : d;
        int max = c > d ? c : d;
        return max - min;
    }

    private static final int min(int a, int b, int c, int d) {
        int t;
        if (a == b || b == d || b == c || d == c) {
            return ColorLightedPolygon4V.min(a, c, d);
        }
        if (a == c) {
            return ColorLightedPolygon4V.min(a, b, d);
        }
        if (a == d) {
            return ColorLightedPolygon4V.min(a, b, c);
        }
        if (b < a) {
            t = a;
            a = b;
            b = t;
        }
        if (c < a) {
            t = c;
            c = a;
            a = t;
        }
        if (c < b) {
            t = b;
            b = c;
            c = t;
        }
        int min = a < d ? a : d;
        return min;
    }

    private static final int min(int a, int b, int c) {
        if (a == b || b == c) {
            return a < c ? a : c;
        }
        if (a == c) {
            return a < b ? a : b;
        }
        if (a < b && a < c) {
            return a;
        }
        if (b < a && b < c) {
            return b;
        }
        return c;
    }
}

