/*
 * Decompiled with CFR 0.152.
 */
package code.Rendering;

import code.Rendering.ByteRawImage;
import code.Rendering.DirectX7;
import code.Rendering.RawImage;
import code.utils.Asset;

public class Texture {
    public boolean perspectiveCorrection;
    public RawImage rImg;
    public ByteRawImage brImg;
    public RawImage[] mip = null;
    public RawImage[] brMip = null;
    public byte drawmode = DirectX7.standartDrawmode;
    public int addsz = 0;
    public boolean castShadow = true;
    public boolean collision = true;
    public Texture[] animMIP;
    public float animation_speed = 1.0f;

    Texture() {
    }

    public Texture(RawImage ri, boolean perspectiveCorrection, ByteRawImage bri) {
        this.setTexture(ri, perspectiveCorrection, bri);
    }

    void setTexture(RawImage ri, boolean perspectiveCorrection, ByteRawImage bri) {
        this.perspectiveCorrection = perspectiveCorrection;
        this.rImg = ri;
        this.drawmode = DirectX7.standartDrawmode;
        this.brImg = bri;
    }

    public int[] getPixels() {
        return this.rImg.img;
    }

    public byte getDrawMode() {
        return this.drawmode;
    }

    public void setDrawMode(byte dr) {
        this.drawmode = dr;
    }

    public void setPerspectiveCorrection(boolean perspectiveCorrection) {
        this.perspectiveCorrection = perspectiveCorrection;
    }

    public static Texture createTexture(String file) {
        RawImage rimg = Asset.getRawImage(file);
        return new Texture(rimg, false, null);
    }

    public void updateAnimation() {
        if (this.animMIP == null) {
            return;
        }
        long time = System.currentTimeMillis();
        int anim_index = (int)((float)(time %= (long)((float)(this.animMIP.length * 1000) / this.animation_speed)) * this.animation_speed / 1000.0f) % this.animMIP.length;
        this.rImg = this.animMIP[anim_index].rImg;
        this.mip = this.animMIP[anim_index].mip;
        this.brMip = this.animMIP[anim_index].brMip;
    }
}

