/*
 * Decompiled with CFR 0.152.
 */
package code.Rendering.Meshes;

import code.Gameplay.Map.Light;
import code.Gameplay.Map.LightMapper;
import code.Gameplay.Map.Room;
import code.Math.MathUtils;
import code.Math.Matrix;
import code.Rendering.DirectX7;
import code.Rendering.Meshes.LightedPolygon3V;
import code.Rendering.Meshes.LightedPolygon4V;
import code.Rendering.Meshes.Morphing;
import code.Rendering.Meshes.Polygon3V;
import code.Rendering.Meshes.Polygon4V;
import code.Rendering.MultyTexture;
import code.Rendering.RenderObject;
import code.Rendering.RenderObjectBuffer;
import code.Rendering.TMPElement;
import code.Rendering.Texture;
import code.Rendering.Vertex;
import java.util.Vector;

public class Mesh {
    private MultyTexture texture = null;
    private Vertex[] vertices;
    private RenderObject[] polygons;
    static RenderObjectBuffer buffer = new RenderObjectBuffer();
    static Matrix tmpMatrix = new Matrix();

    public Mesh() {
    }

    public Mesh(Vertex[] vertices, RenderObject[] polygons) {
        this.vertices = vertices;
        this.polygons = polygons;
    }

    public Mesh(Vertex[] vertices, RenderObject[] polygons, MultyTexture tex) {
        this.vertices = vertices;
        this.polygons = polygons;
        this.texture = tex;
    }

    public void optimize() {
        int old = this.vertices.length;
        Vector<Vertex> buf = new Vector<Vertex>();
        for (int i = 0; i < this.vertices.length; ++i) {
            Vertex v = this.vertices[i];
            int s = Mesh.search(buf, v);
            if (s == -1) {
                buf.addElement(v);
                continue;
            }
            Mesh.replace(this.polygons, v, (Vertex)buf.elementAt(s));
        }
        this.vertices = new Vertex[buf.size()];
        buf.copyInto(this.vertices);
    }

    private static int search(Vector vertices, Vertex vertex) {
        int E = 10;
        for (int i = 0; i < vertices.size(); ++i) {
            Vertex v = (Vertex)vertices.elementAt(i);
            if (v == vertex || Math.abs(v.x - vertex.x) >= 10 || Math.abs(v.y - vertex.y) >= 10 || Math.abs(v.z - vertex.z) >= 10) continue;
            return i;
        }
        return -1;
    }

    private static void replace(RenderObject[] polygons, Vertex oldVertex, Vertex newVertex) {
        for (int i = 0; i < polygons.length; ++i) {
            RenderObject poly;
            if (polygons[i] instanceof Polygon4V) {
                poly = (Polygon4V)polygons[i];
                if (poly.a == oldVertex) {
                    poly.a = newVertex;
                }
                if (poly.b == oldVertex) {
                    poly.b = newVertex;
                }
                if (poly.c == oldVertex) {
                    poly.c = newVertex;
                }
                if (poly.d != oldVertex) continue;
                poly.d = newVertex;
                continue;
            }
            if (!(polygons[i] instanceof Polygon3V)) continue;
            poly = (Polygon3V)polygons[i];
            if (((Polygon3V)poly).a == oldVertex) {
                ((Polygon3V)poly).a = newVertex;
            }
            if (((Polygon3V)poly).b == oldVertex) {
                ((Polygon3V)poly).b = newVertex;
            }
            if (((Polygon3V)poly).c != oldVertex) continue;
            ((Polygon3V)poly).c = newVertex;
        }
    }

    public void destroy() {
        int i;
        this.texture = null;
        for (i = 0; i < this.polygons.length; ++i) {
            this.polygons[i] = null;
        }
        this.polygons = null;
        for (i = 0; i < this.vertices.length; ++i) {
            this.vertices[i] = null;
        }
        this.vertices = null;
    }

    public void setTexture(Texture texture) {
        this.texture = new MultyTexture(texture);
        for (int i = 0; i < this.polygons.length; ++i) {
            if (this.polygons[i] instanceof Polygon4V) {
                ((Polygon4V)this.polygons[i]).tex = 0;
                continue;
            }
            ((Polygon3V)this.polygons[i]).tex = 0;
        }
    }

    public void setTexture(MultyTexture texture) {
        this.texture = texture;
    }

    public void resetTexture() {
        this.texture = null;
    }

    public int maxX() {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < this.vertices.length; ++i) {
            if (this.vertices[i].x <= max) continue;
            max = this.vertices[i].x;
        }
        return max;
    }

    public int maxY() {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < this.vertices.length; ++i) {
            if (this.vertices[i].y <= max) continue;
            max = this.vertices[i].y;
        }
        return max;
    }

    public int maxZ() {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < this.vertices.length; ++i) {
            if (this.vertices[i].z <= max) continue;
            max = this.vertices[i].z;
        }
        return max;
    }

    public int minX() {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < this.vertices.length; ++i) {
            if (this.vertices[i].x >= min) continue;
            min = this.vertices[i].x;
        }
        return min;
    }

    public int minY() {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < this.vertices.length; ++i) {
            if (this.vertices[i].y >= min) continue;
            min = this.vertices[i].y;
        }
        return min;
    }

    public int minZ() {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < this.vertices.length; ++i) {
            if (this.vertices[i].z >= min) continue;
            min = this.vertices[i].z;
        }
        return min;
    }

    public MultyTexture getTexture() {
        return this.texture;
    }

    public Vertex[] getVertices() {
        return this.vertices;
    }

    public RenderObject[] getPolygons() {
        return this.polygons;
    }

    void render(DirectX7 g3d) {
        this.render(g3d, 0, 0, g3d.width, g3d.height);
    }

    void render(DirectX7 g3d, int x1, int y1, int x2, int y2) {
        RenderObject[] elements = this.polygons;
        buffer.addRenderObjects(elements, this.texture, x1, y1, x2, y2);
        buffer.sort(0, buffer.getSize() - 1);
        TMPElement[] buffer2 = buffer.getBuffer();
        for (int i = buffer.getSize() - 1; i >= 0; --i) {
            TMPElement element = buffer2[i];
            element.obj.renderFast(g3d, element.tex);
        }
        buffer.reset();
    }

    public static void resetBuffer() {
        buffer.resetTex();
        buffer.reset();
    }

    public void applySz() {
        RenderObject[] elements = this.polygons;
        for (int i = 0; i < elements.length; ++i) {
            RenderObject obj = elements[i];
            if (obj instanceof Polygon4V) {
                obj.sz += this.texture.textures[((Polygon4V)obj).tex].addsz;
                continue;
            }
            if (!(obj instanceof Polygon3V)) continue;
            obj.sz += this.texture.textures[((Polygon3V)obj).tex].addsz;
        }
    }

    public void increaseMeshSz(int z) {
        for (int i = 0; i < this.polygons.length; ++i) {
            this.polygons[i].sz += z;
        }
    }

    public void setAnimation(Morphing animation) {
        animation.interpolation(this.vertices);
    }

    public void recalculateNormals(Matrix transform) {
        Vertex normal = null;
        if (transform != null) {
            normal = new Vertex(0, 0, 0);
            tmpMatrix.set(transform);
            tmpMatrix.setPosition(0, 0, 0);
        }
        for (int i = 0; i < this.polygons.length; ++i) {
            RenderObject p;
            RenderObject ro = this.polygons[i];
            if (ro instanceof Polygon4V) {
                p = (Polygon4V)ro;
                p.calculateNormals(((Polygon4V)p).a, ((Polygon4V)p).b, ((Polygon4V)p).c);
            } else if (ro instanceof Polygon3V) {
                p = (Polygon3V)ro;
                p.calculateNormals(((Polygon3V)p).a, ((Polygon3V)p).b, ((Polygon3V)p).c);
            }
            if (transform == null) continue;
            normal.set(ro.nx, ro.ny, ro.nz);
            normal.transform(tmpMatrix);
            ro.nx = (short)normal.x;
            ro.ny = (short)normal.y;
            ro.nz = (short)normal.z;
        }
    }

    public void rotateNormals(Matrix transform) {
        Vertex normal = new Vertex(0, 0, 0);
        tmpMatrix.set(transform);
        tmpMatrix.setPosition(0, 0, 0);
        for (int i = 0; i < this.polygons.length; ++i) {
            RenderObject ro = this.polygons[i];
            normal.set(ro.nx, ro.ny, ro.nz);
            normal.transform(tmpMatrix);
            ro.nx = (short)normal.x;
            ro.ny = (short)normal.y;
            ro.nz = (short)normal.z;
        }
    }

    public void updateLighting(Matrix transform, boolean smoothNormals, Room room) {
        Light[] lights = room.lights;
        if (lights == null) {
            return;
        }
        Vertex normal = new Vertex(0, 0, 0);
        DirectX7.transform(this, transform);
        tmpMatrix.set(transform);
        tmpMatrix.setPosition(0, 0, 0);
        for (int i = 0; i < this.polygons.length; ++i) {
            RenderObject p;
            RenderObject ro = this.polygons[i];
            if (ro instanceof LightedPolygon3V) {
                p = (LightedPolygon3V)ro;
                normal.set(p.nx, p.ny, p.nz);
                normal.transform(tmpMatrix);
                p.la = this.getVertexLit(p.la, normal, p.a, room);
                p.lb = this.getVertexLit(p.lb, normal, p.b, room);
                p.lc = this.getVertexLit(p.lc, normal, p.c, room);
                continue;
            }
            if (!(ro instanceof LightedPolygon4V)) continue;
            p = (LightedPolygon4V)ro;
            normal.set(((LightedPolygon4V)p).nx, ((LightedPolygon4V)p).ny, ((LightedPolygon4V)p).nz);
            normal.transform(tmpMatrix);
            ((LightedPolygon4V)p).la = this.getVertexLit(((LightedPolygon4V)p).la, normal, ((LightedPolygon4V)p).a, room);
            ((LightedPolygon4V)p).lb = this.getVertexLit(((LightedPolygon4V)p).lb, normal, ((LightedPolygon4V)p).b, room);
            ((LightedPolygon4V)p).lc = this.getVertexLit(((LightedPolygon4V)p).lc, normal, ((LightedPolygon4V)p).c, room);
            ((LightedPolygon4V)p).ld = this.getVertexLit(((LightedPolygon4V)p).ld, normal, ((LightedPolygon4V)p).d, room);
        }
    }

    private static final Vertex getNormal(Mesh mesh, Vertex v) {
        int count = 0;
        Vertex norm = new Vertex();
        for (int i = 0; i < mesh.polygons.length; ++i) {
            RenderObject p;
            RenderObject ro = mesh.polygons[i];
            if (ro instanceof LightedPolygon3V) {
                p = (LightedPolygon3V)ro;
                if (!(p.a.sx == v.sx && p.a.sy == v.sy && p.a.rz == v.rz || p.b.sx == v.sx && p.b.sy == v.sy && p.b.rz == v.rz) && (p.c.sx != v.sx || p.c.sy != v.sy || p.c.rz != v.rz)) continue;
                norm.x += p.nx;
                norm.y += p.ny;
                norm.z += p.nz;
                ++count;
                continue;
            }
            if (!(ro instanceof LightedPolygon4V)) continue;
            p = (LightedPolygon4V)ro;
            if (!(((LightedPolygon4V)p).a.sx == v.sx && ((LightedPolygon4V)p).a.sy == v.sy && ((LightedPolygon4V)p).a.rz == v.rz || ((LightedPolygon4V)p).b.sx == v.sx && ((LightedPolygon4V)p).b.sy == v.sy && ((LightedPolygon4V)p).b.rz == v.rz || ((LightedPolygon4V)p).c.sx == v.sx && ((LightedPolygon4V)p).c.sy == v.sy && ((LightedPolygon4V)p).c.rz == v.rz) && (((LightedPolygon4V)p).d.sx != v.sx || ((LightedPolygon4V)p).d.sy != v.sy || ((LightedPolygon4V)p).d.rz != v.rz)) continue;
            norm.x += ((LightedPolygon4V)p).nx;
            norm.y += ((LightedPolygon4V)p).ny;
            norm.z += ((LightedPolygon4V)p).nz;
            ++count;
        }
        if (count != 0) {
            norm.x /= count;
            norm.y /= count;
            norm.z /= count;
        }
        return norm;
    }

    private byte getVertexLit(byte orig, Vertex norm, Vertex v, Room room) {
        long lit = 0L;
        Light[] lights = room.lights;
        Vertex tmp = new Vertex(v.sx, v.sy, v.rz);
        for (int i = 0; i < lights.length; ++i) {
            Light light = lights[i];
            long distSqr = LightMapper.distanceSqr(tmp, light.pos);
            long intensity = (long)((light.color[0] + light.color[1] + light.color[2]) / 3 * 783225) / Math.max(1L, distSqr) * 8L;
            if (distSqr < 0L) {
                intensity = 0L;
            }
            if (intensity > 1L) {
                if (light.direction == null) {
                    intensity = intensity * (long)MathUtils.calcLight(norm.sx, norm.sy, norm.rz, v.sx - light.pos.x, v.sy - light.pos.y, v.rz - light.pos.z) / 255L;
                } else {
                    intensity = intensity * (long)MathUtils.calcLight(light.direction.x, light.direction.y, light.direction.z, v.sx - light.pos.x, v.sy - light.pos.y, v.rz - light.pos.z) / 255L;
                    intensity = intensity * (long)MathUtils.calcLight(norm.sx, norm.sy, norm.rz, v.sx - light.pos.x, v.sy - light.pos.y, v.rz - light.pos.z) / 255L;
                }
            }
            if (intensity <= 1L) continue;
            lit += intensity;
        }
        return (byte)Math.max(Math.min(127L, lit - 128L + (long)LightMapper.ambientLightMid), -128L);
    }
}

