/*
 * Decompiled with CFR 0.152.
 */
package code.HUD.Base;

import code.utils.IniFile;
import code.utils.StringTools;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Font {
    private int space;
    private Image img;
    private Image selimg;
    private Image actimg;
    private int[] coords;
    private char[] chars;
    private int y_src = 0;

    public Font(String file) {
        try {
            IniFile str = IniFile.createFromResource(file);
            String var2 = str.get("IMG");
            String sel_font = str.get("SELECTED_IMG");
            String act_font = str.get("ACTIVE_IMG");
            if (act_font == null) {
                act_font = var2;
            }
            if (sel_font == null) {
                sel_font = var2;
            }
            this.selimg = Image.createImage((String)sel_font);
            this.actimg = Image.createImage((String)act_font);
            this.chars = str.get("CHARS").toCharArray();
            if (str.get("COORDS") != null) {
                this.img = Image.createImage((String)var2);
                this.coords = StringTools.cutOnInts(str.get("COORDS"), ',');
                this.space = str.getInt("SPACE");
            } else {
                int i;
                Image tImg = Image.createImage((String)var2);
                this.img = Image.createImage((Image)tImg, (int)0, (int)1, (int)tImg.getWidth(), (int)(tImg.getHeight() - 1), (int)0);
                this.selimg = Image.createImage((Image)this.selimg, (int)0, (int)1, (int)this.selimg.getWidth(), (int)(this.selimg.getHeight() - 1), (int)0);
                this.actimg = Image.createImage((Image)this.actimg, (int)0, (int)1, (int)this.actimg.getWidth(), (int)(this.actimg.getHeight() - 1), (int)0);
                int[] line = new int[tImg.getWidth()];
                tImg.getRGB(line, 0, tImg.getWidth(), 0, 0, tImg.getWidth(), 1);
                Vector<Integer> vCoords = new Vector<Integer>();
                vCoords.addElement(new Integer(0));
                for (i = 0; i < line.length; ++i) {
                    int col = line[i];
                    if (col != -16777216) continue;
                    vCoords.addElement(new Integer(i));
                }
                vCoords.addElement(new Integer(this.img.getWidth()));
                this.coords = new int[vCoords.size()];
                for (i = 0; i < vCoords.size(); ++i) {
                    this.coords[i] = (Integer)vCoords.elementAt(i);
                }
                this.space = 0;
                for (i = 0; i < this.chars.length; ++i) {
                    this.space += this.charWidth(this.chars[i]);
                }
                this.space /= this.chars.length;
            }
        }
        catch (IOException var3) {
            var3.printStackTrace();
        }
    }

    public int getCode(char ch) {
        for (int i = 0; i < this.chars.length; ++i) {
            if (this.chars[i] != ch) continue;
            return i;
        }
        return -1;
    }

    public int charWidth(char ch) {
        if (ch == ' ') {
            return this.space;
        }
        int code = this.getCode(ch);
        if (code == -1) {
            return this.space;
        }
        int b = this.coords[code];
        int e = this.coords[code + 1];
        return e - b;
    }

    public final void setY(int val) {
        this.y_src = 0;
    }

    private int indexOf(char ch) {
        for (int var2 = 0; var2 < this.chars.length; ++var2) {
            if (this.chars[var2] != ch) continue;
            return var2;
        }
        return -1;
    }

    public final void drawString(Graphics g, String str, int x, int y, int anchor) {
        this.drawString(g, str, x, y, anchor, 0);
    }

    public final void drawString(Graphics g, String str, int x, int y, int anchor, int col) {
        int var10004 = str.length();
        int var6 = y;
        y = var10004;
        boolean var12 = false;
        int var8 = x;
        int var9 = var6;
        Image im = this.img;
        if (col == 1) {
            im = this.selimg;
        }
        if (col == 2) {
            im = this.actimg;
        }
        if ((anchor & 8) != 0) {
            var8 = x - this.widthOf(str, g);
        }
        if ((anchor & 0x20) != 0) {
            var9 = var6 - this.height();
        }
        if ((anchor & 1) != 0) {
            var8 -= this.widthOf(str, g) >> 1;
        }
        if ((anchor & 2) != 0) {
            var9 -= this.height() >> 1;
        }
        if ((anchor & 0x40) != 0) {
            var9 -= this.height() + 1;
        }
        int var7 = var9;
        var6 = var8;
        anchor = y;
        int var16 = 0;
        String var15 = str;
        Graphics var14 = g;
        Font font = this;
        var8 = this.img.getHeight();
        int defhei = var14.getFont().getHeight();
        var9 = this.y_src * var8;
        for (y = var16; y < anchor; ++y) {
            char var10 = var15.charAt(y);
            if (var10 == ' ' && font.indexOf(var10) == -1) {
                var6 += font.space;
                continue;
            }
            int var17 = font.indexOf(var10);
            if (var17 == -1) {
                var14.setColor(0xFFFFFF);
                var14.drawChar(var10, var6, var7 + var8, 36);
                var6 += var14.getFont().charWidth(var10);
                continue;
            }
            int var11 = font.coords[var17];
            var17 = font.coords[var17 + 1] - var11;
            var14.drawRegion(im, var11, var9, var17, var8, 0, var6, var7, 0);
            var6 += var17;
        }
    }

    public final int widthOf(char ch, Graphics g) {
        int var3 = this.indexOf(ch);
        if (ch == ' ' && var3 == -1) {
            return this.space;
        }
        if (var3 == -1) {
            return g.getFont().charWidth(ch);
        }
        int var2 = this.coords[var3];
        return this.coords[var3 + 1] - var2;
    }

    public final int widthOf(char ch) {
        int var3 = this.indexOf(ch);
        if (ch == ' ' && var3 == -1) {
            return this.space;
        }
        if (var3 == -1) {
            return this.space;
        }
        int var2 = this.coords[var3];
        return this.coords[var3 + 1] - var2;
    }

    public final int height() {
        return this.img.getHeight();
    }

    public final int height2(String str, Graphics g) {
        int stdh = this.img.getHeight();
        for (int var5 = 0; var5 < str.length(); ++var5) {
            int h;
            if (this.indexOf(str.charAt(var5)) != -1 || str.charAt(var5) == ' ' || (h = g.getFont().getHeight()) <= stdh) continue;
            return h;
        }
        return stdh;
    }

    public final int widthOf(String str, Graphics g) {
        int var3 = str.length();
        char[] var2 = str.toCharArray();
        Font var7 = this;
        int var4 = 0;
        for (int var5 = 0; var5 < var3; ++var5) {
            var4 += var7.widthOf(var2[var5], g);
        }
        return var4;
    }

    public final int widthOf(String str) {
        int var3 = str.length();
        char[] var2 = str.toCharArray();
        Font var7 = this;
        int var4 = 0;
        for (int var5 = 0; var5 < var3; ++var5) {
            var4 += var7.widthOf(var2[var5]);
        }
        return var4;
    }
}

