/*
 * Decompiled with CFR 0.152.
 */
package code.Gameplay.Map;

import code.Gameplay.Map.House;
import code.Gameplay.Map.LightMapper;
import code.Gameplay.Map.Portal;
import code.Gameplay.Map.Room;
import code.Math.Vector3D;
import code.Rendering.DirectX7;
import code.Rendering.Meshes.Mesh;
import code.Rendering.Meshes.Polygon3V;
import code.Rendering.Meshes.Polygon4V;
import code.Rendering.RenderObject;
import code.Rendering.Vertex;
import java.util.Vector;

public class HouseCreator {
    public static House create(Mesh[] meshes, boolean np, String lightdataFile) {
        House house;
        for (int i = 0; i < meshes.length; ++i) {
            meshes[i].optimize();
        }
        if (lightdataFile != null && (DirectX7.standartDrawmode == 9 || DirectX7.standartDrawmode == 13)) {
            LightMapper.loadLightMap(meshes, lightdataFile);
        }
        if (meshes.length > 1) {
            int i;
            RenderObject[] ro = meshes[meshes.length - 1].getPolygons();
            Room[] rooms = new Room[meshes.length - 1];
            for (i = 0; i < meshes.length - 1; ++i) {
                rooms[i] = new Room(meshes[i], i);
            }
            for (i = 0; i < rooms.length; ++i) {
                Room room = rooms[i];
                RenderObject[] polygons = ro;
                Vector<Portal> portalVerts = new Vector<Portal>();
                for (int i2 = 0; i2 < polygons.length; ++i2) {
                    Vertex[] vertices;
                    RenderObject pol = polygons[i2];
                    if (pol instanceof Polygon3V) {
                        Polygon3V var10 = (Polygon3V)pol;
                        vertices = new Vertex[]{var10.a, var10.b, var10.c};
                    } else if (pol instanceof Polygon4V) {
                        Polygon4V var35 = (Polygon4V)pol;
                        vertices = new Vertex[]{var35.a, var35.b, var35.c, var35.d};
                    } else {
                        vertices = null;
                    }
                    if (!HouseCreator.isExistsCommonCoords(room.getMesh(), vertices)) continue;
                    Mesh mesh = room.getMesh();
                    Vector3D var34 = HouseCreator.computeCentre(mesh.getVertices());
                    Vector3D var11 = HouseCreator.computeCentre(vertices);
                    Vertex var27 = vertices[0];
                    Vertex var10001 = vertices[1];
                    Vertex var31 = vertices[2];
                    Vertex var13 = var10001;
                    Vertex var12 = var27;
                    long var18 = (long)(var27.y - var13.y) * (long)(var12.z - var31.z) - (long)(var12.z - var13.z) * (long)(var12.y - var31.y);
                    long var20 = (long)(var12.z - var13.z) * (long)(var12.x - var31.x) - (long)(var12.x - var13.x) * (long)(var12.z - var31.z);
                    long var22 = (long)(var12.x - var13.x) * (long)(var12.y - var31.y) - (long)(var12.y - var13.y) * (long)(var12.x - var31.x);
                    double var24 = Math.sqrt(var18 * var18 + var20 * var20 + var22 * var22) / 4096.0;
                    int var33 = (int)((double)var18 / var24);
                    int var37 = (int)((double)var20 / var24);
                    int var38 = (int)((double)var22 / var24);
                    Vector3D var32 = new Vector3D(var33, var37, var38);
                    var34.x -= var11.x;
                    var34.y -= var11.y;
                    var34.z -= var11.z;
                    if (var32.dot(var34) >= 0) {
                        HouseCreator.reverse(vertices);
                    }
                    portalVerts.addElement(new Portal(vertices));
                }
                Object[] portals = new Portal[portalVerts.size()];
                portalVerts.copyInto(portals);
                room.setPortals((Portal[])portals);
                HouseCreator.findRooms(room, rooms);
            }
            HouseCreator.countPortals(rooms);
            Room[][] neighbours = HouseCreator.createNeighbours(rooms);
            house = new House(rooms, neighbours);
        } else {
            RenderObject[] polygons = meshes[0].getPolygons();
            Room[] rooms = new Room[1];
            Room[][] neighbours = new Room[1][1];
            rooms[0] = new Room(meshes[0], 0);
            neighbours[0][0] = rooms[0];
            house = new House(rooms, neighbours);
        }
        if (lightdataFile == null && (DirectX7.standartDrawmode == 9 || DirectX7.standartDrawmode == 13)) {
            LightMapper.generateLightMapSaveThread(house, meshes, lightdataFile);
        }
        return house;
    }

    private static void countPortals(Room[] rooms) {
        int var1 = 0;
        int var2 = 0;
        for (int var3 = 0; var3 < rooms.length; ++var3) {
            Portal[] var4 = rooms[var3].getPortals();
            if (var4 == null || var4.length == 0) {
                ++var2;
            }
            for (int var5 = 0; var5 < var4.length; ++var5) {
                if (var4[var5].getRoom() != null) continue;
                ++var1;
            }
        }
        if (var1 > 0) {
            System.out.println("HouseCreator: " + var1 + " \u043f\u043e\u0440\u0442\u0430\u043b\u0430\u043c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u043a\u043e\u043c\u043d\u0430\u0442\u044b");
        }
        if (var2 > 0) {
            System.out.println("HouseCreator: " + var2 + " \u043a\u043e\u043c\u043d\u0430\u0442\u0430\u043c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u043f\u043e\u0440\u0442\u0430\u043b\u044b");
        }
    }

    private static Vector3D computeCentre(Vertex[] vertices) {
        long var1 = 0L;
        long var3 = 0L;
        long var5 = 0L;
        for (int var7 = 0; var7 < vertices.length; ++var7) {
            Vertex var8 = vertices[var7];
            var1 += (long)var8.x;
            var3 += (long)var8.y;
            var5 += (long)var8.z;
        }
        return new Vector3D((int)(var1 /= (long)vertices.length), (int)(var3 /= (long)vertices.length), (int)(var5 /= (long)vertices.length));
    }

    private static void reverse(Vertex[] vertices) {
        Vertex[] var1 = new Vertex[vertices.length];
        for (int var2 = 0; var2 < var1.length; ++var2) {
            var1[var2] = vertices[vertices.length - 1 - var2];
        }
        System.arraycopy(var1, 0, vertices, 0, var1.length);
    }

    private static void findRooms(Room room, Room[] rooms) {
        Portal[] var2 = room.getPortals();
        block0: for (int var3 = 0; var3 < var2.length; ++var3) {
            Portal var4 = var2[var3];
            for (int var5 = 0; var5 < rooms.length; ++var5) {
                Room var6 = rooms[var5];
                if (var6 == room || !HouseCreator.isExistsCommonCoords(var6.getMesh(), var4.getVertices())) {
                    continue;
                }
                var4.setRoom(var6);
                continue block0;
            }
        }
    }

    private static Room[][] createNeighbours(Room[] rooms) {
        Room[][] neighbours = new Room[rooms.length][];
        for (int i = 0; i < neighbours.length; ++i) {
            Vector vRooms = HouseCreator.getRooms(rooms[i]);
            neighbours[i] = new Room[vRooms.size()];
            vRooms.copyInto(neighbours[i]);
        }
        return neighbours;
    }

    private static Vector getRooms(Room room) {
        Portal[] portals = room.getPortals();
        Vector<Room> rooms = new Vector<Room>();
        for (int i = 0; i < portals.length; ++i) {
            Portal p = portals[i];
            Room secondRoom = p.getRoom();
            if (secondRoom == null || rooms.contains(secondRoom)) continue;
            rooms.addElement(secondRoom);
        }
        return rooms;
    }

    private static boolean isExistsCommonCoords(Mesh mesh, Vertex[] poly) {
        for (int var2 = 0; var2 < poly.length; ++var2) {
            boolean var10000;
            block3: {
                Vertex var4 = poly[var2];
                Vertex[] var3 = mesh.getVertices();
                for (int var5 = 0; var5 < var3.length; ++var5) {
                    Vertex var6 = var3[var5];
                    if (var6.x / 50 != var4.x / 50 || var6.y / 50 != var4.y / 50 || var6.z / 50 != var4.z / 50) {
                        continue;
                    }
                    var10000 = true;
                    break block3;
                }
                var10000 = false;
            }
            if (!var10000) continue;
            return true;
        }
        return false;
    }
}

