/*
 * Decompiled with CFR 0.152.
 */
package code.Gameplay;

import code.Gameplay.GameScreen;
import code.Gameplay.Shop;
import code.Gameplay.Weapon;
import code.utils.WeaponCreator;
import javax.microedition.lcdui.Graphics;

public class Arsenal {
    public Weapon[] weapons;
    public int current;
    public boolean hasHand = false;

    public final void destroy() {
        for (int var1 = 0; var1 < this.weapons.length; ++var1) {
            if (this.weapons[var1] == null) continue;
            this.weapons[var1].reset();
            this.weapons[var1] = null;
        }
        this.weapons = null;
    }

    public final void removeAll() {
        int i;
        int n = i = this.hasHand ? 0 : 1;
        while (i < this.weapons.length) {
            if (this.weapons[i] != null) {
                this.weapons[i].reset();
                this.weapons[i] = null;
            }
            ++i;
        }
        this.current = this.hasHand ? -1 : 0;
    }

    public final Weapon currentWeapon() {
        if (this.current >= 0 && this.current < this.weapons.length) {
            return this.weapons[this.current];
        }
        return null;
    }

    public final Weapon[] getWeapons() {
        return this.weapons;
    }

    public final void next() {
        if (this.currentWeapon() != null) {
            this.currentWeapon().reset();
        }
        ++this.current;
        if (this.current >= this.weapons.length) {
            this.current = 0;
            if (this.hasHand) {
                this.current = -1;
            }
        }
        if (this.current != -1 && this.weapons[this.current] == null) {
            this.next();
        }
    }

    public final void previous() {
        if (this.currentWeapon() != null) {
            this.currentWeapon().reset();
        }
        --this.current;
        if (this.current < (this.hasHand ? -1 : 0)) {
            this.current = this.weapons.length - 1;
        }
        if (this.current != -1 && this.weapons[this.current] == null) {
            this.previous();
        }
    }

    public final void drawWeapon(Graphics g, int y, int width, int height, GameScreen gs) {
        if (this.currentWeapon() == null) {
            return;
        }
        Weapon weapon = this.currentWeapon();
        if (!gs.player.zoom || !weapon.hasZoom) {
            weapon.draw(g, 0, y, width, height);
        } else {
            weapon.drawSight(g, 0, y, width, height);
        }
        if (weapon.isReloading()) {
            int maxY = Math.max(height / 50, 6);
            int x = (width /= 2) - width / 2;
            int y2 = height - maxY - 2 + y;
            int perc = weapon.reloadingPercentage();
            g.setColor(0xFFFFFF);
            g.drawRect(x, y2, width, maxY);
            g.fillRect(x, y2, width * perc / 100, maxY);
        }
    }

    public Arsenal(int width_g3d, int height_g3d) {
        int i;
        this.current = -1;
        this.weapons = new Weapon[Shop.weapon_count];
        if (Shop.defaultArsenal != null) {
            for (i = 0; i < Shop.defaultArsenal.length; ++i) {
                if (Shop.defaultArsenal[i] != -1) {
                    this.weapons[Shop.defaultArsenal[i]] = WeaponCreator.createWeapon(Shop.defaultArsenal[i]);
                    if (this.current == -1) {
                        this.current = Shop.defaultArsenal[i];
                    }
                }
                if (Shop.defaultArsenal[i] != -1) continue;
                this.hasHand = true;
            }
        } else {
            this.hasHand = true;
            this.current = -1;
        }
        for (i = 0; i < this.weapons.length; ++i) {
            if (this.weapons[i] == null) continue;
            this.weapons[i].reset();
            if (!this.weapons[i].isTwoHands()) {
                this.weapons[i].setAmmo(200);
                continue;
            }
            this.weapons[i].setAmmo(400);
        }
        if (this.currentWeapon() != null) {
            this.currentWeapon().createSprite(width_g3d, height_g3d);
        }
    }

    public Arsenal() {
    }
}

