/*
 * Decompiled with CFR 0.152.
 */
package com.Collision;

import com.Math.MathUtils;
import com.Math.MathUtils2;
import com.Math.Matrix;
import com.Math.Vector3D;
import com.Rendering.DirectX7;
import com.Rendering.Meshes.Mesh;
import com.Rendering.Meshes.Polygon3V;
import com.Rendering.Meshes.Polygon4V;
import com.Rendering.RenderObject;
import com.Rendering.Vertex;

public final class SphereCast {
    private static final Vector3D temp = new Vector3D();
    private static final Vector3D nor = new Vector3D();
    private static final Vector3D v1 = new Vector3D();
    private static final Vector3D v2 = new Vector3D();
    private static final Vector3D v3 = new Vector3D();
    private static final Vector3D v4 = new Vector3D();

    public static boolean isSphereAABBCollision(Vector3D pos, int rad, int minx, int maxx, int minz, int maxz) {
        return pos.x + rad >= minx && pos.z + rad >= minz && pos.x - rad <= maxx && pos.z - rad <= maxz;
    }

    public static boolean sphereCast(Mesh mesh, Matrix matrix, Vector3D pos, int rad) {
        DirectX7.transformSave(mesh, matrix);
        boolean ret = SphereCast.sphereCast(mesh, pos, rad);
        return ret;
    }

    public static boolean sphereCast(Mesh mesh, Vector3D pos, int rad) {
        RenderObject[] elements = mesh.getPolygons();
        boolean col = false;
        for (int i = 0; i < elements.length; ++i) {
            Vertex c;
            Vertex b;
            Vertex a;
            RenderObject p;
            RenderObject poly = elements[i];
            int dis = Integer.MAX_VALUE;
            if (poly instanceof Polygon3V) {
                int minz;
                int maxz;
                int miny;
                int maxy;
                int minx;
                p = (Polygon3V)poly;
                a = p.a;
                b = p.b;
                c = p.c;
                int ax = a.x;
                int ay = a.y;
                int az = a.z;
                int bx = b.x;
                int by = b.y;
                int bz = b.z;
                int cx = c.x;
                int cy = c.y;
                int cz = c.z;
                int maxx = ax;
                if (bx > maxx) {
                    maxx = bx;
                }
                if (cx > maxx) {
                    maxx = cx;
                }
                if (bx < (minx = ax)) {
                    minx = bx;
                }
                if (cx < minx) {
                    minx = cx;
                }
                if (by > (maxy = ay)) {
                    maxy = by;
                }
                if (cy > maxy) {
                    maxy = cy;
                }
                if (by < (miny = ay)) {
                    miny = by;
                }
                if (cy < miny) {
                    miny = cy;
                }
                if (bz > (maxz = az)) {
                    maxz = bz;
                }
                if (cz > maxz) {
                    maxz = cz;
                }
                if (bz < (minz = az)) {
                    minz = bz;
                }
                if (cz < minz) {
                    minz = cz;
                }
                if (maxx < pos.x - rad || minx > pos.x + rad || maxz < pos.z - rad || minz > pos.z + rad || maxy < pos.y - rad || miny > pos.y + rad) continue;
                SphereCast.v1.x = ax;
                SphereCast.v1.y = ay;
                SphereCast.v1.z = az;
                SphereCast.v2.x = bx;
                SphereCast.v2.y = by;
                SphereCast.v2.z = bz;
                SphereCast.v3.x = cx;
                SphereCast.v3.y = cy;
                SphereCast.v3.z = cz;
                SphereCast.nor.x = p.nx;
                SphereCast.nor.y = p.ny;
                SphereCast.nor.z = p.nz;
                dis = SphereCast.distanceSphereToPolygon(v1, v2, v3, nor, pos, rad);
            } else if (poly instanceof Polygon4V) {
                int minz;
                int maxz;
                int miny;
                int maxy;
                int minx;
                p = (Polygon4V)poly;
                a = ((Polygon4V)p).a;
                b = ((Polygon4V)p).b;
                c = ((Polygon4V)p).c;
                Vertex d = ((Polygon4V)p).d;
                int ax = a.x;
                int ay = a.y;
                int az = a.z;
                int bx = b.x;
                int by = b.y;
                int bz = b.z;
                int cx = c.x;
                int cy = c.y;
                int cz = c.z;
                int dx = d.x;
                int dy = d.y;
                int dz = d.z;
                int maxx = ax;
                if (bx > maxx) {
                    maxx = bx;
                }
                if (cx > maxx) {
                    maxx = cx;
                }
                if (dx > maxx) {
                    maxx = dx;
                }
                if (bx < (minx = ax)) {
                    minx = bx;
                }
                if (cx < minx) {
                    minx = cx;
                }
                if (dx < minx) {
                    minx = dx;
                }
                if (by > (maxy = ay)) {
                    maxy = by;
                }
                if (cy > maxy) {
                    maxy = cy;
                }
                if (dy > maxy) {
                    maxy = dy;
                }
                if (by < (miny = ay)) {
                    miny = by;
                }
                if (cy < miny) {
                    miny = cy;
                }
                if (dy < miny) {
                    miny = dy;
                }
                if (bz > (maxz = az)) {
                    maxz = bz;
                }
                if (cz > maxz) {
                    maxz = cz;
                }
                if (dz > maxz) {
                    maxz = dz;
                }
                if (bz < (minz = az)) {
                    minz = bz;
                }
                if (cz < minz) {
                    minz = cz;
                }
                if (dz < minz) {
                    minz = dz;
                }
                if (maxx < pos.x - rad || minx > pos.x + rad || maxz < pos.z - rad || minz > pos.z + rad || maxy < pos.y - rad || miny > pos.y + rad) continue;
                SphereCast.v1.x = ax;
                SphereCast.v1.y = ay;
                SphereCast.v1.z = az;
                SphereCast.v2.x = bx;
                SphereCast.v2.y = by;
                SphereCast.v2.z = bz;
                SphereCast.v3.x = cx;
                SphereCast.v3.y = cy;
                SphereCast.v3.z = cz;
                SphereCast.v4.x = dx;
                SphereCast.v4.y = dy;
                SphereCast.v4.z = dz;
                SphereCast.nor.x = ((Polygon4V)p).nx;
                SphereCast.nor.y = ((Polygon4V)p).ny;
                SphereCast.nor.z = ((Polygon4V)p).nz;
                dis = SphereCast.distanceSphereToPolygon(v1, v2, v3, v4, nor, pos, rad);
            }
            if (dis == Integer.MAX_VALUE || dis <= 0) continue;
            pos.add(-SphereCast.nor.x * dis >> 12, -SphereCast.nor.y * dis >> 12, -SphereCast.nor.z * dis >> 12);
            col = true;
        }
        return col;
    }

    private static int distanceSphereToPolygon(Vector3D a, Vector3D b, Vector3D c, Vector3D nor, Vector3D point, int rad) {
        SphereCast.temp.x = point.x - a.x;
        SphereCast.temp.y = point.y - a.y;
        SphereCast.temp.z = point.z - a.z;
        int dot = temp.dot(nor) >> 12;
        if (dot > rad) {
            return Integer.MAX_VALUE;
        }
        SphereCast.temp.x = point.x - (nor.x * dot >> 12);
        SphereCast.temp.y = point.y - (nor.y * dot >> 12);
        SphereCast.temp.z = point.z - (nor.z * dot >> 12);
        if (MathUtils2.isPointOnPolygon(temp, a, b, c, nor)) {
            int dis = dot;
            if (dot < 0) {
                dis = -dot;
            }
            dis = rad - dis;
            return dis;
        }
        int len1 = MathUtils2.distanceToLine(point, a, b);
        int len2 = MathUtils2.distanceToLine(point, b, c);
        int len3 = MathUtils2.distanceToLine(point, c, a);
        int min = len1;
        if (len2 < min) {
            min = len2;
        }
        if (len3 < min) {
            min = len3;
        }
        if (min <= rad * rad) {
            return rad - (int)(1.0f / MathUtils.invSqrt(min));
        }
        return Integer.MAX_VALUE;
    }

    private static int distanceSphereToPolygon(Vector3D a, Vector3D b, Vector3D c, Vector3D d, Vector3D nor, Vector3D point, int rad) {
        SphereCast.temp.x = point.x - a.x;
        SphereCast.temp.y = point.y - a.y;
        SphereCast.temp.z = point.z - a.z;
        int dot = temp.dot(nor) >> 12;
        if (dot > rad) {
            return Integer.MAX_VALUE;
        }
        SphereCast.temp.x = point.x - (nor.x * dot >> 12);
        SphereCast.temp.y = point.y - (nor.y * dot >> 12);
        SphereCast.temp.z = point.z - (nor.z * dot >> 12);
        if (MathUtils2.isPointOnPolygon(temp, a, b, c, d, nor)) {
            int dis = dot;
            if (dot < 0) {
                dis = -dot;
            }
            dis = rad - dis;
            return dis;
        }
        int len1 = MathUtils2.distanceToLine(point, a, b);
        int len2 = MathUtils2.distanceToLine(point, b, c);
        int len3 = MathUtils2.distanceToLine(point, c, d);
        int len4 = MathUtils2.distanceToLine(point, d, a);
        int min = len1;
        if (len2 < min) {
            min = len2;
        }
        if (len3 < min) {
            min = len3;
        }
        if (len4 < min) {
            min = len4;
        }
        if (min <= rad * rad) {
            return rad - (int)(1.0f / MathUtils2.invSqrt(min));
        }
        return Integer.MAX_VALUE;
    }
}

