/*
 * Decompiled with CFR 0.152.
 */
package com.Rendering.Meshes;

import com.Rendering.DirectX7;
import com.Rendering.Meshes.Mesh;
import com.Rendering.Meshes.Polygon3V;
import com.Rendering.Meshes.Polygon4V;
import com.Rendering.RenderObject;
import com.Rendering.RenderObjectBuffer;
import com.Rendering.TMPElement;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Material;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;

public class M3GParser {
    public Graphics3D iG3D = Graphics3D.getInstance();
    public Camera cam = new Camera();
    public Background iBackground;
    private final RenderObjectBuffer buffer;

    public M3GParser(int x, int y) {
        this.cam.setParallel((float)y, (float)x / (float)y, 1.0f, 1.0E8f);
        this.buffer = new RenderObjectBuffer();
    }

    public static Appearance appearanceGenerator(String file) {
        try {
            Appearance ap = new Appearance();
            Image2D img2d = new Image2D(99, (Object)Image.createImage((String)file));
            Texture2D texture = new Texture2D(img2d);
            texture.setFiltering(210, 210);
            texture.setBlending(228);
            ap.setTexture(0, texture);
            Material mat = new Material();
            mat.setColor(1024, -1);
            mat.setColor(2048, -1);
            mat.setColor(4096, -1);
            PolygonMode pm = new PolygonMode();
            pm.setCulling(162);
            ap.setPolygonMode(pm);
            ap.setMaterial(mat);
            return ap;
        }
        catch (Exception exc) {
            System.out.println("Error in M3GParser:appearanceGenerator");
            System.out.println("Error: " + exc.toString());
            return null;
        }
    }

    public final void meshRender(Mesh mesh, int x1, int y1, int x2, int y2, Appearance ap, DirectX7 g3d, Graphics g) {
        int i;
        this.buffer.addRenderObjects(mesh.getPoligons(), x1, y1, x2, y2);
        this.buffer.sort();
        TMPElement[] buffer2 = this.buffer.getBuffer();
        int objs = 0;
        for (i = this.buffer.getSize() - 1; i >= 0; --i) {
            TMPElement element = buffer2[i];
            if (element.obj instanceof Polygon4V) {
                objs += 2;
                continue;
            }
            if (!(element.obj instanceof Polygon3V)) continue;
            ++objs;
        }
        int i2 = 0;
        short[] vert = new short[objs * 9];
        short[] texs = new short[objs * 6];
        int[] stripLen = new int[objs];
        for (i = this.buffer.getSize() - 1; i >= 0; --i) {
            RenderObject pol;
            TMPElement element = buffer2[i];
            if (element.obj instanceof Polygon4V) {
                pol = (Polygon4V)element.obj;
                vert[i2] = (short)(pol.a.sx - g3d.width / 2);
                vert[i2 + 1] = (short)(-pol.a.sy + g3d.height / 2);
                vert[i2 + 2] = (short)(pol.a.rz / 40);
                vert[i2 + 3] = (short)(pol.b.sx - g3d.width / 2);
                vert[i2 + 4] = (short)(-pol.b.sy + g3d.height / 2);
                vert[i2 + 5] = (short)(pol.b.rz / 40);
                vert[i2 + 6] = (short)(pol.c.sx - g3d.width / 2);
                vert[i2 + 7] = (short)(-pol.c.sy + g3d.height / 2);
                vert[i2 + 8] = (short)(pol.c.rz / 40);
                vert[i2 + 9] = (short)(pol.c.sx - g3d.width / 2);
                vert[i2 + 10] = (short)(-pol.c.sy + g3d.height / 2);
                vert[i2 + 11] = (short)(pol.c.rz / 40);
                vert[i2 + 12] = (short)(pol.d.sx - g3d.width / 2);
                vert[i2 + 13] = (short)(-pol.d.sy + g3d.height / 2);
                vert[i2 + 14] = (short)(pol.d.rz / 40);
                vert[i2 + 15] = (short)(pol.a.sx - g3d.width / 2);
                vert[i2 + 16] = (short)(-pol.a.sy + g3d.height / 2);
                vert[i2 + 17] = (short)(pol.a.rz / 40);
                texs[i2 / 3 * 2] = (short)(pol.au & 0xFF);
                texs[i2 / 3 * 2 + 1] = (short)(pol.av & 0xFF);
                texs[i2 / 3 * 2 + 2] = (short)(pol.bu & 0xFF);
                texs[i2 / 3 * 2 + 3] = (short)(pol.bv & 0xFF);
                texs[i2 / 3 * 2 + 4] = (short)(pol.cu & 0xFF);
                texs[i2 / 3 * 2 + 5] = (short)(pol.cv & 0xFF);
                texs[i2 / 3 * 2 + 6] = (short)(pol.cu & 0xFF);
                texs[i2 / 3 * 2 + 7] = (short)(pol.cv & 0xFF);
                texs[i2 / 3 * 2 + 8] = (short)(pol.du & 0xFF);
                texs[i2 / 3 * 2 + 9] = (short)(pol.dv & 0xFF);
                texs[i2 / 3 * 2 + 10] = (short)(pol.au & 0xFF);
                texs[i2 / 3 * 2 + 11] = (short)(pol.av & 0xFF);
                stripLen[i2 / 9] = 3;
                stripLen[i2 / 9 + 1] = 3;
                i2 += 18;
                continue;
            }
            if (!(element.obj instanceof Polygon3V)) continue;
            pol = (Polygon3V)element.obj;
            vert[i2] = (short)(((Polygon3V)pol).a.sx - g3d.width / 2);
            vert[i2 + 1] = (short)(-((Polygon3V)pol).a.sy + g3d.height / 2);
            vert[i2 + 2] = (short)(((Polygon3V)pol).a.rz / 40);
            vert[i2 + 3] = (short)(((Polygon3V)pol).b.sx - g3d.width / 2);
            vert[i2 + 4] = (short)(-((Polygon3V)pol).b.sy + g3d.height / 2);
            vert[i2 + 5] = (short)(((Polygon3V)pol).b.rz / 40);
            vert[i2 + 6] = (short)(((Polygon3V)pol).c.sx - g3d.width / 2);
            vert[i2 + 7] = (short)(-((Polygon3V)pol).c.sy + g3d.height / 2);
            vert[i2 + 8] = (short)(((Polygon3V)pol).c.rz / 40);
            texs[i2 / 3 * 2] = (short)(((Polygon3V)pol).au & 0xFF);
            texs[i2 / 3 * 2 + 1] = (short)(((Polygon3V)pol).av & 0xFF);
            texs[i2 / 3 * 2 + 2] = (short)(((Polygon3V)pol).bu & 0xFF);
            texs[i2 / 3 * 2 + 3] = (short)(((Polygon3V)pol).bv & 0xFF);
            texs[i2 / 3 * 2 + 4] = (short)(((Polygon3V)pol).cu & 0xFF);
            texs[i2 / 3 * 2 + 5] = (short)(((Polygon3V)pol).cv & 0xFF);
            stripLen[i2 / 9] = 3;
            i2 += 9;
        }
        VertexArray vertArray = new VertexArray(vert.length / 3, 3, 2);
        vertArray.set(0, vert.length / 3, vert);
        VertexArray texArray = new VertexArray(texs.length / 2, 2, 2);
        texArray.set(0, texs.length / 2, texs);
        VertexBuffer iVb = new VertexBuffer();
        iVb.setPositions(vertArray, 1.0f, null);
        iVb.setTexCoords(0, texArray, 0.00390625f, null);
        TriangleStripArray iIb = new TriangleStripArray(0, stripLen);
        this.iG3D.bindTarget((Object)g);
        this.iG3D.setCamera(this.cam, null);
        this.iG3D.render(iVb, (IndexBuffer)iIb, ap, null);
        this.buffer.reset();
        this.iG3D.releaseTarget();
    }
}

