/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.media.sound;

import malik.emulator.application.PlayerMIDIEndTrackHandler;
import malik.emulator.application.Run;
import malik.emulator.media.sound.SoundPlayer;
import malik.emulator.media.sound.SoundPlayerException;
import malik.emulator.media.sound.SoundPlayerListener;
import malik.emulator.media.sound.SoundPlayerMessaged;
import malik.emulator.util.DataDescriptor;

public final class SoundPlayerSynthetic
implements PlayerMIDIEndTrackHandler,
SoundPlayerMessaged,
SoundPlayer {
    private int handle;
    private DataDescriptor descriptor;
    private SoundPlayerListener listener;
    private Object lock;

    public static SoundPlayerSynthetic open() throws SoundPlayerException {
        int handle = (int)MalikSystem.syscall((long)0L, (int)56);
        if (handle == 0) {
            throw new SoundPlayerException("SoundPlayerSynthetic.open: \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u043d\u0435 \u0445\u0432\u0430\u0442\u0430\u0435\u0442 \u043f\u0430\u043c\u044f\u0442\u0438 \u043d\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043d\u043e\u0432\u043e\u0433\u043e MIDI-\u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044f \u0438\u043b\u0438 \u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442 MIDI.");
        }
        return new SoundPlayerSynthetic(handle);
    }

    private SoundPlayerSynthetic(int handle) {
        this.handle = handle;
        this.descriptor = new DataDescriptor();
        this.lock = new Object();
        Run.getInstance().setPlayerMIDIEndTrackHandler(handle, (PlayerMIDIEndTrackHandler)this);
    }

    public void endMIDITrack(int playerMIDIHandle) {
        SoundPlayerListener listener = this.listener;
        if (listener != null && playerMIDIHandle == this.handle) {
            listener.loadBlock(this, -1);
        }
    }

    public void sendMessage(int synthesizerMessage) {
        MalikSystem.syscall((long)synthesizerMessage, (int)57);
    }

    public void setSoundPlayerListener(SoundPlayerListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            int h = this.handle;
            if (h != 0) {
                this.handle = 0;
                this.listener = null;
                MalikSystem.syscall((long)h, (int)63);
                Run.getInstance().setPlayerMIDIEndTrackHandler(h, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadBlock(long[] synthesizerMessages, int offset, int length) {
        int result;
        int h = this.handle;
        if (h == 0) {
            throw new IllegalStateException("SoundPlayer: \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u0437\u043e\u0432\u0430 \u043c\u0435\u0442\u043e\u0434\u0430 close().");
        }
        if (synthesizerMessages == null) {
            throw new NullPointerException("SoundPlayerSynthetic.loadBlock: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 synthesizerMessages \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = synthesizerMessages.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("SoundPlayerSynthetic.loadBlock: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        if (length <= 0) {
            return 0;
        }
        Object object = this.lock;
        synchronized (object) {
            DataDescriptor d = this.descriptor;
            d.setDataInfo(Array.getFirstElementAddress((Object)synthesizerMessages) + (offset << 3), length);
            result = (int)MalikSystem.syscall((int)h, (int)d.getDescriptorAddress(), (int)57);
        }
        return result;
    }

    public int reset() {
        int h = this.handle;
        if (h == 0) {
            throw new IllegalStateException("SoundPlayer: \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u0437\u043e\u0432\u0430 \u043c\u0435\u0442\u043e\u0434\u0430 close().");
        }
        return (int)MalikSystem.syscall((int)h, (int)0, (int)58);
    }

    public int start() {
        int h = this.handle;
        if (h == 0) {
            throw new IllegalStateException("SoundPlayer: \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u0437\u043e\u0432\u0430 \u043c\u0435\u0442\u043e\u0434\u0430 close().");
        }
        return (int)MalikSystem.syscall((int)h, (int)1, (int)58);
    }

    public int stop() {
        int h = this.handle;
        if (h == 0) {
            throw new IllegalStateException("SoundPlayer: \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u0437\u043e\u0432\u0430 \u043c\u0435\u0442\u043e\u0434\u0430 close().");
        }
        return (int)MalikSystem.syscall((int)h, (int)2, (int)58);
    }

    public int setVolume(int volume) {
        int h = this.handle;
        if (h == 0) {
            throw new IllegalStateException("SoundPlayer: \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u0437\u043e\u0432\u0430 \u043c\u0435\u0442\u043e\u0434\u0430 close().");
        }
        return (int)MalikSystem.syscall((int)h, (int)(volume < 0 ? 0 : (volume > 127 ? 127 : volume)), (int)62);
    }

    public int setCurrentBlockPosition(int position) {
        int h = this.handle;
        if (h == 0) {
            throw new IllegalStateException("SoundPlayer: \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u0437\u043e\u0432\u0430 \u043c\u0435\u0442\u043e\u0434\u0430 close().");
        }
        return (int)MalikSystem.syscall((int)h, (int)position, (int)60);
    }

    public int getState() {
        int h = this.handle;
        if (h == 0) {
            throw new IllegalStateException("SoundPlayer: \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u0437\u043e\u0432\u0430 \u043c\u0435\u0442\u043e\u0434\u0430 close().");
        }
        return (int)MalikSystem.syscall((int)h, (int)0, (int)59);
    }

    public int getVolume() {
        int h = this.handle;
        if (h == 0) {
            throw new IllegalStateException("SoundPlayer: \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u0437\u043e\u0432\u0430 \u043c\u0435\u0442\u043e\u0434\u0430 close().");
        }
        return (int)MalikSystem.syscall((int)h, (int)-1, (int)62);
    }

    public int getCurrentBlockPosition() {
        int h = this.handle;
        if (h == 0) {
            throw new IllegalStateException("SoundPlayer: \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u0437\u043e\u0432\u0430 \u043c\u0435\u0442\u043e\u0434\u0430 close().");
        }
        return (int)MalikSystem.syscall((int)h, (int)0, (int)61);
    }

    public int getCurrentBlockIndex() {
        int h = this.handle;
        if (h == 0) {
            throw new IllegalStateException("SoundPlayer: \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u0437\u043e\u0432\u0430 \u043c\u0435\u0442\u043e\u0434\u0430 close().");
        }
        return (int)(MalikSystem.syscall((int)h, (int)0, (int)61) >> 32);
    }

    public long getCurrentBlockAndPosition() {
        int h = this.handle;
        if (h == 0) {
            throw new IllegalStateException("SoundPlayer: \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u0437\u043e\u0432\u0430 \u043c\u0435\u0442\u043e\u0434\u0430 close().");
        }
        return MalikSystem.syscall((int)h, (int)0, (int)61);
    }
}

