/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.lang.ref.WeakReference;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.MIDletProxy;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.ScrollBarDefault;
import javax.microedition.lcdui.ScrollBarStyle;
import javax.microedition.lcdui.Ticker;

public abstract class ScrollingScreen
extends Screen {
    static final int NONE = 0;
    static final int HORIZONTAL = 1;
    static final int VERTICAL = 2;
    static final int BOTH = 3;
    private static final int FOCUSED_CLIENT_OUT = -1;
    private static final int FOCUSED_NONE = 0;
    private static final int FOCUSED_CLIENT = 1;
    private static final int FOCUSED_HORZ_SCROLL_BAR = 2;
    private static final int FOCUSED_VERT_SCROLL_BAR = 3;
    private boolean needScroll = true;
    private boolean stayScroll;
    private boolean shiftPressed;
    private int focused;
    private int hbutton;
    private ScrollBar horzScrollBar;
    private ScrollBar vertScrollBar;
    private ScrollBarStyle style;

    private static ScrollBarStyle getScrollBarStyle() {
        ScrollBarStyle result;
        try {
            result = (ScrollBarStyle)Class.forName(System.getSystemProperty((String)"malik.emulator.microedition.scrollbar.style")).newInstance();
        }
        catch (Exception exception) {
            result = new ScrollBarDefault();
        }
        return result;
    }

    ScrollingScreen(boolean system, boolean fullScreenMode, String title, Ticker ticker, Command[] commands, Command defaultCommand, CommandListener listener, int scrollbars) {
        this(system, fullScreenMode, title, ticker, commands, defaultCommand, listener, scrollbars, ScrollingScreen.getScrollBarStyle());
    }

    ScrollingScreen(boolean system, boolean fullScreenMode, String title, Ticker ticker, Command[] commands, Command defaultCommand, CommandListener listener, int scrollbars, ScrollBarStyle style) {
        super(system, fullScreenMode, title, ticker, commands, defaultCommand, listener);
        this.horzScrollBar = new ScrollBar(this, (scrollbars & 1) != 0, 1);
        this.vertScrollBar = new ScrollBar(this, (scrollbars & 2) != 0, 2);
        this.style = style == null ? new ScrollBarDefault() : style;
    }

    public final void scroll(int deltaX, int deltaY) {
        this.horzScrollBar.scroll(deltaX);
        this.vertScrollBar.scroll(deltaY);
    }

    public final void scrollTo(int x, int y) {
        this.horzScrollBar.setPosition(x);
        this.vertScrollBar.setPosition(y);
    }

    public final javax.microedition.lcdui.ScrollBar getHorzScrollBar() {
        return this.horzScrollBar;
    }

    public final javax.microedition.lcdui.ScrollBar getVertScrollBar() {
        return this.vertScrollBar;
    }

    abstract void paint(Graphics var1, javax.microedition.lcdui.ScrollBar var2, javax.microedition.lcdui.ScrollBar var3);

    void onShow() {
        super.onShow();
        if (this.needScroll) {
            this.callSeriallyScroll();
        }
        this.focused = 0;
        this.shiftPressed = false;
    }

    void onHide() {
        this.shiftPressed = false;
        this.focused = 0;
        super.onHide();
    }

    void onKeyPressed(int key, int charCode) {
        if (!(super.keyHandling(key) || key != 16 && key != 160 && key != 161)) {
            this.shiftPressed = true;
        }
        super.onKeyPressed(key, charCode);
    }

    void onKeyReleased(int key) {
        if (!(super.keyHandling(key) || key != 16 && key != 160 && key != 161)) {
            this.shiftPressed = false;
        }
        super.onKeyReleased(key);
    }

    boolean keyHandling(int key) {
        return key == 16 || key == 160 || key == 161 || super.keyHandling(key);
    }

    boolean coordinateHandling(int x, int y) {
        int t;
        Display display = MIDletProxy.getInstance().getEmulatorScreen();
        int l = display.getGUIElementLeft(this, 2);
        return x >= l && x < l + display.getGUIElementWidth(this, 2) && y >= (t = display.getGUIElementTop(this, 2)) && y < t + display.getGUIElementHeight(this, 2) || super.coordinateHandling(x, y);
    }

    int getMarginRight() {
        return super.getMarginRight() + (this.vertScrollBar.isVisible() ? this.getVertScrollBarWidth() : 0);
    }

    int getMarginBottom() {
        return super.getMarginBottom() + (this.horzScrollBar.isVisible() ? this.getHorzScrollBarWidth() : 0);
    }

    void paintHorzScrollBar(Graphics clientRender, javax.microedition.lcdui.ScrollBar scrollbar, int length, int width) {
        this.style.paintHorzScrollBar(clientRender, scrollbar, length, width);
    }

    void paintVertScrollBar(Graphics clientRender, javax.microedition.lcdui.ScrollBar scrollbar, int length, int width) {
        this.style.paintVertScrollBar(clientRender, scrollbar, length, width);
    }

    void onScroll(javax.microedition.lcdui.ScrollBar horzScrollBar, javax.microedition.lcdui.ScrollBar vertScrollBar) {
    }

    void onClientPointerPressed(int x, int y, int button) {
    }

    void onClientPointerDragged(int x, int y) {
    }

    void onClientPointerReleased(int x, int y, int button) {
    }

    void onHorzScrollBarPointerPressed(javax.microedition.lcdui.ScrollBar scrollbar, int length, int width, int x, int y, int button) {
        this.style.onHorzScrollBarPointerPressed(scrollbar, length, width, x, y, button);
    }

    void onHorzScrollBarPointerDragged(javax.microedition.lcdui.ScrollBar scrollbar, int length, int width, int x, int y) {
        this.style.onHorzScrollBarPointerDragged(scrollbar, length, width, x, y);
    }

    void onHorzScrollBarPointerReleased(javax.microedition.lcdui.ScrollBar scrollbar, int length, int width, int x, int y, int button) {
        this.style.onHorzScrollBarPointerReleased(scrollbar, length, width, x, y, button);
    }

    void onVertScrollBarPointerPressed(javax.microedition.lcdui.ScrollBar scrollbar, int length, int width, int x, int y, int button) {
        this.style.onVertScrollBarPointerPressed(scrollbar, length, width, x, y, button);
    }

    void onVertScrollBarPointerDragged(javax.microedition.lcdui.ScrollBar scrollbar, int length, int width, int x, int y) {
        this.style.onVertScrollBarPointerDragged(scrollbar, length, width, x, y);
    }

    void onVertScrollBarPointerReleased(javax.microedition.lcdui.ScrollBar scrollbar, int length, int width, int x, int y, int button) {
        this.style.onVertScrollBarPointerReleased(scrollbar, length, width, x, y, button);
    }

    int getHorzScrollBarWidth() {
        return this.style.getHorzScrollBarWidth();
    }

    int getVertScrollBarWidth() {
        return this.style.getVertScrollBarWidth();
    }

    final void paint(Graphics render) {
        ScrollBar horz = this.horzScrollBar;
        ScrollBar vert = this.vertScrollBar;
        int horzPos = horz.getPosition();
        int vertPos = vert.getPosition();
        int clientLeft = this.getClientLeft();
        int clientTop = this.getClientTop();
        int clientWidth = this.getClientWidth();
        int clientHeight = this.getClientHeight();
        int horzWidth = this.getHorzScrollBarWidth();
        int vertWidth = this.getVertScrollBarWidth();
        try {
            render.translate(-horzPos, -vertPos);
            render.setClip(horzPos, vertPos, clientWidth, clientHeight);
            this.paint(render, horz, vert);
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
        }
        if (horz.isVisible()) {
            try {
                render.reset();
                render.translate(clientLeft, clientTop + clientHeight);
                render.setClip(0, 0, clientWidth, horzWidth);
                this.paintHorzScrollBar(render, horz, clientWidth, horzWidth);
            }
            catch (RuntimeException e) {
                e.printRealStackTrace();
            }
        }
        if (vert.isVisible()) {
            try {
                render.reset();
                render.translate(clientLeft + clientWidth, clientTop);
                render.setClip(0, 0, vertWidth, clientHeight);
                this.paintVertScrollBar(render, vert, clientHeight, vertWidth);
            }
            catch (RuntimeException e) {
                e.printRealStackTrace();
            }
        }
    }

    final void onPointerPressed(int x, int y, int button) {
        int t;
        int l;
        ScrollBar horz = this.horzScrollBar;
        ScrollBar vert = this.vertScrollBar;
        ScrollBar scrollbar = this.shiftPressed ? horz : (vert.isVisible() ? vert : horz);
        switch (button) {
            case 4: {
                scrollbar.scroll(-scrollbar.getPage() / 4);
                return;
            }
            case 5: {
                scrollbar.scroll(scrollbar.getPage() / 4);
                return;
            }
        }
        Display display = MIDletProxy.getInstance().getEmulatorScreen();
        if (this.focused == 0 && !super.coordinateHandling(x, y) && x >= (l = display.getGUIElementLeft(this, 2)) && x < l + display.getGUIElementWidth(this, 2) && y >= (t = display.getGUIElementTop(this, 2)) && y < t + display.getGUIElementHeight(this, 2)) {
            this.hbutton = button;
            x -= l;
            y -= t;
            int horzWidth = this.getHorzScrollBarWidth();
            int vertWidth = this.getVertScrollBarWidth();
            int clientLeft = this.getClientLeft();
            int clientWidth = this.getClientWidth();
            int clientRight = clientLeft + clientWidth;
            int clientTop = this.getClientTop();
            int clientHeight = this.getClientHeight();
            int clientBottom = clientTop + clientHeight;
            if (x >= clientLeft && x < clientRight && y >= clientTop && y < clientBottom) {
                this.focused = 1;
                this.onClientPointerPressed(x - clientLeft + horz.getPosition(), y - clientTop + vert.getPosition(), button);
                return;
            }
            scrollbar = horz;
            if (scrollbar.isVisible() && x >= clientLeft && x < clientRight && y >= clientBottom && y < clientBottom + horzWidth) {
                this.focused = 2;
                this.onHorzScrollBarPointerPressed(scrollbar, clientWidth, horzWidth, x - clientLeft, y - clientBottom, button);
                return;
            }
            scrollbar = vert;
            if (scrollbar.isVisible() && y >= clientTop && y < clientBottom && x >= clientRight && x < clientRight + vertWidth) {
                this.focused = 3;
                this.onVertScrollBarPointerPressed(scrollbar, clientHeight, vertWidth, x - clientRight, y - clientTop, button);
                return;
            }
            this.focused = -1;
            return;
        }
        super.onPointerPressed(x, y, button);
    }

    final void onPointerDragged(int x, int y) {
        int f = this.focused;
        if (f != 0) {
            Display display = MIDletProxy.getInstance().getEmulatorScreen();
            x -= display.getGUIElementLeft(this, 2);
            y -= display.getGUIElementTop(this, 2);
            int clientLeft = this.getClientLeft();
            int clientWidth = this.getClientWidth();
            int clientRight = clientLeft + clientWidth;
            int clientTop = this.getClientTop();
            int clientHeight = this.getClientHeight();
            int clientBottom = clientTop + clientHeight;
            switch (f) {
                default: {
                    return;
                }
                case 1: {
                    this.onClientPointerDragged(x - clientLeft + this.horzScrollBar.getPosition(), y - clientTop + this.vertScrollBar.getPosition());
                    return;
                }
                case 2: {
                    this.onHorzScrollBarPointerDragged(this.horzScrollBar, clientWidth, this.getHorzScrollBarWidth(), x - clientLeft, y - clientBottom);
                    return;
                }
                case 3: 
            }
            this.onVertScrollBarPointerDragged(this.vertScrollBar, clientHeight, this.getVertScrollBarWidth(), x - clientRight, y - clientTop);
            return;
        }
        super.onPointerDragged(x, y);
    }

    final void onPointerReleased(int x, int y, int button) {
        int f = this.focused;
        if (f != 0 && this.hbutton == button) {
            this.focused = 0;
            Display display = MIDletProxy.getInstance().getEmulatorScreen();
            x -= display.getGUIElementLeft(this, 2);
            y -= display.getGUIElementTop(this, 2);
            int clientLeft = this.getClientLeft();
            int clientWidth = this.getClientWidth();
            int clientRight = clientLeft + clientWidth;
            int clientTop = this.getClientTop();
            int clientHeight = this.getClientHeight();
            int clientBottom = clientTop + clientHeight;
            switch (f) {
                default: {
                    return;
                }
                case 1: {
                    this.onClientPointerReleased(x - clientLeft + this.horzScrollBar.getPosition(), y - clientTop + this.vertScrollBar.getPosition(), button);
                    return;
                }
                case 2: {
                    this.onHorzScrollBarPointerReleased(this.horzScrollBar, clientWidth, this.getHorzScrollBarWidth(), x - clientLeft, y - clientBottom, button);
                    return;
                }
                case 3: 
            }
            this.onVertScrollBarPointerReleased(this.vertScrollBar, clientHeight, this.getVertScrollBarWidth(), x - clientRight, y - clientTop, button);
            return;
        }
        super.onPointerReleased(x, y, button);
    }

    final void callSeriallyScroll() {
        if (this.stayScroll) {
            return;
        }
        this.stayScroll = true;
        this.callSerially(new ScrollEvent(this));
    }

    private static final class ScrollBar
    extends WeakReference
    implements javax.microedition.lcdui.ScrollBar {
        private boolean visible;
        private int kind;
        private int range;
        private int position;

        private static int correctPosition(int position, int page, int range) {
            return Math.max(0, Math.min(range - page, position));
        }

        public ScrollBar(ScrollingScreen thisScreen, boolean visible, int kind) {
            super(thisScreen);
            this.visible = visible;
            this.kind = kind;
        }

        public void repaintOwner() {
            ScrollingScreen thisScreen = (ScrollingScreen)this.get();
            if (thisScreen == null) {
                return;
            }
            thisScreen.callSeriallyPaintScreen(4);
        }

        public void hide() {
            this.setVisible(false);
        }

        public void show() {
            this.setVisible(true);
        }

        public void setVisible(boolean visible) {
            if (this.visible == visible) {
                return;
            }
            this.visible = visible;
            ScrollingScreen thisScreen = (ScrollingScreen)this.get();
            if (thisScreen == null) {
                return;
            }
            thisScreen.callSeriallySizeChanged();
            (this.kind == 1 ? thisScreen.vertScrollBar : thisScreen.horzScrollBar).recomputePosition(thisScreen);
            thisScreen.callSeriallyPaintScreen(4);
        }

        public void setPosition(int position) {
            ScrollingScreen thisScreen = (ScrollingScreen)this.get();
            if (thisScreen == null) {
                this.position = 0;
                return;
            }
            if (this.position == (position = ScrollBar.correctPosition(position, this.kind == 1 ? thisScreen.getClientWidth() : thisScreen.getClientHeight(), this.range))) {
                return;
            }
            this.position = position;
            thisScreen.callSeriallyScroll();
        }

        public void setRange(int range) {
            if (range < 0) {
                range = 0;
            }
            if (this.range == range) {
                return;
            }
            this.range = range;
            ScrollingScreen thisScreen = (ScrollingScreen)this.get();
            if (thisScreen == null) {
                this.position = 0;
                return;
            }
            this.recomputePosition(thisScreen, range);
            thisScreen.callSeriallyPaintScreen(4);
        }

        public void scroll(int delta) {
            this.setPosition(this.position + delta);
        }

        public boolean isVisible() {
            return this.visible;
        }

        public int getPosition() {
            return this.position;
        }

        public int getRange() {
            return this.range;
        }

        public int getPage() {
            ScrollingScreen thisScreen = (ScrollingScreen)this.get();
            return thisScreen != null ? (this.kind == 1 ? thisScreen.getClientWidth() : thisScreen.getClientHeight()) : this.range;
        }

        private void recomputePosition(ScrollingScreen scr) {
            int position = this.position;
            this.position = ScrollBar.correctPosition(position, this.kind == 1 ? scr.getClientWidth() : scr.getClientHeight(), this.range);
            if (position == this.position) {
                return;
            }
            scr.callSeriallyScroll();
        }

        private void recomputePosition(ScrollingScreen scr, int range) {
            int position = this.position;
            this.position = ScrollBar.correctPosition(position, this.kind == 1 ? scr.getClientWidth() : scr.getClientHeight(), range);
            if (position == this.position) {
                return;
            }
            scr.callSeriallyScroll();
        }
    }

    private static final class ScrollEvent
    implements Runnable {
        private ScrollingScreen thisScreen;

        ScrollEvent(ScrollingScreen thisScreen) {
            this.thisScreen = thisScreen;
        }

        public void run() {
            ScrollingScreen thisScreen = this.thisScreen;
            thisScreen.stayScroll = false;
            if (!thisScreen.isReallyShown()) {
                thisScreen.needScroll = true;
                return;
            }
            thisScreen.needScroll = false;
            thisScreen.onScroll(thisScreen.getHorzScrollBar(), thisScreen.getVertScrollBar());
            thisScreen.callSeriallyPaintScreen(4);
        }
    }
}

