/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.microedition.system.player;

import javax.microedition.media.Control;
import javax.microedition.media.control.VolumeControl;
import malik.emulator.media.sound.SoundPlayer;
import malik.emulator.media.sound.SoundPlayerException;

public abstract class Volume
implements Control,
VolumeControl {
    private boolean muted;
    private int level = 100;
    protected final Object monitor;

    protected Volume(Object monitor) {
        this.monitor = monitor == null ? new Object() : monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMute(boolean muted) {
        Object object = this.monitor;
        synchronized (object) {
            this.muted = muted;
            if (this.muted != this.muted) {
                int level = this.level;
                SoundPlayer player = this.getSystemPlayer();
                if (player != null) {
                    try {
                        player.setVolume(muted ? 0 : level * 127 / 100);
                    }
                    catch (SoundPlayerException e) {
                        e.printRealStackTrace();
                    }
                }
                this.volumeChanged(muted, level);
            }
        }
    }

    public boolean isMuted() {
        return this.muted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setLevel(int level) {
        if (level < 0) {
            level = 0;
        }
        if (level > 100) {
            level = 100;
        }
        Object object = this.monitor;
        synchronized (object) {
            this.level = level;
            if (this.level != this.level) {
                SoundPlayer player;
                boolean muted = this.muted;
                if (!muted && (player = this.getSystemPlayer()) != null) {
                    try {
                        player.setVolume(level * 127 / 100);
                    }
                    catch (SoundPlayerException e) {
                        e.printRealStackTrace();
                    }
                }
                this.volumeChanged(muted, level);
            }
        }
        return level;
    }

    public int getLevel() {
        return this.level;
    }

    protected abstract SoundPlayer getSystemPlayer();

    protected void volumeChanged(boolean muted, int level) {
    }

    protected void setupSystemPlayer(SoundPlayer player) throws SoundPlayerException {
        player.setVolume(this.muted ? 0 : this.level * 127 / 100);
    }
}

