/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import malik.emulator.i18n.Helper;

public class InputStreamReader
extends Reader {
    private Reader reader;

    public InputStreamReader(InputStream stream) {
        if (stream == null) {
            throw new NullPointerException("InputStreamReader: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 stream \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        this.reader = Helper.getStreamReader(stream);
    }

    public InputStreamReader(InputStream stream, String encoding) throws UnsupportedEncodingException {
        if (stream == null) {
            throw new NullPointerException("InputStreamReader: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 stream \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        this.reader = Helper.getStreamReader(stream, encoding);
    }

    public void close() throws IOException {
        Reader reader = this.reader;
        if (reader == null) {
            return;
        }
        this.reader = null;
        this.lock = null;
        reader.close();
    }

    public void reset() throws IOException {
        this.ensureOpen().reset();
    }

    public void mark(int readLimit) throws IOException {
        Reader reader = this.ensureOpen();
        if (!reader.markSupported()) {
            throw new IOException("InputStreamReader.mark: \u043a\u043b\u0430\u0441\u0441 " + reader.getClass().getName() + " \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u043c\u0435\u0442\u043e\u0434 mark.");
        }
        reader.mark(readLimit);
    }

    public boolean markSupported() {
        Reader reader = this.reader;
        return reader != null && reader.markSupported();
    }

    public boolean ready() throws IOException {
        return this.ensureOpen().ready();
    }

    public int read() throws IOException {
        return this.ensureOpen().read();
    }

    public int read(char[] dst) throws IOException {
        if (dst == null) {
            throw new NullPointerException("InputStreamReader.read: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        return this.ensureOpen().read(dst);
    }

    public int read(char[] dst, int offset, int length) throws IOException {
        if (dst == null) {
            throw new NullPointerException("InputStreamReader.read: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = dst.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("InputStreamReader.read: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return this.ensureOpen().read(dst, offset, length);
    }

    public long skip(long charsCount) throws IOException {
        return this.ensureOpen().skip(charsCount);
    }

    private Reader ensureOpen() throws IOException {
        Reader result = this.reader;
        if (result == null) {
            throw new IOException("InputStreamReader: \u0441\u0438\u043c\u0432\u043e\u043b\u044c\u043d\u044b\u0439 \u043f\u043e\u0442\u043e\u043a \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
        return result;
    }
}

