/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintListener;
import malik.emulator.i18n.Helper;

public class PrintStream
extends OutputStream {
    private static final char[] NULL_STR = new char[]{'n', 'u', 'l', 'l'};
    private boolean closed;
    private boolean trouble;
    private int count;
    private char[] cbuf;
    private byte[] bbuf;
    private PrintListener[] listeners;
    private OutputStream stream;
    private Object lock;

    public PrintStream(OutputStream stream) {
        if (stream == null) {
            throw new NullPointerException("PrintStream: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 stream \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        this.cbuf = new char[1024];
        this.bbuf = new byte[1];
        this.stream = stream;
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                this.flushStream();
                this.closed = true;
                try {
                    this.stream.close();
                }
                catch (IOException iOException) {
                    this.invokeSetError();
                }
                this.stream = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.lock;
        synchronized (object) {
            this.flushStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int src) {
        Object object = this.lock;
        synchronized (object) {
            OutputStream s = this.stream;
            if (s != null) {
                this.flushStream();
                try {
                    s.write(src);
                }
                catch (IOException iOException) {
                    this.invokeSetError();
                }
            } else {
                this.invokeSetError();
            }
        }
        object = this.cbuf;
        synchronized (this.cbuf) {
            byte[] b = this.bbuf;
            this.bbuf[0] = (byte)src;
            this.notifyListenersWrite(b, 0, 1);
            // ** MonitorExit[var4_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] src) throws IOException {
        if (src == null) {
            throw new NullPointerException("PrintStream.write: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Object object = this.lock;
        synchronized (object) {
            OutputStream s = this.stream;
            if (s != null) {
                this.flushStream();
                try {
                    s.write(src);
                }
                catch (IOException iOException) {
                    this.invokeSetError();
                }
            } else {
                this.invokeSetError();
            }
        }
        int length = src.length;
        if (length <= 0) {
            return;
        }
        this.notifyListenersWrite(src, 0, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] src, int offset, int length) {
        if (src == null) {
            throw new NullPointerException("PrintStream.write: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = src.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("PrintStream.write: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        Object object = this.lock;
        synchronized (object) {
            OutputStream s = this.stream;
            if (s != null) {
                this.flushStream();
                try {
                    s.write(src, offset, length);
                }
                catch (IOException iOException) {
                    this.invokeSetError();
                }
            } else {
                this.invokeSetError();
            }
        }
        if (length <= 0) {
            return;
        }
        this.notifyListenersWrite(src, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(boolean src) {
        Object object = this.lock;
        synchronized (object) {
            this.write(src ? "true" : "false", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(char src) {
        Object object = this.lock;
        synchronized (object) {
            this.write(src, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(float src) {
        Object object = this.lock;
        synchronized (object) {
            this.write(Float.toString(src), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(double src) {
        Object object = this.lock;
        synchronized (object) {
            this.write(Double.toString(src), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(int src) {
        Object object = this.lock;
        synchronized (object) {
            this.write(Integer.toString(src), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(long src) {
        Object object = this.lock;
        synchronized (object) {
            this.write(Long.toString(src), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(char[] src) {
        Object object = this.lock;
        synchronized (object) {
            this.write(src, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(String src) {
        Object object = this.lock;
        synchronized (object) {
            this.write(src, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Object src) {
        Object object = this.lock;
        synchronized (object) {
            this.write(String.valueOf(src), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println() {
        Object object = this.lock;
        synchronized (object) {
            this.writeln();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(boolean src) {
        Object object = this.lock;
        synchronized (object) {
            this.write(src ? "true" : "false", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char src) {
        Object object = this.lock;
        synchronized (object) {
            this.write(src, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(float src) {
        Object object = this.lock;
        synchronized (object) {
            this.write(Float.toString(src), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(double src) {
        Object object = this.lock;
        synchronized (object) {
            this.write(Double.toString(src), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(int src) {
        Object object = this.lock;
        synchronized (object) {
            this.write(Integer.toString(src), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(long src) {
        Object object = this.lock;
        synchronized (object) {
            this.write(Long.toString(src), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char[] src) {
        Object object = this.lock;
        synchronized (object) {
            this.write(src, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String src) {
        Object object = this.lock;
        synchronized (object) {
            this.write(src, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object src) {
        Object object = this.lock;
        synchronized (object) {
            this.write(String.valueOf(src), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkError() {
        boolean result;
        Object object = this.lock;
        synchronized (object) {
            if (this.stream != null) {
                this.flushStream();
            }
            result = this.trouble;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPrintListener(PrintListener listener) {
        if (listener == null) {
            return;
        }
        char[] cArray = this.cbuf;
        synchronized (this.cbuf) {
            Object[] listeners = this.listeners;
            if (this.listeners == null) {
                this.listeners = new PrintListener[2];
                listeners = this.listeners;
            }
            if (this.indexOfListener(listener) < 0) {
                int i = this.indexOfListener(null);
                if (i < 0) {
                    Object[] objectArray = listeners;
                    i = listeners.length;
                    this.listeners = new PrintListener[i << 1];
                    listeners = this.listeners;
                    Array.copy(objectArray, 0, this.listeners, 0, i);
                }
                listeners[i] = listener;
            }
            // ** MonitorExit[var4_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removePrintListener(PrintListener listener) {
        if (listener == null) {
            return;
        }
        char[] cArray = this.cbuf;
        synchronized (this.cbuf) {
            int i;
            PrintListener[] listeners = this.listeners;
            if (this.listeners != null && (i = this.indexOfListener(listener)) >= 0) {
                listeners[i] = null;
            }
            // ** MonitorExit[var4_2] (shouldn't be in output)
            return;
        }
    }

    public final Object getMonitor() {
        return this.lock;
    }

    protected void setError() {
    }

    protected final void invokeSetError() {
        this.trouble = true;
        try {
            this.setError();
        }
        catch (RuntimeException runtimeException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersWrite(byte[] src, int offset, int length) {
        char[] cArray = this.cbuf;
        synchronized (this.cbuf) {
            PrintListener[] listeners = this.listeners;
            int i = this.listeners != null ? listeners.length : 0;
            while (i-- > 0) {
                PrintListener listener = listeners[i];
                if (listener == null) continue;
                listener.write(src, offset, length);
            }
            // ** MonitorExit[var7_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersPrint(char src, boolean newLine) {
        char[] cArray = this.cbuf;
        synchronized (this.cbuf) {
            PrintListener[] listeners = this.listeners;
            int i = this.listeners != null ? listeners.length : 0;
            while (i-- > 0) {
                PrintListener listener = listeners[i];
                if (listener == null) continue;
                listener.print(src);
                if (!newLine) continue;
                listener.println();
            }
            // ** MonitorExit[var6_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersPrint(char[] src, boolean newLine) {
        char[] cArray = this.cbuf;
        synchronized (this.cbuf) {
            PrintListener[] listeners = this.listeners;
            int i = this.listeners != null ? listeners.length : 0;
            while (i-- > 0) {
                PrintListener listener = listeners[i];
                if (listener == null) continue;
                listener.print(src);
                if (!newLine) continue;
                listener.println();
            }
            // ** MonitorExit[var6_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersPrint(String src, boolean newLine) {
        char[] cArray = this.cbuf;
        synchronized (this.cbuf) {
            PrintListener[] listeners = this.listeners;
            int i = this.listeners != null ? listeners.length : 0;
            while (i-- > 0) {
                PrintListener listener = listeners[i];
                if (listener == null) continue;
                listener.print(src);
                if (!newLine) continue;
                listener.println();
            }
            // ** MonitorExit[var6_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersPrintln() {
        char[] cArray = this.cbuf;
        synchronized (this.cbuf) {
            PrintListener[] listeners = this.listeners;
            int i = this.listeners != null ? listeners.length : 0;
            while (i-- > 0) {
                PrintListener listener = listeners[i];
                if (listener == null) continue;
                listener.println();
            }
            // ** MonitorExit[var4_1] (shouldn't be in output)
            return;
        }
    }

    private void write(char src, boolean newLine) {
        if (this.stream != null) {
            int c = this.count;
            char[] b = this.cbuf;
            if (c > this.cbuf.length - 3) {
                this.flushStream();
                c = 0;
            }
            b[c++] = src;
            if (newLine) {
                b[c++] = 13;
                b[c++] = 10;
            }
            this.count = c;
        }
        this.notifyListenersPrint(src, newLine);
    }

    private void write(char[] src, boolean newLine) {
        int c;
        if (src == null) {
            c = NULL_STR.length;
            src = new char[c];
            Array.copy(NULL_STR, 0, src, 0, c);
        }
        if (this.stream != null) {
            int r;
            c = this.count;
            char[] b = this.cbuf;
            int bl = this.cbuf.length;
            int sl = src.length;
            if (c > bl - sl - 2) {
                this.flushStream();
                c = 0;
            }
            int i = 0;
            while ((r = sl - i) > 0) {
                int d = Math.min(bl - c, r);
                Array.copy(src, i, b, c, d);
                this.count = c += d;
                if ((i += d) >= sl) continue;
                this.flushStream();
                c = 0;
            }
            if (newLine) {
                if (c > bl - 2) {
                    this.flushStream();
                    c = 0;
                }
                b[c++] = 13;
                b[c++] = 10;
                this.count = c;
            }
        }
        this.notifyListenersPrint(src, newLine);
    }

    private void write(String src, boolean newLine) {
        if (src == null) {
            src = String.valueOf(src);
        }
        if (this.stream != null) {
            int r;
            int c = this.count;
            char[] b = this.cbuf;
            int bl = this.cbuf.length;
            int sl = src.length();
            if (c > bl - sl - 2) {
                this.flushStream();
                c = 0;
            }
            int i = 0;
            while ((r = sl - i) > 0) {
                int d = Math.min(bl - c, r);
                src.getChars(i, i + d, b, c);
                this.count = c += d;
                if ((i += d) >= sl) continue;
                this.flushStream();
                c = 0;
            }
            if (newLine) {
                if (c > bl - 2) {
                    this.flushStream();
                    c = 0;
                }
                b[c++] = 13;
                b[c++] = 10;
                this.count = c;
            }
        }
        this.notifyListenersPrint(src, newLine);
    }

    private void writeln() {
        if (this.stream != null) {
            int c = this.count;
            char[] b = this.cbuf;
            if (c > this.cbuf.length - 2) {
                this.flushStream();
                c = 0;
            }
            b[c++] = 13;
            b[c++] = 10;
            this.count = c;
        }
        this.notifyListenersPrintln();
    }

    private void flushStream() {
        OutputStream s = this.stream;
        if (s != null) {
            try {
                int c = this.count;
                if (c > 0) {
                    this.count = 0;
                    s.write(Helper.charToByteArray(this.cbuf, 0, c));
                    s.flush();
                }
            }
            catch (IOException iOException) {
                this.invokeSetError();
            }
        } else {
            this.invokeSetError();
        }
    }

    private int indexOfListener(PrintListener listener) {
        PrintListener[] listeners = this.listeners;
        int i = this.listeners.length;
        while (i-- > 0) {
            if (listeners[i] != listener) continue;
            return i;
        }
        return -1;
    }
}

