/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Memory {
    private static final int OFFSET_MONITOR = -4;
    private static final int OFFSET_OBJCLASS = 4;
    private static final int OFFSET_LENGTH = 8;
    private static final int OFFSET_DISPLACEMENT = 12;
    private static final int OFFSET_CONTENT = 16;
    private static final int REF_TO_BLOCK = -4;
    private static final int BLOCK_TO_REF = 4;
    private static final int SIZE_HEAD_OBJECT = 12;
    private static final int SIZE_HEAD_ARRAY = 20;
    private static boolean MULTI_THREADED;
    private static boolean RESERVE_ACTIVE;
    private static int STRING_POOL_OFFSET;
    private static int DESCRIPTORS_SIZE;
    private static int HEAP_LIMIT;
    private static int HEAP_BEGIN;
    private static int HEAP_RESERVE;
    private static int DESCRIPTORS_COUNT;
    private static int DESCRIPTORS_RESERVE;
    private static long COLLECTED_BYTES;
    private static int[] FINALIZING_REF_STACK;
    private static long[] DESCRIPTORS;
    private static OutOfMemoryError LACK_MEMORY_ERROR;
    private static NoClassDefFoundError NOT_DEFINED_CLASS_ERROR;

    static {
        int len = STRING_POOL_OFFSET;
        int block = len + 4;
        int splen = MalikSystem.getIntAt(len);
        int i = 0;
        while (i < splen) {
            block += Memory.needMemory(MalikSystem.getIntAt(block + 12));
            ++i;
        }
        block += -block & 0xF;
        int ref = block + 4;
        MalikSystem.setIntAt(ref, 0);
        MalikSystem.setIntAt(ref + -4, 0);
        MalikSystem.setIntAt(ref + 4, 0);
        MalikSystem.setObjectAt(ref + 4, MalikSystem.getClassInstance("[J"));
        len = DESCRIPTORS_SIZE - 20 >> 3;
        MalikSystem.setIntAt(ref + 8, len);
        MalikSystem.setIntAt(ref + 12, 0);
        block += (len << 3) + 20;
        MULTI_THREADED = false;
        RESERVE_ACTIVE = false;
        block += -block & 0xF;
        HEAP_BEGIN = block;
        HEAP_RESERVE = (HEAP_LIMIT - HEAP_BEGIN) / 20;
        DESCRIPTORS_COUNT = 0;
        DESCRIPTORS_RESERVE = len - len / 20;
        COLLECTED_BYTES = 0L;
        DESCRIPTORS = (long[])MalikSystem.convertToObject(ref);
    }

    public static int getFree() {
        int result;
        boolean thread = MULTI_THREADED;
        boolean status = thread && MalikSystem.enterMonopolyAccess();
        try {
            result = Memory.free();
        }
        finally {
            if (thread) {
                MalikSystem.leaveMonopolyAccess(status);
            }
        }
        return result;
    }

    public static int getTotal() {
        return HEAP_LIMIT - HEAP_BEGIN;
    }

    public static long getCollected() {
        return COLLECTED_BYTES;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object[] getAllObjects() {
        boolean thread = MULTI_THREADED;
        boolean status = thread && MalikSystem.enterMonopolyAccess();
        try {
            Object[] result;
            block8: {
                int j;
                int i;
                int dlen;
                int slen;
                int rlen;
                block7: {
                    rlen = DESCRIPTORS_COUNT - MalikSystem.arrayfindf_int(FINALIZING_REF_STACK, 0, 0);
                    result = new Object[rlen];
                    slen = FINALIZING_REF_STACK.length;
                    dlen = DESCRIPTORS_COUNT;
                    i = 0;
                    j = 0;
                    if (!true) break block7;
                    if (i >= rlen) return result;
                    if (j >= dlen) break block8;
                }
                do {
                    Object reference;
                    int ref;
                    if (MalikSystem.arrayfindf_int(FINALIZING_REF_STACK, 0, ref = (int)DESCRIPTORS[j] + 4) >= slen && (reference = MalikSystem.convertToObject(ref)) != result) {
                        result[i++] = reference;
                    }
                    ++j;
                    if (i >= rlen) return result;
                } while (j < dlen);
            }
            return result;
        }
        finally {
            if (thread) {
                MalikSystem.leaveMonopolyAccess(status);
            }
        }
    }

    static void completeInit() {
        FINALIZING_REF_STACK = new int[32];
        LACK_MEMORY_ERROR = new OutOfMemoryError("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u043e\u0431\u044a\u0435\u043a\u0442: \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043f\u0430\u043c\u044f\u0442\u044c \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0430.");
        NOT_DEFINED_CLASS_ERROR = new NoClassDefFoundError("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u043e\u0431\u044a\u0435\u043a\u0442: \u043a\u043b\u0430\u0441\u0441 \u0441\u043e\u0437\u0434\u0430\u0432\u0430\u0435\u043c\u043e\u0433\u043e \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d.");
    }

    static void setMultiThreaded() {
        MULTI_THREADED = true;
    }

    static void checkSize(long refSize) throws OutOfMemoryError {
        if (refSize > 2147483628L) {
            throw LACK_MEMORY_ERROR;
        }
    }

    static boolean isHeapAddress(int beginAddress, int endAddress) {
        return !(beginAddress <= STRING_POOL_OFFSET && endAddress <= STRING_POOL_OFFSET || beginAddress >= HEAP_LIMIT && endAddress >= HEAP_LIMIT);
    }

    static int getStringPoolOffset() {
        return STRING_POOL_OFFSET;
    }

    static long collectGarbage() {
        long result = 0L;
        long lastRunTime = System.currentTimeMillis() - 1000L;
        int i = 0;
        block32: while (i < DESCRIPTORS_COUNT) {
            long deallocated;
            boolean found;
            boolean status;
            int block;
            int ref;
            long currentTime = System.currentTimeMillis();
            long elapsedTime = currentTime - lastRunTime;
            if (elapsedTime >= 1000L || elapsedTime < 0L) {
                lastRunTime = currentTime;
                ref = 0;
                block = 0;
                while (true) {
                    status = MalikSystem.enterMonopolyAccess();
                    try {
                        int index = DESCRIPTORS_COUNT - 1;
                        found = index >= 0 && (index = MalikSystem.findzerob(DESCRIPTORS, index, 4)) >= 0;
                        if (found) {
                            block = (int)DESCRIPTORS[index];
                            Memory.FINALIZING_REF_STACK[0] = ref = block + 4;
                        }
                    }
                    finally {
                        MalikSystem.leaveMonopolyAccess(status);
                    }
                    if (!found) break;
                    try {
                        MalikSystem.convertToObject(ref).$finalize$();
                    }
                    catch (Throwable throwable) {}
                    status = MalikSystem.enterMonopolyAccess();
                    try {
                        deallocated = Memory.deallocate(MalikSystem.blockfindb(DESCRIPTORS, DESCRIPTORS_COUNT - 1, block));
                        Memory.FINALIZING_REF_STACK[0] = 0;
                    }
                    finally {
                        MalikSystem.leaveMonopolyAccess(status);
                    }
                    result += deallocated;
                    COLLECTED_BYTES += deallocated;
                }
            }
            while ((ref = (block = (int)DESCRIPTORS[i]) + 4) != 4) {
                block58: {
                    if (!StringPool.isMyOwnedObject(MalikSystem.convertToObject(ref))) {
                        status = MalikSystem.enterMonopolyAccess();
                        try {
                            found = MalikSystem.getIntAt(ref) == MalikSystem.convertToObject(ref).getQuantityOfReferencesTo(ref);
                            if (found) {
                                Memory.FINALIZING_REF_STACK[0] = ref;
                            }
                        }
                        finally {
                            MalikSystem.leaveMonopolyAccess(status);
                        }
                        if (found) {
                            try {
                                MalikSystem.convertToObject(ref).$finalize$();
                            }
                            catch (Throwable throwable) {}
                            status = MalikSystem.enterMonopolyAccess();
                            try {
                                deallocated = Memory.deallocate(MalikSystem.blockfindb(DESCRIPTORS, DESCRIPTORS_COUNT - 1, block));
                                Memory.FINALIZING_REF_STACK[0] = 0;
                            }
                            finally {
                                MalikSystem.leaveMonopolyAccess(status);
                            }
                            result += deallocated;
                            COLLECTED_BYTES += deallocated;
                            continue;
                        }
                        ref = (int)DESCRIPTORS[i] + 4;
                        if (ref == 4) break block32;
                        if (!StringPool.isMyOwnedObject(MalikSystem.convertToObject(ref))) {
                            int esp = 1;
                            int ebp = 0;
                            Memory.FINALIZING_REF_STACK[0] = ref;
                            while (ebp < esp) {
                                int refCount = 0;
                                ref = FINALIZING_REF_STACK[ebp];
                                int j = 0;
                                while (j < DESCRIPTORS_COUNT) {
                                    int count;
                                    int refAnot;
                                    if ((j & 0x3FF) == 1023 && ((elapsedTime = (currentTime = System.currentTimeMillis()) - lastRunTime) >= 1000L || elapsedTime < 0L)) {
                                        lastRunTime = currentTime;
                                        refAnot = 0;
                                        block = 0;
                                        while (true) {
                                            status = MalikSystem.enterMonopolyAccess();
                                            try {
                                                int index = DESCRIPTORS_COUNT - 1;
                                                found = index >= 0 && (index = MalikSystem.findzerob(DESCRIPTORS, index, 4)) >= 0 && Memory.push(refAnot = (block = (int)DESCRIPTORS[index]) + 4, esp);
                                            }
                                            finally {
                                                MalikSystem.leaveMonopolyAccess(status);
                                            }
                                            if (!found) break;
                                            try {
                                                MalikSystem.convertToObject(refAnot).$finalize$();
                                            }
                                            catch (Throwable throwable) {}
                                            status = MalikSystem.enterMonopolyAccess();
                                            try {
                                                deallocated = Memory.deallocate(MalikSystem.blockfindb(DESCRIPTORS, DESCRIPTORS_COUNT - 1, block));
                                                Memory.FINALIZING_REF_STACK[esp] = 0;
                                            }
                                            finally {
                                                MalikSystem.leaveMonopolyAccess(status);
                                            }
                                            result += deallocated;
                                            COLLECTED_BYTES += deallocated;
                                        }
                                    }
                                    if ((refAnot = (int)DESCRIPTORS[j] + 4) == 4) break;
                                    status = MalikSystem.enterMonopolyAccess();
                                    try {
                                        count = MalikSystem.convertToObject(refAnot).getQuantityOfReferencesTo(ref);
                                        found = count > 0;
                                        if (found && Memory.push(refAnot, esp)) {
                                            ++esp;
                                        }
                                    }
                                    finally {
                                        MalikSystem.leaveMonopolyAccess(status);
                                    }
                                    if (found) {
                                        refCount += count;
                                    }
                                    ++j;
                                }
                                if (refCount < MalikSystem.getIntAt(ref)) {
                                    MalikSystem.arrayfill_int(FINALIZING_REF_STACK, 0, esp, 0);
                                    break block58;
                                }
                                ++ebp;
                            }
                            int j = esp;
                            while (j-- > 0) {
                                try {
                                    MalikSystem.convertToObject(FINALIZING_REF_STACK[j]).$finalize$();
                                }
                                catch (Throwable throwable) {}
                            }
                            j = esp;
                            while (j-- > 0) {
                                status = MalikSystem.enterMonopolyAccess();
                                try {
                                    deallocated = Memory.deallocate(MalikSystem.blockfindb(DESCRIPTORS, DESCRIPTORS_COUNT - 1, FINALIZING_REF_STACK[j] + -4));
                                    if (j == 0) {
                                        MalikSystem.arrayfill_int(FINALIZING_REF_STACK, 0, esp, 0);
                                    }
                                }
                                finally {
                                    MalikSystem.leaveMonopolyAccess(status);
                                }
                                result += deallocated;
                                COLLECTED_BYTES += deallocated;
                            }
                        }
                    }
                }
                ++i;
                continue block32;
            }
            break block32;
        }
        return result;
    }

    static Object intern(Object instance) {
        Object result = instance;
        if (result == null) {
            return null;
        }
        Class instanceClass = instance.getClass();
        boolean thread = MULTI_THREADED;
        boolean status = thread && MalikSystem.enterMonopolyAccess();
        try {
            int slen = FINALIZING_REF_STACK.length;
            int i = 0;
            while (i < DESCRIPTORS_COUNT) {
                int ref = (int)DESCRIPTORS[i] + 4;
                if (MalikSystem.arrayfindf_int(FINALIZING_REF_STACK, 0, ref) >= slen && MalikSystem.getObjectAt(ref + 4) == instanceClass && MalikSystem.convertToObject(ref).equals(instance)) {
                    result = MalikSystem.convertToObject(ref);
                    break;
                }
                ++i;
            }
        }
        finally {
            if (thread) {
                MalikSystem.leaveMonopolyAccess(status);
            }
        }
        return result;
    }

    static Object internIgnore(Object instance) {
        Object result = instance;
        if (result == null) {
            return null;
        }
        Class instanceClass = instance.getClass();
        boolean thread = MULTI_THREADED;
        boolean status = thread && MalikSystem.enterMonopolyAccess();
        try {
            int slen = FINALIZING_REF_STACK.length;
            int i = 0;
            while (i < DESCRIPTORS_COUNT) {
                int ref = (int)DESCRIPTORS[i] + 4;
                if (MalikSystem.arrayfindf_int(FINALIZING_REF_STACK, 0, ref) >= slen && ref != MalikSystem.convertToReference(instance) && MalikSystem.getObjectAt(ref + 4) == instanceClass && MalikSystem.convertToObject(ref).equals(instance)) {
                    result = MalikSystem.convertToObject(ref);
                    break;
                }
                ++i;
            }
        }
        finally {
            if (thread) {
                MalikSystem.leaveMonopolyAccess(status);
            }
        }
        return result;
    }

    static Object allocateInstanceOf(Class instanceClass, int refSize, int arrayLength) throws OutOfMemoryError, NoClassDefFoundError {
        Object result;
        if (instanceClass == null) {
            throw NOT_DEFINED_CLASS_ERROR;
        }
        if (refSize <= 0) {
            return null;
        }
        int blockSize = refSize - -4;
        blockSize += -blockSize & 0xF;
        refSize = blockSize - 4;
        boolean thread = MULTI_THREADED;
        boolean status = thread && MalikSystem.enterMonopolyAccess();
        try {
            result = Memory.makeObject(instanceClass, Memory.allocate(blockSize) + 4, refSize, arrayLength);
        }
        finally {
            if (thread) {
                MalikSystem.leaveMonopolyAccess(status);
            }
        }
        return result;
    }

    private static void outOfMemory() throws OutOfMemoryError {
        if (RESERVE_ACTIVE) {
            MalikSystem.syscall((long)Thread.MAIN_THREAD_ID, 1);
        }
        RESERVE_ACTIVE = true;
        throw LACK_MEMORY_ERROR;
    }

    private static boolean push(int ref, int top) {
        if (MalikSystem.arrayfindf_int(FINALIZING_REF_STACK, 0, ref) < top) {
            return false;
        }
        if (top == FINALIZING_REF_STACK.length) {
            int[] nArray = FINALIZING_REF_STACK;
            FINALIZING_REF_STACK = new int[top << 1];
            MalikSystem.arraycopyf_int(nArray, 0, FINALIZING_REF_STACK, 0, top);
        }
        Memory.FINALIZING_REF_STACK[top] = ref;
        return true;
    }

    private static int free() {
        int n;
        int i = DESCRIPTORS_COUNT - 1;
        if (i >= 0) {
            long descriptor = DESCRIPTORS[i];
            n = (int)descriptor + (int)(descriptor >> 32);
        } else {
            n = HEAP_BEGIN;
        }
        return HEAP_LIMIT - n;
    }

    private static int allocate(int blockSize) throws OutOfMemoryError {
        if (RESERVE_ACTIVE && (DESCRIPTORS_COUNT < DESCRIPTORS_RESERVE || Memory.free() > HEAP_RESERVE)) {
            RESERVE_ACTIVE = false;
        }
        if (DESCRIPTORS_COUNT >= (RESERVE_ACTIVE ? DESCRIPTORS.length : DESCRIPTORS_RESERVE)) {
            Memory.outOfMemory();
        }
        if (DESCRIPTORS_COUNT == 0) {
            if (blockSize > HEAP_LIMIT - HEAP_BEGIN) {
                Memory.outOfMemory();
            }
            Memory.DESCRIPTORS[Memory.DESCRIPTORS_COUNT++] = Memory.makeDescriptor(HEAP_BEGIN, blockSize);
            return HEAP_BEGIN;
        }
        int i = MalikSystem.findfreef(DESCRIPTORS, 0, blockSize);
        if (i > 0 && i < DESCRIPTORS_COUNT) {
            int n = DESCRIPTORS_COUNT;
            int n2 = DESCRIPTORS_COUNT + 1;
            MalikSystem.arraycopyb_long(DESCRIPTORS, n, DESCRIPTORS, n2, DESCRIPTORS_COUNT++ - i);
            int result = (int)DESCRIPTORS[i] - blockSize;
            Memory.DESCRIPTORS[i] = Memory.makeDescriptor(result, blockSize);
            return result;
        }
        i = DESCRIPTORS_COUNT - 1;
        long descriptor = DESCRIPTORS[i];
        int result = (int)descriptor + (int)(descriptor >> 32);
        if (blockSize > HEAP_LIMIT - result) {
            Memory.outOfMemory();
        }
        Memory.DESCRIPTORS[Memory.DESCRIPTORS_COUNT++] = Memory.makeDescriptor(result, blockSize);
        return result;
    }

    private static int deallocate(int blockIndex) {
        if (blockIndex >= 0) {
            int result = (int)(DESCRIPTORS[blockIndex] >> 32);
            MalikSystem.arraycopyf_long(DESCRIPTORS, blockIndex + 1, DESCRIPTORS, blockIndex, --DESCRIPTORS_COUNT - blockIndex);
            Memory.DESCRIPTORS[Memory.DESCRIPTORS_COUNT] = 0L;
            return result;
        }
        return 0;
    }

    private static int needMemory(int length) {
        return length + (-length & 3) + 20;
    }

    private static long makeDescriptor(int block, int blockSize) {
        return (long)blockSize << 32 | (long)block & 0xFFFFFFFFL;
    }

    private static Object makeObject(Class instanceClass, int ref, int refSize, int arrayLength) {
        MalikSystem.setIntAt(ref, 0);
        MalikSystem.setIntAt(ref + -4, 0);
        MalikSystem.setIntAt(ref + 4, 0);
        MalikSystem.setObjectAt(ref + 4, instanceClass);
        Object result = MalikSystem.convertToObject(ref);
        if (refSize > 16) {
            int len = refSize - 16 >> 2;
            MalikSystem.setIntAt(ref + 8, len);
            MalikSystem.setIntAt(ref + 12, 0);
            MalikSystem.arrayfill_int(result, 0, len, 0);
        }
        MalikSystem.setIntAt(ref + 8, arrayLength >= 0 ? arrayLength : 0);
        return result;
    }

    private Memory() {
    }
}

