/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class StringBuffer {
    private boolean shared;
    private int length;
    private char[] chars;
    private final Object monitor;

    public StringBuffer() {
        this.chars = new char[16];
        this.monitor = new Object();
    }

    public StringBuffer(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new NegativeArraySizeException("StringBuffer: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 initialCapacity \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        this.chars = new char[initialCapacity];
        this.monitor = new Object();
    }

    public StringBuffer(String initialContent) {
        char[] chars;
        int length;
        if (initialContent != null) {
            length = initialContent.length();
            chars = new char[length + 16];
            initialContent.getChars(0, length, chars, 0);
        } else {
            length = 0;
            chars = new char[16];
        }
        this.length = length;
        this.chars = chars;
        this.monitor = new Object();
    }

    public String toString() {
        return new String(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureCapacity(int minimumCapacity) {
        Object object = this.monitor;
        synchronized (object) {
            if (minimumCapacity > this.chars.length) {
                this.madeLarger(minimumCapacity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLength(int length) {
        if (length < 0) {
            throw new IndexOutOfBoundsException("StringBuffer.setLength: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 length \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        Object object = this.monitor;
        synchronized (object) {
            char[] c = this.chars;
            if (length > this.chars.length) {
                c = this.madeLarger(length);
            }
            int len = this.length;
            this.length = length;
            if (length > len) {
                MalikSystem.arrayfill_short(c, len, length - len, 0);
            } else if (length < len && this.shared) {
                if (length > 0) {
                    this.copy();
                } else {
                    this.chars = new char[16];
                    this.shared = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCharAt(int index, char character) {
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            if (index < 0 || index >= this.length) {
                error = true;
            } else {
                (this.shared ? this.copy() : this.chars)[index] = character;
            }
        }
        if (error) {
            throw new StringIndexOutOfBoundsException("StringBuffer.setCharAt: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 index \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getChars(int beginIndex, int endIndex, char[] dst, int offset) {
        int error = 0;
        Object object = this.monitor;
        synchronized (object) {
            int len;
            if ((beginIndex | endIndex) < 0 || beginIndex > (len = this.length) || endIndex > len || beginIndex > endIndex) {
                error = 1;
            } else if (dst == null) {
                error = 2;
            } else {
                int length = endIndex - beginIndex;
                int lim = offset + length;
                len = dst.length;
                if (lim > len || lim < offset || offset > len || offset < 0) {
                    error = 3;
                } else if (length > 0) {
                    MalikSystem.arraycopyf_short(this.chars, beginIndex, dst, offset, length);
                }
            }
        }
        switch (error) {
            case 1: {
                throw new StringIndexOutOfBoundsException("StringBuffer.getChars: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
            }
            case 2: {
                throw new NullPointerException("StringBuffer.getChars: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
            }
            case 3: {
                throw new ArrayIndexOutOfBoundsException("StringBuffer.getChars: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char charAt(int index) {
        char result;
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            if (index < 0 || index >= this.length) {
                error = true;
                result = '\u0000';
            } else {
                result = this.chars[index];
            }
        }
        if (error) {
            throw new StringIndexOutOfBoundsException("StringBuffer.charAt: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 index \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return result;
    }

    public int length() {
        return this.length;
    }

    public int capacity() {
        return this.chars.length;
    }

    public StringBuffer insert(int position, boolean value) {
        return this.insert(position, value ? "true" : "false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer insert(int position, char value) {
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            int len;
            if (position < 0 || position > (len = this.length)) {
                error = true;
            } else {
                int newlen = len + 1;
                char[] c = this.chars;
                if (newlen > this.chars.length) {
                    c = this.madeLarger(newlen);
                }
                if (len > position) {
                    if (this.shared) {
                        c = this.copy();
                    }
                    MalikSystem.arraycopyb_short(c, len, c, newlen, len - position);
                }
                c[position] = value;
                this.length = newlen;
            }
        }
        if (error) {
            throw new StringIndexOutOfBoundsException("StringBuffer.insert: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 position \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return this;
    }

    public StringBuffer insert(int position, float value) {
        return this.insert(position, Float.toString(value));
    }

    public StringBuffer insert(int position, double value) {
        return this.insert(position, Double.toString(value));
    }

    public StringBuffer insert(int position, int value) {
        return this.insert(position, Integer.toString(value, 10));
    }

    public StringBuffer insert(int position, long value) {
        return this.insert(position, Long.toString(value, 10));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer insert(int position, char[] src) {
        int length = src == null ? 0 : src.length;
        if (length <= 0) {
            return this;
        }
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            int len;
            if (position < 0 || position > (len = this.length)) {
                error = true;
            } else if (length > 0) {
                int newlen = len + length;
                char[] c = this.chars;
                if (newlen > this.chars.length) {
                    c = this.madeLarger(newlen);
                }
                if (len > position) {
                    if (this.shared) {
                        c = this.copy();
                    }
                    MalikSystem.arraycopyb_short(c, len, c, newlen, len - position);
                }
                MalikSystem.arraycopyf_short(src, 0, c, position, length);
                this.length = newlen;
            }
        }
        if (error) {
            throw new StringIndexOutOfBoundsException("StringBuffer.insert: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 position \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer insert(int position, String value) {
        boolean error = false;
        if (value == null) {
            value = "null";
        }
        int length = value.length();
        Object object = this.monitor;
        synchronized (object) {
            int len;
            if (position < 0 || position > (len = this.length)) {
                error = true;
            } else if (length > 0) {
                int newlen = len + length;
                char[] c = this.chars;
                if (newlen > this.chars.length) {
                    c = this.madeLarger(newlen);
                }
                if (len > position) {
                    if (this.shared) {
                        c = this.copy();
                    }
                    MalikSystem.arraycopyb_short(c, len, c, newlen, len - position);
                }
                value.getChars(0, length, c, position);
                this.length = newlen;
            }
        }
        if (error) {
            throw new StringIndexOutOfBoundsException("StringBuffer.insert: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 position \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return this;
    }

    public StringBuffer insert(int position, Object value) {
        return this.insert(position, value == null ? "null" : value.toString());
    }

    public StringBuffer append(boolean value) {
        return this.append(value ? "true" : "false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer append(char value) {
        Object object = this.monitor;
        synchronized (object) {
            int len = this.length;
            int newlen = len + 1;
            char[] c = this.chars;
            if (newlen > this.chars.length) {
                c = this.madeLarger(newlen);
            }
            c[len] = value;
            this.length = newlen;
        }
        return this;
    }

    public StringBuffer append(float value) {
        return this.append(Float.toString(value));
    }

    public StringBuffer append(double value) {
        return this.append(Double.toString(value));
    }

    public StringBuffer append(int value) {
        return this.append(Integer.toString(value, 10));
    }

    public StringBuffer append(long value) {
        return this.append(Long.toString(value, 10));
    }

    public StringBuffer append(char[] src) {
        return src == null ? this : this.append(src, 0, src.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer append(char[] src, int offset, int length) {
        if (src == null) {
            return this;
        }
        long bounds = Array.intersectBound(src.length, offset, length);
        offset = (int)bounds;
        length = (int)(bounds >> 32);
        Object object = this.monitor;
        synchronized (object) {
            int len = this.length;
            int newlen = len + length;
            char[] c = this.chars;
            if (newlen > this.chars.length) {
                c = this.madeLarger(newlen);
            }
            if (length > 0) {
                MalikSystem.arraycopyf_short(src, offset, c, len, length);
                this.length = newlen;
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer append(String value) {
        if (value == null) {
            value = "null";
        }
        int length = value.length();
        Object object = this.monitor;
        synchronized (object) {
            int len = this.length;
            int newlen = len + length;
            char[] c = this.chars;
            if (newlen > this.chars.length) {
                c = this.madeLarger(newlen);
            }
            if (length > 0) {
                value.getChars(0, length, c, len);
                this.length = newlen;
            }
        }
        return this;
    }

    public StringBuffer append(Object value) {
        return this.append(value == null ? "null" : value.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer deleteCharAt(int index) {
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            int len;
            if (index < 0 || index >= (len = this.length)) {
                error = true;
            } else {
                int cnt;
                char[] c = this.shared ? this.copy() : this.chars;
                if ((cnt = --len - index) > 0) {
                    MalikSystem.arraycopyf_short(c, index + 1, c, index, cnt);
                }
                this.length = len;
            }
        }
        if (error) {
            throw new StringIndexOutOfBoundsException("StringBuffer.deleteCharAt: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 index \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer delete(int beginIndex, int endIndex) {
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            int len = this.length;
            if (endIndex > len) {
                endIndex = len;
            }
            if ((beginIndex | endIndex) < 0 || beginIndex > endIndex) {
                error = true;
            } else {
                int cnt = endIndex - beginIndex;
                if (cnt > 0) {
                    char[] c;
                    char[] cArray = c = this.shared ? this.copy() : this.chars;
                    if (len > endIndex) {
                        MalikSystem.arraycopyf_short(c, endIndex, c, beginIndex, len - endIndex);
                    }
                    this.length = len - cnt;
                }
            }
        }
        if (error) {
            throw new StringIndexOutOfBoundsException("StringBuffer.delete: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer reverse() {
        Object object = this.monitor;
        synchronized (object) {
            int len = this.length;
            char[] c = this.shared ? this.copy() : this.chars;
            int i = len >> 1;
            int j = len - i;
            while (i-- > 0) {
                char ci = c[i];
                c[i] = c[j];
                c[j] = ci;
                ++j;
            }
        }
        return this;
    }

    void setShared() {
        this.shared = true;
    }

    char[] content() {
        return this.chars;
    }

    Object monitor() {
        return this.monitor;
    }

    private char[] copy() {
        char[] result = this.chars;
        result = this.chars = new char[result.length];
        MalikSystem.arraycopyf_short(this.chars, 0, this.chars, 0, this.length);
        this.shared = false;
        return result;
    }

    private char[] madeLarger(int neededCharacters) {
        char[] result = this.chars;
        int capacity = this.chars.length + 1 << 1;
        if (capacity <= 0) {
            capacity = Integer.MAX_VALUE;
        } else if (capacity < neededCharacters) {
            capacity = neededCharacters;
        }
        char[] cArray = result;
        result = this.chars = new char[capacity];
        MalikSystem.arraycopyf_short(cArray, 0, this.chars, 0, this.length);
        this.shared = false;
        return result;
    }
}

