/*
 * Decompiled with CFR 0.152.
 */
package java.util;

public class Random {
    private static final long MULTIPLIER = 25214903917L;
    private static final long ADDEND = 11L;
    private static final long MASK = 0xFFFFFFFFFFFFL;
    private long seed;

    public Random() {
        this.setSeed(System.currentTimeMillis());
    }

    public Random(long seed) {
        this.setSeed(seed);
    }

    public synchronized void setSeed(long seed) {
        this.seed = (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
    }

    public float nextFloat() {
        return (float)this.next(24) / 1.6777216E7f;
    }

    public double nextDouble() {
        return (double)(((long)this.next(26) << 27) + (long)this.next(27)) / 9.007199254740992E15;
    }

    public int nextInt(int limit) {
        int result;
        int bits;
        if (limit <= 0) {
            throw new IllegalArgumentException("Random.nextInt: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 limit \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if ((limit & -limit) == limit) {
            return (int)((long)limit * (long)this.next(31) >> 31);
        }
        while ((bits = this.next(31)) - (result = bits % limit) + limit - 1 < 0) {
        }
        return result;
    }

    public int nextInt() {
        return this.next(32);
    }

    public long nextLong() {
        return ((long)this.next(32) << 32) + (long)this.next(32);
    }

    protected synchronized int next(int bits) {
        this.seed = this.seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(this.seed >>> 48 - bits);
    }
}

