/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.fileformats.text.mapped;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import malik.emulator.fileformats.InvalidDataFormatException;
import malik.emulator.fileformats.text.mapped.AttributableMappedTextDecoder;
import malik.emulator.fileformats.text.mapped.CustomKeyValueList;

public class ManifestFile
extends CustomKeyValueList
implements AttributableMappedTextDecoder {
    public static final char KEY_VALUE_SEPARATOR = ':';
    public static final char ATTRIBUTES_SEPARATOR = ',';
    private String key;
    private String value;

    private static int skipLineEndings(byte[] stream, int offset) {
        byte c;
        int i = offset;
        while ((c = stream[i]) == 10 || c == 13) {
            i += c == 13 && stream[i + 1] == 10 ? 2 : 1;
        }
        return i;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadFromInputStream(InputStream stream) throws IOException, InvalidDataFormatException {
        int size = stream.available();
        byte[] s = new byte[size + 1];
        stream.read(s, 0, size);
        this.clear();
        try {
            block7: {
                int i;
                block6: {
                    i = size >= 3 && s[0] == -17 && s[1] == -69 && s[2] == -65 ? 3 : 0;
                    if (!true) break block6;
                    i = ManifestFile.skipLineEndings(s, i);
                    if (s[i] == 0) return;
                    if (i >= size) break block7;
                }
                do {
                    if (s[i = this.parseKey(s, i)] != 58) {
                        throw new InvalidDataFormatException("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 MANIFEST-\u0444\u0430\u0439\u043b\u0430.");
                    }
                    i = this.parseValue(s, i + 1);
                    this.set(this.key, this.value);
                    i = ManifestFile.skipLineEndings(s, i);
                    if (s[i] == 0) return;
                } while (i < size);
            }
            return;
        }
        finally {
            this.key = null;
            this.value = null;
        }
    }

    public void loadFromInputStream(InputStream stream, String encoding) throws IOException, InvalidDataFormatException, UnsupportedEncodingException {
        this.loadFromInputStream(stream);
    }

    public void loadFromDataStream(DataInputStream stream) throws IOException, InvalidDataFormatException {
        this.loadFromInputStream(stream);
    }

    public void loadFromDataStream(DataInputStream stream, String encoding) throws IOException, InvalidDataFormatException, UnsupportedEncodingException {
        this.loadFromInputStream(stream);
    }

    public String[] getAttributes(String key) {
        String val = this.get(key);
        if (val == null) {
            return null;
        }
        int length = (val = val.trim()).length();
        if (length == 0) {
            return new String[0];
        }
        int len = 1;
        int j = length;
        while (j-- > 0) {
            if (val.charAt(j) != ',') continue;
            ++len;
        }
        String[] result = new String[len];
        int index = 0;
        int i = 0;
        j = 0;
        while (j <= length) {
            if (j == length || val.charAt(j) == ',') {
                result[index++] = val.substring(i, j).trim().intern();
                i = j + 1;
            }
            ++j;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private int parseKey(byte[] stream, int offset) throws InvalidDataFormatException {
        i = offset;
        if ((c = stream[i++]) >= 48 && c <= 57 || c >= 65 && c <= 90 || c >= 97 && c <= 122) ** GOTO lbl5
        throw new InvalidDataFormatException("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 MANIFEST-\u0444\u0430\u0439\u043b\u0430.");
lbl-1000:
        // 1 sources

        {
            ++i;
lbl5:
            // 2 sources

            ** while ((c = stream[i]) >= 48 && c <= 57 || c >= 65 && c <= 90 || c >= 97 && c <= 122 || c == 45 || c == 95)
        }
lbl6:
        // 1 sources

        this.key = new String(stream, offset, i - offset).intern();
        return i;
    }

    private int parseValue(byte[] stream, int offset) {
        int i = offset;
        if (stream[i] == 32) {
            offset = ++i;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        while (true) {
            byte c;
            if ((c = stream[i]) != 0 && c != 10 && c != 13) {
                ++i;
                continue;
            }
            result.write(stream, offset, i - offset);
            if (c == 0 || (c = stream[i += c == 13 && stream[i + 1] == 10 ? 2 : 1]) != 32) break;
            offset = ++i;
        }
        this.value = result.toString().intern();
        return i;
    }
}

