/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.i18n.encoding.system;

import malik.emulator.i18n.Codec;

public class UTF_8_Codec
implements Codec {
    public char[] decode(byte[] src, int offset, int length) {
        int newlength = 0;
        char[] result = new char[length];
        length += offset;
        while (offset < length) {
            int char1 = src[offset++] & 0xFF;
            switch (char1 >> 4) {
                default: {
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    result[newlength++] = (char)char1;
                    break;
                }
                case 12: 
                case 13: {
                    byte char2;
                    byte by = char2 = ++offset > length ? (byte)0 : src[offset - 1];
                    if ((char2 & 0xC0) != 128) {
                        --offset;
                        char2 = 0;
                    }
                    result[newlength++] = (char)((char1 & 0x1F) << 6 | char2 & 0x3F);
                    break;
                }
                case 14: {
                    byte char3;
                    byte char2 = ++offset > length ? (byte)0 : src[offset - 1];
                    byte by = char3 = ++offset > length ? (byte)0 : src[offset - 1];
                    if ((char3 & 0xC0) != 128) {
                        --offset;
                        char3 = 0;
                    }
                    if ((char2 & 0xC0) != 128) {
                        --offset;
                        char2 = 0;
                    }
                    result[newlength++] = (char)((char1 & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                }
            }
        }
        if (newlength < result.length) {
            char[] cArray = result;
            result = new char[newlength];
            Array.copy(cArray, 0, result, 0, newlength);
        }
        return result;
    }

    public byte[] encode(char[] src, int offset, int length) {
        int newlength = 0;
        byte[] result = new byte[3 * length];
        while (offset < length) {
            char c;
            if ((c = src[offset++]) > '\u0000' && c <= '\u007f') {
                result[newlength++] = (byte)c;
                continue;
            }
            if (c <= '\u07ff') {
                result[newlength++] = (byte)(192 + (c >> 6 & 0x1F));
                result[newlength++] = (byte)(128 + (c & 0x3F));
                continue;
            }
            result[newlength++] = (byte)(224 + (c >> 12 & 0xF));
            result[newlength++] = (byte)(128 + (c >> 6 & 0x3F));
            result[newlength++] = (byte)(128 + (c & 0x3F));
        }
        if (newlength < result.length) {
            byte[] byArray = result;
            result = new byte[newlength];
            Array.copy(byArray, 0, result, 0, newlength);
        }
        return result;
    }
}

