/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.io.cloud;

import malik.emulator.io.cloud.CloudFileSystem;
import malik.emulator.io.cloud.FileInfoDescriptor;
import malik.emulator.io.vfs.FileEnumerator;

final class CloudFileEnumerator
extends FileEnumerator {
    private int handle;
    private char[] fileName;
    private FileInfoDescriptor descriptor;

    CloudFileEnumerator(int handle, char[] fileName, FileInfoDescriptor descriptor) {
        this.setFileInfo(fileName, descriptor);
        this.handle = handle;
        this.fileName = fileName;
        this.descriptor = descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        FileInfoDescriptor fileInfoDescriptor = this.descriptor;
        synchronized (fileInfoDescriptor) {
            int h = this.handle;
            if (h != 0) {
                MalikSystem.syscall((long)h, 26);
                this.handle = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean findNext() {
        FileInfoDescriptor descriptor;
        FileInfoDescriptor fileInfoDescriptor = descriptor = this.descriptor;
        synchronized (descriptor) {
            boolean result;
            int h = this.handle;
            if (h == 0 || (int)MalikSystem.syscall(h, descriptor.getDescriptorAddress(), 25) == 0) {
                result = false;
            } else {
                this.setFileInfo(this.fileName, descriptor);
                result = true;
            }
            // ** MonitorExit[var4_2] (shouldn't be in output)
            return result;
        }
    }

    protected void $finalize$() {
        this.close();
    }

    private void setFileInfo(char[] fileName, FileInfoDescriptor descriptor) {
        this.setFileInfo(CloudFileSystem.computeTime(descriptor.creationTime), CloudFileSystem.computeTime(descriptor.lastAccessTime), CloudFileSystem.computeTime(descriptor.lastWriteTime), descriptor.attributes, descriptor.size, new String(fileName, 0, Array.findf(fileName, 0, 0)));
    }
}

