/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.io.cloud;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import malik.emulator.util.DataDescriptor;

public class FileOutputStream
extends OutputStream {
    private static final int OPEN_ERROR_NO_ERROR = 0;
    private static final int OPEN_ERROR_FILE_NAME_NOT_SPECIFIED = 1;
    private static final int OPEN_ERROR_FILE_ACCESS_DENIED = 2;
    private int handle;
    private int openError;
    private Object lock;
    private String fileName;
    private DataDescriptor descriptor;

    public FileOutputStream(String fileName) {
        this(fileName, false);
    }

    public FileOutputStream(String fileName, boolean appending) {
        int h;
        if (fileName == null || (h = fileName.length()) == 0) {
            this.handle = 0;
            this.openError = 1;
            this.lock = new Object();
            this.fileName = fileName;
            this.descriptor = null;
            return;
        }
        char[] fn = new char[h + 1];
        fileName.getChars(0, h, fn, 0);
        h = (int)MalikSystem.syscall(Array.getFirstElementAddress(fn), appending ? 0 : 2, 16);
        if (h == 0) {
            this.handle = 0;
            this.openError = 2;
            this.lock = new Object();
            this.fileName = fileName;
            this.descriptor = null;
            return;
        }
        this.handle = h;
        this.openError = 0;
        this.lock = new Object();
        this.fileName = fileName;
        this.descriptor = new DataDescriptor();
    }

    public String toString() {
        return (this.handle != 0 ? "\u041e\u0442\u043a\u0440\u044b\u0442\u044b\u0439 \u0434\u043b\u044f \u0437\u0430\u043f\u0438\u0441\u0438 \u0444\u0430\u0439\u043b " : "\u0417\u0430\u043a\u0440\u044b\u0442\u044b\u0439 \u0444\u0430\u0439\u043b ").concat(this.fileName);
    }

    public void checkOpenError() throws IOException {
        switch (this.openError) {
            default: {
                if (this.handle != 0) {
                    return;
                }
                throw new IOException("FileOutputStream: \u0444\u0430\u0439\u043b " + this.fileName + " \u0431\u044b\u043b \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 1: {
                throw new IOException("FileOutputStream: \u0438\u043c\u044f \u0444\u0430\u0439\u043b\u0430 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e.");
            }
            case 2: 
        }
        throw new IOException("FileOutputStream: \u0444\u0430\u0439\u043b " + this.fileName + " \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d \u0434\u043b\u044f \u0437\u0430\u043f\u0438\u0441\u0438.");
    }

    public boolean hasOpenError() {
        return this.openError != 0 || this.handle == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() throws IOException {
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            int h = this.handle;
            if (h == 0) {
                error = true;
            } else {
                MalikSystem.syscall((long)h, 17);
                this.handle = 0;
            }
        }
        if (error) {
            throw new IOException("FileOutputStream: \u0444\u0430\u0439\u043b " + this.fileName + " \u0431\u044b\u043b \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
    }

    public final void flush() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(int src) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkOpenError();
            this.descriptor.setDataInfo(MalikSystem.getLocalVariableAddress(src), 1);
            this.writeFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(byte[] src) throws IOException {
        if (src == null) {
            throw new NullPointerException("FileOutputStream.write: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkOpenError();
            int length = src.length;
            if (length > 0) {
                this.descriptor.setDataInfo(src, 0, length);
                this.writeFile();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(byte[] src, int offset, int length) throws IOException {
        if (src == null) {
            throw new NullPointerException("FileOutputStream.write: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = src.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("FileOutputStream.write: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkOpenError();
            if (length > 0) {
                this.descriptor.setDataInfo(src, offset, length);
                this.writeFile();
            }
        }
    }

    public final String getFileName() {
        return this.fileName;
    }

    protected void $finalize$() {
        int h = this.handle;
        if (h != 0) {
            MalikSystem.syscall((long)h, 17);
            this.handle = 0;
        }
    }

    private void writeFile() throws InterruptedIOException {
        int required;
        DataDescriptor d = this.descriptor;
        int writed = (int)MalikSystem.syscall(this.handle, d.getDescriptorAddress(), 19);
        if (writed < (required = d.getLength())) {
            throw new InterruptedIOException("FileOutputStream.write: \u043f\u0440\u043e\u0446\u0435\u0441\u0441 \u0437\u0430\u043f\u0438\u0441\u0438 \u0432 \u0444\u0430\u0439\u043b " + this.fileName + " \u0431\u044b\u043b \u043f\u0440\u0435\u0440\u0432\u0430\u043d. \u0417\u0430\u043f\u0438\u0441\u0430\u043d\u043e \u0431\u0430\u0439\u0442: " + writed + " \u0438\u0437 " + required + ".", writed);
        }
    }
}

