/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.time;

import malik.emulator.time.LocaleTimeZone;

public final class ListOfTimeZones {
    private static final LocaleTimeZone[] LIST;
    private static final LocaleTimeZone UTC;
    private static final LocaleTimeZone CURRENT;

    static {
        LocaleTimeZone utc;
        String[] utcids = new String[]{"GMT"};
        LocaleTimeZone[] localeTimeZoneArray = new LocaleTimeZone[2];
        localeTimeZoneArray[1] = utc = new LocaleTimeZone(0, "UTC", null, utcids);
        LocaleTimeZone[] list = localeTimeZoneArray;
        int ofs = (int)MalikSystem.syscall(1L, 12);
        LocaleTimeZone cur = null;
        int i = list.length;
        while (i-- > 0) {
            LocaleTimeZone ltz = list[i];
            if (ltz == null || ltz.getRawOffset() != ofs) continue;
            cur = ltz;
            break;
        }
        LIST = list;
        UTC = utc;
        CURRENT = cur == null ? new LocaleTimeZone(ofs, ListOfTimeZones.buildID(ofs / 60000)) : utc;
    }

    public static int length() {
        return LIST.length;
    }

    public static LocaleTimeZone getTimeZone(int index) {
        return index >= 0 && index < LIST.length ? LIST[index] : null;
    }

    public static LocaleTimeZone getTimeZone(String id) {
        int i = LIST.length;
        while (i-- > 0) {
            LocaleTimeZone result = LIST[i];
            if (result == null || !result.isID(id)) continue;
            return result;
        }
        return UTC;
    }

    public static LocaleTimeZone getDefault() {
        return CURRENT;
    }

    private static String buildID(int offsetInMinutes) {
        StringBuffer result = new StringBuffer("UTC");
        if (offsetInMinutes != 0) {
            char c = offsetInMinutes < 0 ? (char)'-' : '+';
            offsetInMinutes = Math.abs(offsetInMinutes);
            result.append(c).append(offsetInMinutes / 60);
        }
        if (offsetInMinutes % 60 > 0) {
            result.append(':').append((char)(offsetInMinutes / 10 + 48)).append((char)(offsetInMinutes % 10 + 48));
        }
        return result.toString().intern();
    }

    private ListOfTimeZones() {
    }
}

