/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.util;

import malik.emulator.util.StringBuilder;

public final class StackTraceElement {
    private final int lineNumber;
    private final String className;
    private final String methodName;
    private final String sourceName;
    private final String representation;

    public StackTraceElement(String className, String methodName, String sourceName, int lineNumber) {
        StringBuilder representation = new StringBuilder().append(className).append('.').append(methodName).append('(').append(sourceName);
        if (lineNumber > 0) {
            representation.append(':').append(lineNumber);
        }
        this.lineNumber = lineNumber;
        this.className = className;
        this.methodName = methodName;
        this.sourceName = sourceName;
        this.representation = representation.append(')').toString();
    }

    public boolean equals(Object anot) {
        return anot == this || anot instanceof StackTraceElement && ((StackTraceElement)anot).representation.equals(this.representation);
    }

    public int hashCode() {
        return this.representation.hashCode();
    }

    public String toString() {
        return this.representation;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getSourceName() {
        return this.sourceName;
    }
}

