/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.compression.zlib;

import malik.emulator.compression.zlib.Checksum32;

public class CRC32
extends Checksum32 {
    private static final int[] TABLE;

    static {
        int[] table = new int[256];
        int i = 0;
        while (i < 256) {
            int c = i;
            int j = 8;
            while (j-- > 0) {
                int n = c = (c & 1) != 0 ? 0xEDB88320 ^ c >>> 1 : c >>> 1;
            }
            table[i] = c;
            ++i;
        }
        TABLE = table;
    }

    public CRC32() {
    }

    public CRC32(int value) {
        super(value);
    }

    public void update(byte[] buf, int offset, int length) {
        int c = ~this.value;
        while (length-- > 0) {
            c = TABLE[(c ^ buf[offset++]) & 0xFF] ^ c >>> 8;
        }
        this.value = ~c;
    }

    public Checksum32 copy() {
        return new CRC32(this.value);
    }
}

