/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.compression.zlib;

import java.io.UnsupportedEncodingException;
import malik.emulator.compression.zlib.Deflate;
import malik.emulator.compression.zlib.Zlib;

public class GZIPHeader
extends Zlib {
    private boolean fhcrc;
    private boolean text;
    private int mtime;
    int xflags;
    int os = 255;
    int hcrc;
    int time;
    int crc;
    byte[] extra;
    byte[] name;
    byte[] comment;

    public void setOS(int osIndex) {
        if ((osIndex < 0 || osIndex > 13) && osIndex != 255) {
            throw new IllegalArgumentException("os: " + osIndex);
        }
        this.os = osIndex;
    }

    public void setCRC(int crc) {
        this.crc = crc;
    }

    public void setModifiedTime(int mtime) {
        this.mtime = mtime;
    }

    public void setName(String name) {
        try {
            this.name = name.getBytes("ISO 8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("name must be in ISO 8859-1 ".concat(name));
        }
    }

    public void setComment(String comment) {
        try {
            this.comment = comment.getBytes("ISO 8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("comment must be in ISO 8859-1 ".concat(comment));
        }
    }

    public int getOS() {
        return this.os;
    }

    public int getCRC() {
        return this.crc;
    }

    public int getModifiedTime() {
        return this.mtime;
    }

    public String getName() {
        byte[] name = this.name;
        return name == null ? "" : new String(name);
    }

    public String getComment() {
        byte[] comment = this.comment;
        return comment == null ? "" : new String(comment);
    }

    public Object clone() {
        byte[] tmp;
        GZIPHeader gheader = new GZIPHeader();
        if (gheader.extra != null) {
            tmp = new byte[gheader.extra.length];
            Array.copy((byte[])gheader.extra, (int)0, (byte[])tmp, (int)0, (int)tmp.length);
            gheader.extra = tmp;
        }
        if (gheader.name != null) {
            tmp = new byte[gheader.name.length];
            Array.copy((byte[])gheader.name, (int)0, (byte[])tmp, (int)0, (int)tmp.length);
            gheader.name = tmp;
        }
        if (gheader.comment != null) {
            tmp = new byte[gheader.comment.length];
            Array.copy((byte[])gheader.comment, (int)0, (byte[])tmp, (int)0, (int)tmp.length);
            gheader.comment = tmp;
        }
        return gheader;
    }

    final void put(Deflate d) {
        int flag = 0;
        int xfl = 0;
        if (this.text) {
            flag |= 1;
        }
        if (this.fhcrc) {
            flag |= 2;
        }
        if (this.extra != null) {
            flag |= 4;
        }
        if (this.name != null) {
            flag |= 8;
        }
        if (this.comment != null) {
            flag |= 0x10;
        }
        switch (d.level) {
            case 1: {
                xfl |= 4;
                break;
            }
            case 9: {
                xfl |= 2;
            }
        }
        d.putShort(-29921);
        d.putByte((byte)8);
        d.putByte((byte)flag);
        d.putByte((byte)this.mtime);
        d.putByte((byte)(this.mtime >> 8));
        d.putByte((byte)(this.mtime >> 16));
        d.putByte((byte)(this.mtime >> 24));
        d.putByte((byte)xfl);
        d.putByte((byte)this.os);
        if (this.extra != null) {
            d.putByte((byte)this.extra.length);
            d.putByte((byte)(this.extra.length >> 8));
            d.putBytes(this.extra, 0, this.extra.length);
        }
        if (this.name != null) {
            d.putBytes(this.name, 0, this.name.length);
            d.putByte((byte)0);
        }
        if (this.comment != null) {
            d.putBytes(this.comment, 0, this.comment.length);
            d.putByte((byte)0);
        }
    }
}

