/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.fileformats.graphics.jpeg;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import malik.emulator.fileformats.InvalidDataFormatException;

final class JPEGBitInputStream {
    private int readedByte;
    private int lastBitIndex;
    private final InputStream stream;

    public JPEGBitInputStream(InputStream stream) {
        this.stream = stream;
    }

    public void reset() {
        this.lastBitIndex = 0;
    }

    public int readBit() throws IOException {
        int i = this.lastBitIndex;
        int r = this.readedByte;
        if (i > 0) {
            this.lastBitIndex = --i;
        } else {
            InputStream source = this.stream;
            i = 7;
            this.lastBitIndex = 7;
            this.readedByte = r = source.read();
            if (r < 0) {
                throw new EOFException("DataInputStream.readUnsignedByte: \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043a\u043e\u043d\u0435\u0446 \u043f\u043e\u0442\u043e\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445.");
            }
            if (r == 255) {
                int byte0 = source.read();
                if (byte0 < 0 || byte0 > 255) {
                    throw new EOFException("DataInputStream.readUnsignedByte: \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043a\u043e\u043d\u0435\u0446 \u043f\u043e\u0442\u043e\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445.");
                }
                switch (0xFF00 | byte0) {
                    case 65280: {
                        break;
                    }
                    case 65500: {
                        if (source.skip(4L) != 4L) {
                            throw new EOFException("DataInputStream.readUnsignedByte: \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043a\u043e\u043d\u0435\u0446 \u043f\u043e\u0442\u043e\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445.");
                        }
                        this.lastBitIndex = 0;
                        return 0;
                    }
                    default: {
                        throw new InvalidDataFormatException("JPEGDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
                    }
                }
            }
        }
        return r >> i & 1;
    }

    public int readBits(int quantity) throws IOException {
        int result = 0;
        while (quantity-- > 0) {
            result = result << 1 | this.readBit();
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public int readAndExtend(int quantity) throws IOException {
        void var2_2;
        int bits;
        return quantity <= 0 ? 0 : ((bits = this.readBits(quantity)) < 1 << quantity - 1 ? bits + (-1 << quantity) + 1 : var2_2);
    }

    public int refineAC(int ac, int shift) throws IOException {
        if (ac > 0) {
            if (this.readBit() != 0) {
                ac += 1 << shift;
            }
        } else if (ac < 0 && this.readBit() != 0) {
            ac += -1 << shift;
        }
        return ac;
    }
}

