/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.fileformats.graphics.jpeg;

import java.io.DataInputStream;
import java.io.IOException;
import malik.emulator.fileformats.ExtendedDataInputStream;
import malik.emulator.fileformats.InvalidDataFormatException;
import malik.emulator.fileformats.graphics.jpeg.Chunk;
import malik.emulator.fileformats.graphics.jpeg.JPEGDecoder;
import malik.emulator.fileformats.graphics.jpeg.TableSetChunk;

final class QuantizationTableSetChunk
extends TableSetChunk {
    private int count;
    private byte[] ids;
    private Object[] tables;

    public QuantizationTableSetChunk() {
        super(65499);
    }

    public void loadFromDataStream(ExtendedDataInputStream stream) throws IOException {
        int chunkLen = Chunk.readSize((DataInputStream)stream);
        if (chunkLen < 65) {
            throw new InvalidDataFormatException("JPEGDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
        }
        int dataCount = 0;
        byte[] dataIds = new byte[1];
        int[][] dataTables = new int[1][];
        byte[] order = JPEGDecoder.ORDER_ZIGZAG_INVERTED;
        do {
            int byte0 = stream.readUnsignedByte();
            int valueLen = byte0 >> 4;
            switch (valueLen) {
                case 0: {
                    if (chunkLen < 65) {
                        throw new InvalidDataFormatException("JPEGDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
                    }
                    chunkLen -= 65;
                    break;
                }
                case 1: {
                    if (chunkLen < 129) {
                        throw new InvalidDataFormatException("JPEGDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
                    }
                    chunkLen -= 129;
                    break;
                }
                default: {
                    throw new InvalidDataFormatException("JPEGDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
                }
            }
            int[] table = new int[64];
            int i = 0;
            while (i < 64) {
                table[order[i]] = valueLen == 1 ? stream.readUnsignedShort() : stream.readUnsignedByte();
                ++i;
            }
            if (dataIds.length == dataCount) {
                int newLen = (dataCount << 1) + 1;
                byte[] byArray = dataIds;
                dataIds = new byte[newLen];
                Array.copy((byte[])byArray, (int)0, (byte[])dataIds, (int)0, (int)dataCount);
                int[][] nArrayArray = dataTables;
                dataTables = new int[newLen][];
                Array.copy((Object[])nArrayArray, (int)0, (Object[])dataTables, (int)0, (int)dataCount);
            }
            dataTables[dataCount] = table;
            dataIds[dataCount] = (byte)(byte0 & 0xF);
            ++dataCount;
        } while (chunkLen > 0);
        this.count = dataCount;
        this.ids = dataIds;
        this.tables = (Object[])dataTables;
    }

    public int getTablesCount() {
        return this.count;
    }

    public int getTableId(int index) {
        return this.ids[index];
    }

    public Object getTable(int index) {
        return this.tables[index];
    }
}

