/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.fileformats.sound.sampled.wave;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import malik.emulator.fileformats.ExtendedDataInputStream;
import malik.emulator.fileformats.InvalidDataFormatException;
import malik.emulator.fileformats.UnsupportedDataException;
import malik.emulator.fileformats.sound.sampled.SampledSoundDecoder;
import malik.emulator.microedition.media.ControlList;
import malik.emulator.microedition.media.SampledPlayerDecoder;

public final class WaveDecoder
extends ControlList
implements SampledSoundDecoder,
SampledPlayerDecoder {
    public static final long SIGNATURE = 1380533830L;
    public static final String MIME_TYPE = "audio/x-wav";
    private static final int WAVE = 1463899717;
    private static final int FMT = 1718449184;
    private static final int DATA = 1684108385;
    private boolean stopped;
    private int channels;
    private int frequency;
    private short[] samples;

    public void loadFromInputStream(InputStream stream) throws IOException {
        this.loadFromDataStream(new ExtendedDataInputStream(stream));
    }

    public void loadFromDataStream(ExtendedDataInputStream stream) throws IOException {
        short[] soundSamples;
        int len;
        boolean dataHandled = false;
        boolean headerHandled = false;
        int align = 0;
        int bitDepth = 0;
        int soundChannels = 0;
        int soundFrequency = 0;
        byte[] soundData = null;
        this.checkStopped();
        long riffSize = (long)stream.readIntLE() & 0xFFFFFFFFL;
        if (riffSize < 4L || stream.readInt() != 1463899717) {
            throw new InvalidDataFormatException("WaveDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
        }
        riffSize -= 4L;
        while (riffSize > 0L) {
            this.checkStopped();
            if (riffSize < 8L) {
                throw new InvalidDataFormatException("WaveDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
            }
            int chunkName = stream.readInt();
            long chunkSize = (long)stream.readIntLE() & 0xFFFFFFFFL;
            if ((riffSize -= chunkSize + 8L) < 0L) {
                throw new InvalidDataFormatException("WaveDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
            }
            switch (chunkName) {
                default: {
                    stream.skip(chunkSize);
                    break;
                }
                case 1718449184: {
                    if (headerHandled || chunkSize < 16L) {
                        throw new InvalidDataFormatException("WaveDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
                    }
                    int cm = stream.readUnsignedShortLE();
                    int nc = stream.readUnsignedShortLE();
                    int ss = stream.readIntLE();
                    int bs = stream.readIntLE();
                    int ba = stream.readUnsignedShortLE();
                    int bd = stream.readUnsignedShortLE();
                    if (cm != 1 || nc < 1 || nc > 2 || ss <= 0 || ss > 65535 || bd != 8 && bd != 16) {
                        throw new UnsupportedDataException("WaveDecoder.loadFromInputStream: \u043d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.");
                    }
                    if (bs != ss * nc * bd >> 3 || ba != nc * bd >> 3) {
                        throw new InvalidDataFormatException("WaveDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
                    }
                    if ((chunkSize -= 16L) > 0L) {
                        stream.skip(chunkSize);
                    }
                    align = ba;
                    bitDepth = bd;
                    soundChannels = nc;
                    soundFrequency = ss;
                    headerHandled = true;
                    break;
                }
                case 1684108385: {
                    if (!headerHandled || dataHandled || chunkSize % (long)align != 0L) {
                        throw new InvalidDataFormatException("WaveDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
                    }
                    if (chunkSize > Integer.MAX_VALUE) {
                        throw new UnsupportedDataException("WaveDecoder.loadFromInputStream: \u043d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.");
                    }
                    soundData = new byte[(int)chunkSize];
                    stream.read(soundData);
                    dataHandled = true;
                }
            }
            if ((chunkSize & 1L) == 0L || riffSize <= 0L) continue;
            --riffSize;
            stream.skip(1L);
        }
        if (!dataHandled) {
            throw new InvalidDataFormatException("WaveDecoder.loadFromInputStream: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
        }
        if (bitDepth == 8) {
            len = soundData.length;
            soundSamples = new short[len];
            int i = len;
            while (i-- > 0) {
                int byte0 = soundData[i] ^ 0x80;
                if ((i & 0xF) == 0) {
                    this.checkStopped();
                }
                soundSamples[i] = (short)(byte0 << 8);
            }
        } else {
            len = soundData.length >> 1;
            soundSamples = new short[len];
            int pos = 0;
            int i = 0;
            while (i < len) {
                void byte0 = soundData[pos++];
                void byte1 = soundData[pos++];
                if ((i & 7) == 0) {
                    this.checkStopped();
                }
                soundSamples[i] = (short)(byte1 << 8 | byte0 & 0xFF);
                ++i;
            }
        }
        this.channels = soundChannels;
        this.frequency = soundFrequency;
        this.samples = soundSamples;
    }

    public void stopDecoding() {
        this.stopped = true;
    }

    public void clear() {
        this.stopped = false;
        this.channels = 0;
        this.frequency = 0;
        this.samples = null;
    }

    public boolean isEmpty() {
        return (this.channels | this.frequency) == 0 && this.samples == null;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getSamplesPerSecond() {
        return this.frequency;
    }

    public short[] getSamples() {
        short[] result = this.samples;
        if (this.samples == null) {
            return null;
        }
        short[] sArray = result;
        int len = result.length;
        result = new short[len];
        Array.copy((short[])sArray, (int)0, (short[])result, (int)0, (int)len);
        return result;
    }

    public String getContentType() {
        return MIME_TYPE;
    }

    private void checkStopped() throws InterruptedIOException {
        if (this.stopped) {
            this.stopped = false;
            throw new InterruptedIOException("WaveDecoder.loadFromInputStream: \u043f\u0440\u043e\u0446\u0435\u0441\u0441 \u0434\u0435\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0431\u044b\u043b \u043f\u0440\u0435\u0440\u0432\u0430\u043d.");
        }
    }
}

