/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.fileformats.sound.sampled.wave;

import java.io.IOException;
import java.io.OutputStream;
import malik.emulator.fileformats.EmptyAdapterException;
import malik.emulator.fileformats.ExtendedDataOutputStream;
import malik.emulator.fileformats.InvalidDataFormatException;
import malik.emulator.fileformats.UnsupportedDataException;
import malik.emulator.fileformats.sound.sampled.SampledSoundEncoder;

public final class WaveEncoder
implements SampledSoundEncoder {
    public static final long SIGNATURE = 1380533830L;
    private static final int WAVE = 1463899717;
    private static final int FMT = 1718449184;
    private static final int DATA = 1684108385;
    private int channels;
    private int frequency;
    private short[] samples;

    public void saveToOutputStream(OutputStream stream) throws IOException {
        this.saveToDataStream(new ExtendedDataOutputStream(stream));
    }

    public void saveToDataStream(ExtendedDataOutputStream stream) throws IOException {
        int soundChannels = this.channels;
        int soundFrequency = this.frequency;
        short[] soundSamples = this.samples;
        if (soundSamples == null) {
            throw new EmptyAdapterException("WaveEncoder.saveToOutputStream: \u043a\u043e\u0434\u0435\u0440 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0434\u0430\u043d\u043d\u044b\u0435.");
        }
        int len = soundSamples.length;
        byte[] soundData = new byte[len << 1];
        int pos = 0;
        int i = 0;
        while (i < len) {
            short sample = soundSamples[i];
            soundData[pos++] = (byte)sample;
            soundData[pos++] = (byte)(sample >> 8);
            ++i;
        }
        stream.writeInt(1380533830);
        stream.writeIntLE((len <<= 1) + 36);
        stream.writeInt(1463899717);
        stream.writeInt(1718449184);
        stream.writeIntLE(16);
        stream.writeShortLE(1);
        stream.writeShortLE(soundChannels);
        stream.writeIntLE(soundFrequency);
        stream.writeIntLE(soundFrequency * soundChannels << 1);
        stream.writeShortLE(soundChannels << 1);
        stream.writeShortLE(16);
        stream.writeInt(1684108385);
        stream.writeIntLE(len);
        stream.write(soundData);
    }

    public void clear() {
        this.channels = 0;
        this.frequency = 0;
        this.samples = null;
    }

    public void setSamples(int channels, int samplesPerSecond, short[] samples) throws InvalidDataFormatException, UnsupportedDataException {
        if (samples == null) {
            throw new NullPointerException("WaveEncoder.setSamples: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 samples \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (channels < 1 || channels > 2 || samplesPerSecond <= 0 || samplesPerSecond > 65535) {
            throw new UnsupportedDataException("WaveEncoder.setSamples: \u043d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.");
        }
        int len = samples.length;
        if (len % channels != 0) {
            throw new InvalidDataFormatException("WaveEncoder.setSamples: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445.");
        }
        short[] sArray = samples;
        samples = new short[len];
        Array.copy((short[])sArray, (int)0, (short[])samples, (int)0, (int)len);
        this.channels = channels;
        this.frequency = samplesPerSecond;
        this.samples = samples;
    }

    public boolean isEmpty() {
        return (this.channels | this.frequency) == 0 && this.samples == null;
    }
}

