/*
 * Decompiled with CFR 0.152.
 */
package javax.bluetooth;

import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.UUID;

public class DiscoveryAgent {
    public static final int NOT_DISCOVERABLE = 0;
    public static final int GIAC = 10390323;
    public static final int LIAC = 10390272;
    public static final int CACHED = 0;
    public static final int PREKNOWN = 1;
    private final RemoteDevice[] emptyRemoteDeviceList = new RemoteDevice[0];
    Thread inquiryOperation;
    Thread searchOperation;
    private final Object monitor = new Object();

    DiscoveryAgent() {
    }

    public boolean cancelInquiry(DiscoveryListener listener) {
        if (listener == null) {
            throw new NullPointerException("DiscoveryAgent.cancelInquiry: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 listener \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        return false;
    }

    public boolean cancelServiceSearch(int transactionID) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startInquiry(int accessCode, final DiscoveryListener listener) throws BluetoothStateException {
        Thread operation;
        if (accessCode < 10390272 || accessCode > 10390335) {
            throw new IllegalArgumentException("DiscoveryAgent.startInquiry: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 accessCode \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        if (listener == null) {
            throw new NullPointerException("DiscoveryAgent.startInquiry: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 listener \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            if (this.inquiryOperation != null) {
                error = true;
                operation = null;
            } else {
                this.inquiryOperation = operation = new Thread(){

                    public void run() {
                        try {
                            listener.inquiryCompleted(0);
                        }
                        finally {
                            DiscoveryAgent.this.inquiryOperation = null;
                        }
                    }
                };
            }
        }
        if (error) {
            throw new BluetoothStateException("DiscoveryAgent.startInquiry: \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0434\u0440\u0443\u0433\u0430\u044f \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f.");
        }
        operation.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int searchServices(int[] attrs, UUID[] uuids, RemoteDevice device, final DiscoveryListener listener) throws BluetoothStateException {
        Thread operation;
        int i;
        int[] attrsCopy;
        int attrsLen;
        if (attrs == null) {
            attrsLen = 0;
            attrsCopy = null;
        } else {
            attrsLen = attrs.length;
            if (attrsLen <= 0) {
                throw new IllegalArgumentException("DiscoveryAgent.searchServices: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 attrs \u0438\u043c\u0435\u0435\u0442 \u043d\u0443\u043b\u0435\u0432\u0443\u044e \u0434\u043b\u0438\u043d\u0443.");
            }
            attrsCopy = new int[attrsLen];
            Array.copy((int[])attrs, (int)0, (int[])attrsCopy, (int)0, (int)attrsLen);
            i = 0;
            while (i < attrsLen) {
                int attr = attrsCopy[i];
                if (attr < 0 || attr > 65535) {
                    throw new IllegalArgumentException("DiscoveryAgent.searchServices: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 attrs \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b.");
                }
                if (Array.findf((int[])attrsCopy, (int)(i + 1), (int)attr) < attrsLen) {
                    throw new IllegalArgumentException("DiscoveryAgent.searchServices: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 attrs \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043e\u0434\u0438\u043d\u0430\u043a\u043e\u0432\u044b\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b.");
                }
                ++i;
            }
        }
        if (uuids == null) {
            throw new NullPointerException("DiscoveryAgent.searchServices: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 uuids \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int uuidsLen = uuids.length;
        if (uuidsLen <= 0) {
            throw new IllegalArgumentException("DiscoveryAgent.searchServices: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 uuids \u0438\u043c\u0435\u0435\u0442 \u043d\u0443\u043b\u0435\u0432\u0443\u044e \u0434\u043b\u0438\u043d\u0443.");
        }
        Object[] uuidsCopy = new UUID[uuidsLen];
        Array.copy((Object[])uuids, (int)0, (Object[])uuidsCopy, (int)0, (int)uuidsLen);
        i = 0;
        while (i < uuidsLen) {
            Object uuid = uuidsCopy[i];
            if (uuid == null) {
                throw new NullPointerException("DiscoveryAgent.searchServices: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 uuids \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0443\u043b\u0435\u0432\u0443\u044e \u0441\u0441\u044b\u043b\u043a\u0443.");
            }
            if (Array.findf((Object[])uuidsCopy, (int)(i + 1), (Object)uuid) < uuidsLen) {
                throw new IllegalArgumentException("DiscoveryAgent.searchServices: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 uuids \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043e\u0434\u0438\u043d\u0430\u043a\u043e\u0432\u044b\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b.");
            }
            int j = i + 1;
            while (j < uuidsLen) {
                if (((UUID)uuid).realEquals((UUID)uuidsCopy[j])) {
                    throw new IllegalArgumentException("DiscoveryAgent.searchServices: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 uuids \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043e\u0434\u0438\u043d\u0430\u043a\u043e\u0432\u044b\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b.");
                }
                ++j;
            }
            ++i;
        }
        if (device == null) {
            throw new NullPointerException("DiscoveryAgent.searchServices: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 device \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (listener == null) {
            throw new NullPointerException("DiscoveryAgent.searchServices: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 listener \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            if (this.searchOperation != null) {
                error = true;
                operation = null;
            } else {
                this.searchOperation = operation = new Thread(){

                    public void run() {
                        try {
                            listener.serviceSearchCompleted(8653, 1);
                        }
                        finally {
                            DiscoveryAgent.this.searchOperation = null;
                        }
                    }
                };
            }
        }
        if (error) {
            throw new BluetoothStateException("DiscoveryAgent.searchServices: \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0434\u0440\u0443\u0433\u0430\u044f \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f.");
        }
        operation.start();
        return 8653;
    }

    public RemoteDevice[] retrieveDevices(int option) {
        if (option < 0 || option > 1) {
            throw new IllegalArgumentException("DiscoveryAgent.retrieveDevices: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 option \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        return this.emptyRemoteDeviceList;
    }

    public String selectService(UUID uuid, int security, boolean master) throws BluetoothStateException {
        if (uuid == null) {
            throw new NullPointerException("DiscoveryAgent.selectService: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 uuid \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (security < 0 || security > 2) {
            throw new IllegalArgumentException("DiscoveryAgent.selectService: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 security \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        return null;
    }
}

