/*
 * Decompiled with CFR 0.152.
 */
package javax.bluetooth;

import java.io.IOException;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;

public class RemoteDevice {
    private final String address;

    public static RemoteDevice getRemoteDevice(Connection connection) throws IOException {
        if (connection == null) {
            throw new NullPointerException("RemoteDevice.getRemoteDevice: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 connection \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        throw new IllegalArgumentException("RemoteDevice.getRemoteDevice: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 connection \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435\u043c \u0441 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e\u043c.");
    }

    protected RemoteDevice(String address) {
        if (address == null) {
            throw new NullPointerException("RemoteDevice: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 address \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (address.length() != 12) {
            throw new IllegalArgumentException("RemoteDevice: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 address \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        int i = 12;
        while (i-- > 0) {
            char digit = address.charAt(i);
            if (digit >= '0' && digit <= '9' || digit >= 'a' && digit <= 'f' || digit >= 'A' && digit <= 'F') continue;
            throw new IllegalArgumentException("RemoteDevice: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 address \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        this.address = address.toUpperCase();
    }

    public boolean equals(Object anot) {
        return anot instanceof RemoteDevice && ((RemoteDevice)anot).address.equals(this.address);
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public boolean authenticate() throws IOException {
        throw new ConnectionNotFoundException("RemoteDevice.authenticate: \u043d\u0435\u0442 \u043e\u0442\u043a\u0440\u044b\u0442\u044b\u0445 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0439 \u0441 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e\u043c.");
    }

    public boolean authorize(Connection connection) throws IOException {
        throw new IllegalArgumentException("RemoteDevice.authorize: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 connection \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435\u043c \u0441 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e\u043c.");
    }

    public boolean encrypt(Connection connection, boolean encrypted) throws IOException {
        throw new IllegalArgumentException("RemoteDevice.encrypt: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 connection \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435\u043c \u0441 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e\u043c.");
    }

    public boolean isTrustedDevice() {
        return false;
    }

    public boolean isAuthenticated() {
        return false;
    }

    public boolean isAuthorized(Connection connection) throws IOException {
        throw new IllegalArgumentException("RemoteDevice.isAuthorized: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 connection \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435\u043c \u0441 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e\u043c.");
    }

    public boolean isEncrypted() {
        return false;
    }

    public String getFriendlyName(boolean ask) throws IOException {
        throw new ConnectionNotFoundException("RemoteDevice.getFriendlyName: \u043d\u0435\u0442 \u0441\u0432\u044f\u0437\u0438 \u0441 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e\u043c.");
    }

    public final String getBluetoothAddress() {
        return this.address;
    }
}

