/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

public class DataInputStream
extends InputStream
implements DataInput {
    protected InputStream in;

    public static String readUTF(DataInput stream) throws IOException {
        int length;
        if (stream == null || (length = stream.readUnsignedShort()) == 0) {
            return "";
        }
        int strlen = 0;
        char[] result = new char[length];
        byte[] b = new byte[length];
        stream.readFully(b);
        int i = 0;
        while (i < length) {
            int byte1 = b[i] & 0xFF;
            switch (byte1 >> 4) {
                default: {
                    throw new UTFDataFormatException("DataInputStream.readUTF: \u043e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0434\u0430\u043d\u043d\u044b\u0445, \u0437\u0430\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u043e\u0439 UTF-8.");
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++i;
                    result[strlen++] = (char)byte1;
                    break;
                }
                case 12: 
                case 13: {
                    byte byte2;
                    if ((i += 2) > length || ((byte2 = b[i - 1]) & 0xC0) != 128) {
                        throw new UTFDataFormatException("DataInputStream.readUTF: \u043e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0434\u0430\u043d\u043d\u044b\u0445, \u0437\u0430\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u043e\u0439 UTF-8.");
                    }
                    result[strlen++] = (char)((byte1 & 0x1F) << 6 | byte2 & 0x3F);
                    break;
                }
                case 14: {
                    byte byte3;
                    byte byte2;
                    if ((i += 3) > length || ((byte2 = b[i - 2]) & 0xC0) != 128 || ((byte3 = b[i - 1]) & 0xC0) != 128) {
                        throw new UTFDataFormatException("DataInputStream.readUTF: \u043e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0434\u0430\u043d\u043d\u044b\u0445, \u0437\u0430\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u043e\u0439 UTF-8.");
                    }
                    result[strlen++] = (char)((byte1 & 0xF) << 12 | (byte2 & 0x3F) << 6 | byte3 & 0x3F);
                }
            }
        }
        return new String(result, 0, strlen);
    }

    public DataInputStream(InputStream stream) {
        this.in = stream;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public void reset() throws IOException {
        this.in.reset();
    }

    public void mark(int readLimit) {
        this.in.mark(readLimit);
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public long skip(long quantity) throws IOException {
        return this.in.skip(quantity);
    }

    public final int read(byte[] dst) throws IOException {
        return this.in.read(dst);
    }

    public final int read(byte[] dst, int offset, int length) throws IOException {
        return this.in.read(dst, offset, length);
    }

    public final void readFully(byte[] dst) throws IOException {
        if (dst == null) {
            throw new NullPointerException("DataInputStream.readFully: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        InputStream stream = this.in;
        int offset = 0;
        int length = dst.length;
        while (length > 0) {
            int readed = stream.read(dst, offset, length);
            if (readed <= 0) {
                throw new EOFException("DataInputStream.readFully: \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043a\u043e\u043d\u0435\u0446 \u043f\u043e\u0442\u043e\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445.");
            }
            offset += readed;
            length -= readed;
        }
    }

    public final void readFully(byte[] dst, int offset, int length) throws IOException {
        if (dst == null) {
            throw new NullPointerException("DataInputStream.readFully: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Array.checkBound("DataInputStream.readFully", dst.length, offset, length);
        InputStream stream = this.in;
        while (length > 0) {
            int readed = stream.read(dst, offset, length);
            if (readed <= 0) {
                throw new EOFException("DataInputStream.readFully: \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043a\u043e\u043d\u0435\u0446 \u043f\u043e\u0442\u043e\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445.");
            }
            offset += readed;
            length -= readed;
        }
    }

    public final boolean readBoolean() throws IOException {
        int byte0 = this.in.read();
        if (byte0 < 0) {
            throw new EOFException("DataInputStream.readBoolean: \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043a\u043e\u043d\u0435\u0446 \u043f\u043e\u0442\u043e\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445.");
        }
        return (byte0 & 0xFF) > 0;
    }

    public final char readChar() throws IOException {
        InputStream stream = this.in;
        int byte1 = stream.read();
        int byte0 = stream.read();
        if ((byte0 | byte1) < 0) {
            throw new EOFException("DataInputStream.readChar: \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043a\u043e\u043d\u0435\u0446 \u043f\u043e\u0442\u043e\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445.");
        }
        return (char)(byte1 << 8 | byte0 & 0xFF);
    }

    public final float readFloat() throws IOException {
        InputStream stream = this.in;
        int byte3 = stream.read();
        int byte2 = stream.read();
        int byte1 = stream.read();
        int byte0 = stream.read();
        if ((byte0 | byte1 | byte2 | byte3) < 0) {
            throw new EOFException("DataInputStream.readFloat: \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043a\u043e\u043d\u0435\u0446 \u043f\u043e\u0442\u043e\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445.");
        }
        return Float.intBitsToFloat((byte3 & 0xFF) << 24 | (byte2 & 0xFF) << 16 | (byte1 & 0xFF) << 8 | byte0 & 0xFF);
    }

    public final double readDouble() throws IOException {
        InputStream stream = this.in;
        int byte7 = stream.read();
        int byte6 = stream.read();
        int byte5 = stream.read();
        int byte4 = stream.read();
        int byte3 = stream.read();
        int byte2 = stream.read();
        int byte1 = stream.read();
        int byte0 = stream.read();
        if ((byte0 | byte1 | byte2 | byte3 | byte4 | byte5 | byte6 | byte7) < 0) {
            throw new EOFException("DataInputStream.readDouble: \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043a\u043e\u043d\u0435\u0446 \u043f\u043e\u0442\u043e\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445.");
        }
        return Double.longBitsToDouble((long)(byte7 & 0xFF) << 56 | (long)(byte6 & 0xFF) << 48 | (long)(byte5 & 0xFF) << 40 | (long)(byte4 & 0xFF) << 32 | (long)(byte3 & 0xFF) << 24 | (long)(byte2 & 0xFF) << 16 | (long)(byte1 & 0xFF) << 8 | (long)(byte0 & 0xFF));
    }

    public final byte readByte() throws IOException {
        int byte0 = this.in.read();
        if (byte0 < 0) {
            throw new EOFException("DataInputStream.readByte: \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043a\u043e\u043d\u0435\u0446 \u043f\u043e\u0442\u043e\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445.");
        }
        return (byte)byte0;
    }

    public final short readShort() throws IOException {
        InputStream stream = this.in;
        int byte1 = stream.read();
        int byte0 = stream.read();
        if ((byte0 | byte1) < 0) {
            throw new EOFException("DataInputStream.readShort: \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043a\u043e\u043d\u0435\u0446 \u043f\u043e\u0442\u043e\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445.");
        }
        return (short)(byte1 << 8 | byte0 & 0xFF);
    }

    public final int skipBytes(int quantity) throws IOException {
        int skiped;
        InputStream stream = this.in;
        int result = 0;
        while (quantity > 0 && (skiped = (int)stream.skip(quantity)) > 0) {
            quantity -= skiped;
            result += skiped;
        }
        return result;
    }

    public final int readUnsignedByte() throws IOException {
        int byte0 = this.in.read();
        if (byte0 < 0) {
            throw new EOFException("DataInputStream.readUnsignedByte: \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043a\u043e\u043d\u0435\u0446 \u043f\u043e\u0442\u043e\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445.");
        }
        return byte0 & 0xFF;
    }

    public final int readUnsignedShort() throws IOException {
        InputStream stream = this.in;
        int byte1 = stream.read();
        int byte0 = stream.read();
        if ((byte0 | byte1) < 0) {
            throw new EOFException("DataInputStream.readUnsignedShort: \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043a\u043e\u043d\u0435\u0446 \u043f\u043e\u0442\u043e\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445.");
        }
        return (byte1 & 0xFF) << 8 | byte0 & 0xFF;
    }

    public final int readInt() throws IOException {
        InputStream stream = this.in;
        int byte3 = stream.read();
        int byte2 = stream.read();
        int byte1 = stream.read();
        int byte0 = stream.read();
        if ((byte0 | byte1 | byte2 | byte3) < 0) {
            throw new EOFException("DataInputStream.readInt: \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043a\u043e\u043d\u0435\u0446 \u043f\u043e\u0442\u043e\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445.");
        }
        return (byte3 & 0xFF) << 24 | (byte2 & 0xFF) << 16 | (byte1 & 0xFF) << 8 | byte0 & 0xFF;
    }

    public final long readLong() throws IOException {
        InputStream stream = this.in;
        int byte7 = stream.read();
        int byte6 = stream.read();
        int byte5 = stream.read();
        int byte4 = stream.read();
        int byte3 = stream.read();
        int byte2 = stream.read();
        int byte1 = stream.read();
        int byte0 = stream.read();
        if ((byte0 | byte1 | byte2 | byte3 | byte4 | byte5 | byte6 | byte7) < 0) {
            throw new EOFException("DataInputStream.readLong: \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442 \u043a\u043e\u043d\u0435\u0446 \u043f\u043e\u0442\u043e\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445.");
        }
        return (long)(byte7 & 0xFF) << 56 | (long)(byte6 & 0xFF) << 48 | (long)(byte5 & 0xFF) << 40 | (long)(byte4 & 0xFF) << 32 | (long)(byte3 & 0xFF) << 24 | (long)(byte2 & 0xFF) << 16 | (long)(byte1 & 0xFF) << 8 | (long)(byte0 & 0xFF);
    }

    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }
}

