/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.i18n;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import malik.emulator.i18n.StreamReader;
import malik.emulator.i18n.StreamWriter;
import malik.emulator.i18n.TextCodec;
import malik.emulator.i18n.encoding.system.UTF_8_Codec;
import malik.emulator.i18n.encoding.system.UTF_8_Reader;
import malik.emulator.i18n.encoding.system.UTF_8_Writer;
import malik.emulator.util.StringBuilder;

public final class Helper {
    private static final String ENCODING_INTERNAL_NAME_UTF_8 = "system.UTF_8";
    private static final String ENCODING_INTERNAL_NAME_ISO8859_1 = "ISO8859_1";
    private static TextCodec SYSTEM_TEXT_CODEC;

    public static char[] byteToCharArray(byte[] src, int offset, int length) {
        return Helper.getSystemTextCodecInstance().decode(src, offset, length);
    }

    public static char[] byteToCharArray(byte[] src, int offset, int length, String encoding) throws UnsupportedEncodingException {
        return Helper.createTextCodec(encoding).decode(src, offset, length);
    }

    public static byte[] charToByteArray(char[] src, int offset, int length) {
        return Helper.getSystemTextCodecInstance().encode(src, offset, length);
    }

    public static byte[] charToByteArray(char[] src, int offset, int length, String encoding) throws UnsupportedEncodingException {
        return Helper.createTextCodec(encoding).encode(src, offset, length);
    }

    public static TextCodec createTextCodec() {
        return new UTF_8_Codec();
    }

    public static TextCodec createTextCodec(String encoding) throws UnsupportedEncodingException {
        TextCodec result;
        String className = new StringBuilder().append("malik.emulator.i18n.encoding.").append(Helper.getInternalEncodingName(encoding)).append("_Codec").toString();
        try {
            result = (TextCodec)Class.forName(className).newInstance();
        }
        catch (Exception exception) {
            throw new UnsupportedEncodingException(new StringBuilder().append("\u041a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0430 ").append(encoding).append(" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u043e\u0439.").toString());
        }
        return result;
    }

    public static Reader createReader(InputStream stream) {
        return new UTF_8_Reader().setInputStream(stream);
    }

    public static Reader createReader(InputStream stream, String encoding) throws UnsupportedEncodingException {
        return Helper.createStreamReader(encoding).setInputStream(stream);
    }

    public static Writer createWriter(OutputStream stream) {
        return new UTF_8_Writer().setOutputStream(stream);
    }

    public static Writer createWriter(OutputStream stream, String encoding) throws UnsupportedEncodingException {
        return Helper.createStreamWriter(encoding).setOutputStream(stream);
    }

    private static char normalizeEncodingCharacter(char character) {
        return character <= '/' || character >= ':' && character <= '@' || character >= '[' && character <= '`' || character >= '{' ? (char)'_' : Character.toUpperCase(character);
    }

    private static String normalizeEncodingName(String encoding) {
        char character;
        int length;
        int n;
        if (encoding == null) {
            n = 0;
        } else {
            encoding = encoding.trim();
            n = length = encoding.length();
        }
        if (n <= 0) {
            encoding = "UTF_8";
            length = "UTF_8".length();
        }
        int i = 0;
        while (i < length && (character = encoding.charAt(i)) == Helper.normalizeEncodingCharacter(character)) {
            ++i;
        }
        if (i >= length) {
            return encoding;
        }
        char[] buf = encoding.toCharArray();
        while (i < length) {
            buf[i] = Helper.normalizeEncodingCharacter(buf[i]);
            ++i;
        }
        return new String(buf);
    }

    private static StreamReader createStreamReader(String encoding) throws UnsupportedEncodingException {
        StreamReader result;
        String className = new StringBuilder().append("malik.emulator.i18n.encoding.").append(Helper.getInternalEncodingName(encoding)).append("_Reader").toString();
        try {
            result = (StreamReader)Class.forName(className).newInstance();
        }
        catch (Exception exception) {
            throw new UnsupportedEncodingException(new StringBuilder().append("\u041a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0430 ").append(encoding).append(" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u043e\u0439.").toString());
        }
        return result;
    }

    private static StreamWriter createStreamWriter(String encoding) throws UnsupportedEncodingException {
        StreamWriter result;
        String className = new StringBuilder().append("malik.emulator.i18n.encoding.").append(Helper.getInternalEncodingName(encoding)).append("_Writer").toString();
        try {
            result = (StreamWriter)Class.forName(className).newInstance();
        }
        catch (Exception exception) {
            throw new UnsupportedEncodingException(new StringBuilder().append("\u041a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0430 ").append(encoding).append(" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u043e\u0439.").toString());
        }
        return result;
    }

    private static String getInternalEncodingName(String encoding) {
        String result = Helper.normalizeEncodingName(encoding);
        if ("ASCII".equals(result) || "US_ASCII".equals(result) || "ISO_8859_1".equals(result) || "CP_1252".equals(result) || "CP1252".equals(result) || "WINDOWS_1252".equals(result) || "WINDOWS1252".equals(result)) {
            return ENCODING_INTERNAL_NAME_ISO8859_1;
        }
        if ("UTF8".equals(result) || "UTF_8".equals(result)) {
            return ENCODING_INTERNAL_NAME_UTF_8;
        }
        if (result.startsWith("CP_")) {
            return "CP".concat(result.substring(3));
        }
        if (result.startsWith("WINDOWS")) {
            return "CP".concat(result.substring(7));
        }
        if (result.startsWith("WINDOWS_")) {
            return "CP".concat(result.substring(8));
        }
        if (result.startsWith("ISO_8859_")) {
            return "ISO8859_".concat(result.substring(9));
        }
        String value = System.getSystemProperty(result.concat("_InternalEncodingName"));
        return value != null ? value : result;
    }

    private static TextCodec getSystemTextCodecInstance() {
        return SYSTEM_TEXT_CODEC == null ? (SYSTEM_TEXT_CODEC = new UTF_8_Codec()) : SYSTEM_TEXT_CODEC;
    }

    private Helper() {
    }
}

