/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.io.cloud;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import malik.emulator.io.IOStream;
import malik.emulator.io.cloud.AttributesDescriptor;
import malik.emulator.io.cloud.CloudFileEnumeration;
import malik.emulator.io.cloud.FileIOStream;
import malik.emulator.io.cloud.FileInfoDescriptor;
import malik.emulator.io.cloud.FileInputStream;
import malik.emulator.io.cloud.FileOutputStream;
import malik.emulator.io.vfs.DirectoryCreationException;
import malik.emulator.io.vfs.DirectoryDeletionException;
import malik.emulator.io.vfs.DirectoryNotFoundException;
import malik.emulator.io.vfs.FileAttributes;
import malik.emulator.io.vfs.FileCreationException;
import malik.emulator.io.vfs.FileDeletionException;
import malik.emulator.io.vfs.FileEnumeration;
import malik.emulator.io.vfs.FileNotFoundException;
import malik.emulator.io.vfs.MoveOperationException;
import malik.emulator.io.vfs.ObjectNotFoundException;
import malik.emulator.io.vfs.VirtualFileSystemReadOnly;
import malik.emulator.io.vfs.VirtualFileSystemReadWrite;
import malik.emulator.time.CalendarSystem;
import malik.emulator.util.StringBuilder;

public final class CloudFileSystem
implements VirtualFileSystemReadOnly,
VirtualFileSystemReadWrite {
    public static final CloudFileSystem instance = new CloudFileSystem();

    static long computeFields(long time) {
        return CalendarSystem.gregorian.computeFields(time, 0);
    }

    static long computeTime(long fields) {
        return CalendarSystem.gregorian.computeTime(fields, 0);
    }

    private CloudFileSystem() {
    }

    public String toString() {
        return "\u0424\u0430\u0439\u043b\u043e\u0432\u0430\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f";
    }

    public void readAttributes(String objectName, FileAttributes objectAttr) throws IOException {
        if (objectName == null) {
            throw new NullPointerException("CloudFileSystem.readAttributes: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 objectName \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        AttributesDescriptor d = new AttributesDescriptor();
        int len = objectName.length();
        char[] name = new char[len + 1];
        objectName.getChars(0, len, name, 0);
        if (MalikSystem.syscall(Array.getFirstElementAddress(name), d.getDescriptorAddress(), 28) == 0L) {
            throw new ObjectNotFoundException(new StringBuilder().append("CloudFileSystem.readAttributes: \u043e\u0431\u044a\u0435\u043a\u0442 ").append(objectName).append(" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.").toString(), objectName);
        }
        if (objectAttr != null) {
            objectAttr.setAttributes(d.attributes, CloudFileSystem.computeTime(d.timeOfCreation), CloudFileSystem.computeTime(d.timeOfLastWrite), CloudFileSystem.computeTime(d.timeOfLastAccess));
        }
    }

    public int getObjectNameMaximumLength() throws IOException {
        return (int)MalikSystem.syscall(0L, 22);
    }

    public FileEnumeration findFirst() throws IOException {
        char[] cArray = new char[2];
        cArray[0] = 47;
        char[] directory = cArray;
        int len = this.getObjectNameMaximumLength() + 1;
        char[] name = new char[len];
        FileInfoDescriptor d = new FileInfoDescriptor(len, Array.getFirstElementAddress(name));
        int h = (int)MalikSystem.syscall(Array.getFirstElementAddress(directory), d.getDescriptorAddress(), 24);
        return h > 0 ? new CloudFileEnumeration(h, name, d) : null;
    }

    public FileEnumeration findFirst(String objectName) throws IOException {
        char[] directory;
        if (objectName == null) {
            throw new NullPointerException("CloudFileSystem.findFirst: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 objectName \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int len = this.getObjectNameMaximumLength() + 1;
        char[] name = new char[len];
        FileInfoDescriptor d = new FileInfoDescriptor(len, Array.getFirstElementAddress(name));
        if (!objectName.startsWith("/")) {
            objectName = "/".concat(objectName);
        }
        len = objectName.length();
        int lim = len - 1;
        if (len > 0 && objectName.charAt(lim) != '/') {
            char[] directory2 = new char[len + 1];
            objectName.getChars(0, len, directory2, 0);
            int h = (int)MalikSystem.syscall(Array.getFirstElementAddress(directory2), d.getDescriptorAddress(), 24);
            return h > 0 ? new CloudFileEnumeration(h, name, d) : null;
        }
        if (len > 1) {
            directory = new char[len];
            objectName.getChars(0, lim, directory, 0);
            if (MalikSystem.syscall(Array.getFirstElementAddress(directory), d.getDescriptorAddress(), 28) == 0L || (d.attributes & 0x10) == 0) {
                throw new DirectoryNotFoundException(new StringBuilder().append("CloudFileSystem.findFirst: \u043f\u0430\u043f\u043a\u0430 ").append(objectName).append(" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430.").toString(), objectName);
            }
        }
        directory = new char[len + 1];
        objectName.getChars(0, len, directory, 0);
        int h = (int)MalikSystem.syscall(Array.getFirstElementAddress(directory), d.getDescriptorAddress(), 24);
        return h > 0 ? new CloudFileEnumeration(h, name, d) : null;
    }

    public InputStream openFileForRead(String fileName) throws IOException {
        if (fileName == null) {
            throw new NullPointerException("CloudFileSystem.openFileForRead: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 fileName \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int len = fileName.length();
        if (len <= 0) {
            throw new IllegalArgumentException("CloudFileSystem.openFileForRead: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 fileName \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043f\u0443\u0441\u0442\u043e\u0439 \u0441\u0442\u0440\u043e\u043a\u043e\u0439.");
        }
        char[] name = new char[len + 1];
        fileName.getChars(0, len, name, 0);
        int h = (int)MalikSystem.syscall(Array.getFirstElementAddress(name), 1, 16);
        if (h == 0) {
            throw new FileNotFoundException(new StringBuilder().append("CloudFileSystem.openFileForRead: \u0444\u0430\u0439\u043b ").append(fileName).append(" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438\u043b\u0438 \u0437\u0430\u043d\u044f\u0442.").toString(), fileName);
        }
        return new FileInputStream(fileName, h);
    }

    public void writeAttributes(String objectName, FileAttributes objectAttr) throws IOException {
        if (objectName == null) {
            throw new NullPointerException("CloudFileSystem.writeAttributes: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 objectName \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (objectAttr == null) {
            throw new NullPointerException("CloudFileSystem.writeAttributes: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 objectAttr \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int len = objectName.length();
        char[] name = new char[len + 1];
        objectName.getChars(0, len, name, 0);
        AttributesDescriptor d = new AttributesDescriptor();
        new AttributesDescriptor().attributes = objectAttr.getAttributes() & 0xFFFFFFEF;
        d.timeOfCreation = CloudFileSystem.computeFields(objectAttr.getCreationTime());
        d.timeOfLastWrite = CloudFileSystem.computeFields(objectAttr.getLastWriteTime());
        d.timeOfLastAccess = CloudFileSystem.computeFields(objectAttr.getLastAccessTime());
        if (MalikSystem.syscall(Array.getFirstElementAddress(name), d.getDescriptorAddress(), 29) == 0L) {
            throw new ObjectNotFoundException(new StringBuilder().append("CloudFileSystem.writeAttributes: \u043e\u0431\u044a\u0435\u043a\u0442 ").append(objectName).append(" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.").toString(), objectName);
        }
    }

    public void move(String oldObjectName, String newObjectName) throws IOException {
        if (oldObjectName == null) {
            throw new NullPointerException("CloudFileSystem.move: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 oldObjectName \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (newObjectName == null) {
            throw new NullPointerException("CloudFileSystem.move: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 newObjectName \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int len = oldObjectName.length();
        char[] oldName = new char[len + 1];
        oldObjectName.getChars(0, len, oldName, 0);
        len = newObjectName.length();
        char[] newName = new char[len + 1];
        newObjectName.getChars(0, len, newName, 0);
        if (MalikSystem.syscall(Array.getFirstElementAddress(oldName), Array.getFirstElementAddress(newName), 27) == 0L) {
            throw new MoveOperationException("CloudFileSystem.move: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043f\u0435\u0440\u0435\u043c\u0435\u0449\u0435\u043d\u0438\u0435 \u0438/\u0438\u043b\u0438 \u043f\u0435\u0440\u0435\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430.", oldObjectName, newObjectName);
        }
    }

    public void deleteDirectory(String directoryName) throws IOException {
        if (directoryName == null) {
            throw new NullPointerException("CloudFileSystem.deleteDirectory: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 directoryName \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        AttributesDescriptor d = new AttributesDescriptor();
        int len = directoryName.length();
        char[] name = new char[len + 1];
        directoryName.getChars(0, len, name, 0);
        if (MalikSystem.syscall(Array.getFirstElementAddress(name), d.getDescriptorAddress(), 28) == 0L || (d.attributes & 0x10) == 0) {
            throw new DirectoryNotFoundException(new StringBuilder().append("CloudFileSystem.deleteDirectory: \u043f\u0430\u043f\u043a\u0430 ").append(directoryName).append(" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430.").toString(), directoryName);
        }
        if (MalikSystem.syscall((long)Array.getFirstElementAddress(name), 31) == 0L) {
            throw new DirectoryDeletionException(new StringBuilder().append("CloudFileSystem.deleteDirectory: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0430\u043f\u043a\u0443 ").append(directoryName).append('.').toString(), directoryName);
        }
    }

    public void deleteFile(String fileName) throws IOException {
        if (fileName == null) {
            throw new NullPointerException("CloudFileSystem.deleteFile: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 fileName \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        AttributesDescriptor d = new AttributesDescriptor();
        int len = fileName.length();
        char[] name = new char[len + 1];
        fileName.getChars(0, len, name, 0);
        if (MalikSystem.syscall(Array.getFirstElementAddress(name), d.getDescriptorAddress(), 28) == 0L || (d.attributes & 0x10) != 0) {
            throw new FileNotFoundException(new StringBuilder().append("CloudFileSystem.deleteFile: \u0444\u0430\u0439\u043b ").append(fileName).append(" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.").toString(), fileName);
        }
        if (MalikSystem.syscall((long)Array.getFirstElementAddress(name), 23) == 0L) {
            throw new FileDeletionException(new StringBuilder().append("CloudFileSystem.deleteFile: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0444\u0430\u0439\u043b ").append(fileName).append('.').toString(), fileName);
        }
    }

    public void createDirectory(String directoryName) throws IOException {
        if (directoryName == null) {
            throw new NullPointerException("CloudFileSystem.createDirectory: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 directoryName \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int len = directoryName.length();
        char[] name = new char[len + 1];
        directoryName.getChars(0, len, name, 0);
        if (MalikSystem.syscall((long)Array.getFirstElementAddress(name), 30) == 0L) {
            throw new DirectoryCreationException(new StringBuilder().append("CloudFileSystem.createDirectory: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043f\u0430\u043f\u043a\u0443 ").append(directoryName).append('.').toString(), directoryName);
        }
    }

    public OutputStream createFile(String fileName) throws IOException {
        if (fileName == null) {
            throw new NullPointerException("CloudFileSystem.createFile: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 fileName \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int len = fileName.length();
        if (len <= 0) {
            throw new IllegalArgumentException("CloudFileSystem.createFile: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 fileName \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043f\u0443\u0441\u0442\u043e\u0439 \u0441\u0442\u0440\u043e\u043a\u043e\u0439.");
        }
        char[] name = new char[len + 1];
        fileName.getChars(0, len, name, 0);
        int h = (int)MalikSystem.syscall(Array.getFirstElementAddress(name), 2, 16);
        if (h == 0) {
            throw new FileCreationException(new StringBuilder().append("CloudFileSystem.createFile: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0444\u0430\u0439\u043b ").append(fileName).append('.').toString(), fileName);
        }
        return new FileOutputStream(fileName, h);
    }

    public OutputStream openFileForAppend(String fileName) throws IOException {
        if (fileName == null) {
            throw new NullPointerException("CloudFileSystem.openFileForAppending: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 fileName \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int len = fileName.length();
        if (len <= 0) {
            throw new IllegalArgumentException("CloudFileSystem.openFileForAppending: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 fileName \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043f\u0443\u0441\u0442\u043e\u0439 \u0441\u0442\u0440\u043e\u043a\u043e\u0439.");
        }
        char[] name = new char[len + 1];
        fileName.getChars(0, len, name, 0);
        int h = (int)MalikSystem.syscall(Array.getFirstElementAddress(name), 0, 16);
        if (h == 0) {
            throw new FileNotFoundException(new StringBuilder().append("CloudFileSystem.openFileForAppending: \u0444\u0430\u0439\u043b ").append(fileName).append(" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438\u043b\u0438 \u0437\u0430\u043d\u044f\u0442.").toString(), fileName);
        }
        return new FileOutputStream(fileName, h);
    }

    public IOStream openFileForReadWrite(String fileName) throws IOException {
        if (fileName == null) {
            throw new NullPointerException("CloudFileSystem.openFileForReadWrite: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 fileName \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int len = fileName.length();
        if (len <= 0) {
            throw new IllegalArgumentException("CloudFileSystem.openFileForReadWrite: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 fileName \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043f\u0443\u0441\u0442\u043e\u0439 \u0441\u0442\u0440\u043e\u043a\u043e\u0439.");
        }
        char[] name = new char[len + 1];
        fileName.getChars(0, len, name, 0);
        int h = (int)MalikSystem.syscall(Array.getFirstElementAddress(name), 3, 16);
        if (h == 0) {
            throw new FileNotFoundException(new StringBuilder().append("CloudFileSystem.openFileForReadWrite: \u0444\u0430\u0439\u043b ").append(fileName).append(" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438\u043b\u0438 \u0437\u0430\u043d\u044f\u0442.").toString(), fileName);
        }
        return new FileIOStream(fileName, h);
    }
}

