/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.time;

import malik.emulator.time.GregorianCalendarSystem;
import malik.emulator.time.JulianCalendarSystem;

public abstract class CalendarSystem {
    public static final int MONDAY = 1;
    public static final int TUESDAY = 2;
    public static final int WEDNESDAY = 3;
    public static final int THURSDAY = 4;
    public static final int FRIDAY = 5;
    public static final int SATURDAY = 6;
    public static final int SUNDAY = 0;
    public static final int JANUARY = 1;
    public static final int FEBRUARY = 2;
    public static final int MARCH = 3;
    public static final int APRIL = 4;
    public static final int MAY = 5;
    public static final int JUNE = 6;
    public static final int JULY = 7;
    public static final int AUGUST = 8;
    public static final int SEPTEMBER = 9;
    public static final int OCTOBER = 10;
    public static final int NOVEMBER = 11;
    public static final int DECEMBER = 12;
    static final byte[][] DAYS = new byte[][]{{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}, {31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}};
    public static final CalendarSystem gregorian = new GregorianCalendarSystem();
    public static final CalendarSystem julian = new JulianCalendarSystem();

    protected CalendarSystem() {
    }

    public abstract boolean isLeapYear(int var1);

    public abstract int computeNumberOfDays(int var1, int var2);

    public abstract int computeDayOfWeek(int var1, int var2, int var3);

    public abstract long computeFields(long var1, int var3);

    public abstract long computeTime(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public abstract long epochStart();

    public int getYear(long fields) {
        return (int)(fields >>> 48);
    }

    public int getMonth(long fields) {
        return (int)(fields >>> 40) & 0xFF;
    }

    public int getDay(long fields) {
        return (int)(fields >>> 32) & 0xFF;
    }

    public int getHour(long fields) {
        return (int)(fields >>> 24) & 0xFF;
    }

    public int getMinute(long fields) {
        return (int)(fields >>> 16) & 0xFF;
    }

    public int getSecond(long fields) {
        return ((int)fields & 0xFFFF) / 1000;
    }

    public int getMillis(long fields) {
        return ((int)fields & 0xFFFF) % 1000;
    }

    public long toFields(int year, int month, int day, int hour, int minute, int second, int millis) {
        return (long)year << 48 | (long)(month & 0xFF) << 40 | (long)(day & 0xFF) << 32 | (long)(hour & 0xFF) << 24 | (long)(minute & 0xFF) << 16 | (long)(second * 1000 + millis & 0xFFFF);
    }

    public long computeTime(long fields, int offset) {
        int millis = (int)fields & 0xFFFF;
        return this.computeTime((int)(fields >>> 48), (int)(fields >> 40) & 0xFF, (int)(fields >> 32) & 0xFF, (int)(fields >> 24) & 0xFF, (int)(fields >> 16) & 0xFF, millis / 1000, millis % 1000, offset);
    }

    public long setYear(long fields, int year) {
        return fields & 0xFFFFFFFFFFFFL | (long)year << 48;
    }

    public long setMonth(long fields, int month) {
        return fields & 0xFFFF00FFFFFFFFFFL | (long)(month & 0xFF) << 40;
    }

    public long setDay(long fields, int day) {
        return fields & 0xFFFFFF00FFFFFFFFL | (long)(day & 0xFF) << 32;
    }

    public long setHour(long fields, int hour) {
        return fields & 0xFFFFFFFF00FFFFFFL | (long)(hour & 0xFF) << 24;
    }

    public long setMinute(long fields, int minute) {
        return fields & 0xFFFFFFFFFF00FFFFL | (long)(minute & 0xFF) << 16;
    }

    public long setSecond(long fields, int second) {
        int millis = ((int)fields & 0xFFFF) % 1000;
        return fields & 0xFFFFFFFFFFFF0000L | (long)(second * 1000 + millis & 0xFFFF);
    }

    public long setMillis(long fields, int millis) {
        int second = ((int)fields & 0xFFFF) / 1000;
        return fields & 0xFFFFFFFFFFFF0000L | (long)(second * 1000 + millis & 0xFFFF);
    }
}

