/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.FocusItem;
import javax.microedition.lcdui.Graphics;
import malik.emulator.application.KeyboardEvent;
import malik.emulator.application.PointerEvent;

public abstract class AppearanceModeItem
extends FocusItem {
    boolean pressed;
    int contentWidth;
    int contentHeight;
    final int appearanceMode;

    AppearanceModeItem(String label, int appearanceMode) {
        this(label, 0, appearanceMode);
    }

    AppearanceModeItem(String label, int layout, int appearanceMode) {
        super(label, layout);
        if (appearanceMode < 0 || appearanceMode > 2) {
            throw new IllegalArgumentException("AppearanceModeItem: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 appearanceMode \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        this.appearanceMode = appearanceMode;
    }

    public int getAppearanceMode() {
        return this.appearanceMode;
    }

    abstract void paint(Graphics var1, int var2, int var3);

    abstract int getMinimumContentWidth();

    abstract int getMinimumContentHeight();

    void onSizeChanged(int contentWidth, int contentHeight) {
        this.contentWidth = contentWidth;
        this.contentHeight = contentHeight;
    }

    void onKeyboardEvent(KeyboardEvent event) {
        if (this.appearanceMode != 0 && event.getKey() == 32) {
            switch (event.getAction()) {
                case 6: {
                    this.pressed = true;
                    this.requestPaint();
                    break;
                }
                case 7: {
                    if (!this.pressed) break;
                    this.pressed = false;
                    this.requestPaint();
                    this.requestDefaultCommandAction();
                }
            }
        }
    }

    void onPointerEvent(PointerEvent event) {
        if (this.appearanceMode != 0) {
            if (event.getAction() != 11) {
                int x = event.getX();
                int y = event.getY();
                this.pressed = x >= 0 && x < this.contentWidth && y >= 0 && y < this.contentHeight;
                if (this.pressed != this.pressed) {
                    this.requestPaint();
                }
            } else if (this.pressed) {
                this.pressed = false;
                this.requestPaint();
                this.requestDefaultCommandAction();
            }
        }
    }
}

