/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.io.PrintStream;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.ScreenGraphics;
import javax.microedition.lcdui.SurfaceScreen;
import javax.microedition.lcdui.VisibleElement;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletDispatcher;
import javax.microedition.rms.RecordStore;
import malik.emulator.application.InputDevice;
import malik.emulator.application.KeyboardEvent;
import malik.emulator.application.PointerEvent;
import malik.emulator.application.Requestable;
import malik.emulator.application.RequestableQueue;
import malik.emulator.application.Run;
import malik.emulator.media.graphics.Clip;
import malik.emulator.media.graphics.RasterBuffer;
import malik.emulator.media.graphics.RasterCanvas;
import malik.emulator.media.graphics.Rectangle;
import malik.emulator.microedition.DeviceManager;

public class Display
extends VisibleElement
implements Rectangle {
    public static final int LIST_ELEMENT = 1;
    public static final int CHOICE_GROUP_ELEMENT = 2;
    public static final int ALERT = 3;
    public static final int COLOR_BACKGROUND = 0;
    public static final int COLOR_FOREGROUND = 1;
    public static final int COLOR_HIGHLIGHTED_BACKGROUND = 2;
    public static final int COLOR_HIGHLIGHTED_FOREGROUND = 3;
    public static final int COLOR_BORDER = 4;
    public static final int COLOR_HIGHLIGHTED_BORDER = 5;
    private static long lastUpdated;
    private static ApplicationThread[] appThreads;
    private static final Clip screenClip;
    private static final Object screenMonitor;
    private int left;
    private int top;
    private final int width;
    private final int height;
    private final RasterBuffer screenBuffer;
    private final ScreenGraphics screenGraphics;
    private MIDletDispatcher serviceDispatcher;
    private Requestable serviceStream;
    Thread serviceThread;
    private final Runnable serviceStarted;
    private final Runnable serviceStopped;
    Displayable currentBackground;
    SurfaceScreen currentForeground;
    Displayable activeBackground;
    SurfaceScreen activeForeground;
    private final OneShotAction activeChanged;
    private final Object monitor;

    static {
        appThreads = new ApplicationThread[7];
        screenClip = new Clip(1024, 768);
        screenMonitor = new Object();
    }

    public static void registerApplication(MIDlet application) {
        Thread current = Thread.currentThread();
        if (!(current instanceof ApplicationThread) || !((ApplicationThread)current).setApplication(application)) {
            throw new SecurityException("MIDlet: \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u043c\u0438\u0434\u043b\u0435\u0442.");
        }
    }

    public static Display getDisplay(MIDlet application) {
        if (application == null) {
            throw new NullPointerException("Display.getDisplay: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 application \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        ApplicationThread[] appthreads = appThreads;
        int i = appThreads.length;
        while (i-- > 0) {
            ApplicationThread current = appthreads[i];
            if (current == null || current.getApplication() != application) continue;
            return current.parentDisplay();
        }
        return DeviceManager.getInstance().getMainDisplay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addAppThread(ApplicationThread appthread) {
        Object object = screenMonitor;
        synchronized (object) {
            Object[] appthreads = appThreads;
            int len = appthreads.length;
            if (Array.findf((Object[])appThreads, (int)0, (Object)appthread) >= len) {
                int index = Array.findf((Object[])appthreads, (int)0, null);
                if (index >= len) {
                    Object[] objectArray = appthreads;
                    appthreads = new ApplicationThread[(len << 1) + 1];
                    Array.copy((Object[])objectArray, (int)0, (Object[])appthreads, (int)0, (int)len);
                    appThreads = appthreads;
                }
                appthreads[index] = appthread;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeAppThread(Thread appthread) {
        Object object = screenMonitor;
        synchronized (object) {
            Object[] appthreads = appThreads;
            int index = Array.findb((Object[])appThreads, (int)(appthreads.length - 1), (Object)appthread);
            if (index >= 0) {
                appthreads[index] = null;
            }
        }
    }

    Display(boolean system, boolean visibility, int left, int top, int width, int height) {
        super(visibility);
        RasterBuffer buffer;
        if (width < 96 || width > 1024) {
            throw new IllegalArgumentException("Display: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 width \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        if (height < 128 || height > 768) {
            throw new IllegalArgumentException("Display: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 height \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
        this.screenBuffer = buffer = RasterBuffer.create((int)width, (int)height, (int)0xFFFFFF, (boolean)true);
        this.screenGraphics = new ScreenGraphics(buffer);
        this.serviceStream = system ? Run.instance : null;
        this.serviceThread = system ? Thread.currentThread() : null;
        this.serviceStarted = new Runnable(){

            public void run() {
                DeviceManager.getInstance().applicationStarted(Display.this);
            }
        };
        this.serviceStopped = new Runnable(){

            public void run() {
                DeviceManager.getInstance().applicationStopped(Display.this);
            }
        };
        this.activeChanged = new OneShotAction(){

            public void execute() {
                Display parent = Display.this;
                SurfaceScreen oldForeground = parent.activeForeground;
                Displayable oldBackground = parent.activeBackground;
                Displayable newBackground = parent.currentBackground;
                SurfaceScreen newForeground = parent.currentForeground;
                parent.activeBackground = newBackground;
                parent.activeForeground = newForeground;
                if (!parent.visibility) {
                    return;
                }
                if (oldBackground == newBackground && oldForeground != newForeground) {
                    if (oldForeground != null) {
                        oldForeground.eventHide();
                    }
                    if (newForeground != null) {
                        newForeground.eventShow(parent);
                        newForeground.requestPaintAll();
                        return;
                    }
                    if (oldBackground != null) {
                        oldBackground.requestPaintAll();
                    }
                    return;
                }
                if (oldBackground != newBackground && oldForeground == newForeground) {
                    if (oldForeground != null) {
                        if (oldBackground != null) {
                            oldBackground.eventHide();
                        }
                        if (newBackground != null) {
                            newBackground.eventShow(parent);
                        }
                        oldForeground.requestPaintAll();
                        return;
                    }
                    if (oldBackground != null) {
                        oldBackground.eventHide();
                    }
                    if (newBackground != null) {
                        newBackground.eventShow(parent);
                        newBackground.requestPaintAll();
                    }
                    return;
                }
                if (oldBackground != newBackground && oldForeground != newForeground) {
                    if (oldForeground != null) {
                        oldForeground.eventHide();
                    }
                    if (oldBackground != null) {
                        oldBackground.eventHide();
                    }
                    if (newBackground != null) {
                        newBackground.eventShow(parent);
                    }
                    if (newForeground != null) {
                        newForeground.eventShow(parent);
                        newForeground.requestPaintAll();
                        return;
                    }
                    if (newBackground != null) {
                        newBackground.requestPaintAll();
                    }
                }
            }
        };
        this.monitor = new Object();
    }

    public void handleKeyboardEvent(KeyboardEvent event) {
        if (event == null) {
            throw new NullPointerException("Display.handleKeyboardEvent: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 event \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (Thread.currentThread() == this.serviceThread) {
            Displayable foreground;
            if (this.visibility && (foreground = this.getActiveForeground()) != null) {
                foreground.eventKeyboard(event);
            }
            return;
        }
        Requestable stream = this.serviceStream;
        if (stream != null) {
            int action = event.getAction();
            switch (action) {
                case 5: 
                case 6: {
                    if (!this.visibility) break;
                    stream.requestKeyboardEvent(action, event.getKey(), event.getCharCode());
                    break;
                }
                case 7: {
                    if (!this.visibility) break;
                    stream.requestKeyboardEvent(action, event.getKey(), 0);
                }
            }
        }
    }

    public void handlePointerEvent(PointerEvent event) {
        if (event == null) {
            throw new NullPointerException("Display.handlePointerEvent: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 event \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (Thread.currentThread() == this.serviceThread) {
            Displayable foreground;
            if (this.visibility && (foreground = this.getActiveForeground()) != null) {
                foreground.eventPointer(event);
            }
            return;
        }
        Requestable stream = this.serviceStream;
        if (stream != null) {
            int action = event.getAction();
            switch (action) {
                case 9: {
                    if (!this.visibility) break;
                    stream.requestPointerEvent(action, 0, event.getX(), event.getY());
                    break;
                }
                case 10: 
                case 11: 
                case 14: 
                case 15: {
                    if (!this.visibility) break;
                    stream.requestPointerEvent(action, event.getButton(), event.getX(), event.getY());
                }
            }
        }
    }

    public void callSerially(Runnable action) {
        Requestable stream;
        if (action != null && (stream = this.serviceStream) != null) {
            stream.request(action, 0L);
        }
    }

    public void callSerially(Runnable action, long delay) {
        Requestable stream;
        if (action != null && (stream = this.serviceStream) != null) {
            stream.request(action, delay);
        }
    }

    public void setCurrent(Displayable screen) {
        if (screen == null) {
            return;
        }
        if (screen instanceof SurfaceScreen) {
            this.currentForeground = (SurfaceScreen)screen;
        } else {
            this.currentBackground = screen;
            this.currentForeground = null;
        }
        this.activeChanged.request(this);
    }

    public void setCurrent(Alert foreground, Displayable background) {
        if (foreground == null) {
            throw new NullPointerException("Display.setCurrent: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 foreground \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (background == null) {
            throw new NullPointerException("Display.setCurrent: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 background \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (background instanceof SurfaceScreen) {
            throw new IllegalArgumentException("Display.setCurrent: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 background \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0438\u043c\u0435\u0442\u044c \u0442\u0438\u043f SurfaceScreen.");
        }
        this.currentBackground = background;
        this.currentForeground = foreground;
        this.activeChanged.request(this);
    }

    public void setCurrent(SurfaceScreen foreground, Displayable background) {
        if (foreground == null) {
            throw new NullPointerException("Display.setCurrent: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 foreground \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (background == null) {
            throw new NullPointerException("Display.setCurrent: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 background \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (background instanceof SurfaceScreen) {
            throw new IllegalArgumentException("Display.setCurrent: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 background \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0438\u043c\u0435\u0442\u044c \u0442\u0438\u043f SurfaceScreen.");
        }
        this.currentBackground = background;
        this.currentForeground = foreground;
        this.activeChanged.request(this);
    }

    public void setCurrentItem(Item item) {
        if (item == null) {
            throw new NullPointerException("Display.setCurrentItem: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 item \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Screen screen = item.owner;
        if (screen == null) {
            throw new IllegalStateException("Display.setCurrentItem: \u044d\u043b\u0435\u043c\u0435\u043d\u0442 \u043d\u0435 \u043f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u0438\u0442 \u043a\u0430\u043a\u043e\u043c\u0443-\u043b\u0438\u0431\u043e \u044d\u043a\u0440\u0430\u043d\u0443.");
        }
        this.currentBackground = screen;
        this.currentForeground = null;
        this.activeChanged.request(this);
        screen.setFocus(item, this);
    }

    public boolean flashBacklight(int duration) {
        if (duration < 0) {
            throw new IllegalArgumentException("Display.flashBacklight: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 duration \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (this.visibility) {
            DeviceManager.getInstance().getBacklight().start(duration);
            return true;
        }
        return false;
    }

    public boolean vibrate(int duration) {
        if (duration < 0) {
            throw new IllegalArgumentException("Display.vibrate: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 duration \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (this.visibility) {
            DeviceManager.getInstance().getVibrator().start(duration);
            return true;
        }
        return false;
    }

    public boolean isColor() {
        return true;
    }

    public int numColors() {
        return 0x1000000;
    }

    public int numAlphaLevels() {
        return 256;
    }

    public int getBestImageWidth(int type) {
        switch (type) {
            case 2: {
                return 24;
            }
            case 1: {
                return 32;
            }
            case 3: {
                return 48;
            }
        }
        throw new IllegalArgumentException("Display.getBestImageWidth: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 type \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
    }

    public int getBestImageHeight(int type) {
        switch (type) {
            case 2: {
                return 24;
            }
            case 1: {
                return 32;
            }
            case 3: {
                return 48;
            }
        }
        throw new IllegalArgumentException("Display.getBestImageHeight: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 type \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
    }

    public int getBorderStyle(boolean highlighted) {
        return 0;
    }

    public int getColor(int colorSpecifier) {
        switch (colorSpecifier) {
            case 1: {
                return RasterCanvas.getSystemColor((int)32);
            }
            case 2: {
                return RasterCanvas.getSystemColor((int)25);
            }
            case 3: {
                return RasterCanvas.getSystemColor((int)33);
            }
            case 0: 
            case 4: 
            case 5: {
                return RasterCanvas.getSystemColor((int)5);
            }
        }
        throw new IllegalArgumentException("Display.getColor: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 colorSpecifier \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
    }

    public Displayable getCurrent() {
        SurfaceScreen result = this.currentForeground;
        return result != null && result instanceof Alert ? result : this.currentBackground;
    }

    public Displayable getBackground() {
        return this.currentBackground;
    }

    public Displayable getForeground() {
        SurfaceScreen result = this.currentForeground;
        return result != null ? result : this.currentBackground;
    }

    public final void show() {
        if (!this.visibility) {
            this.showDisplay();
        }
    }

    public final void hide() {
        if (this.visibility) {
            this.hideDisplay();
        }
    }

    public final void setVisibility(boolean visibility) {
        boolean current = this.visibility;
        if (visibility && !current) {
            this.showDisplay();
            return;
        }
        if (!visibility && current) {
            this.hideDisplay();
        }
    }

    public final boolean isVisible() {
        return this.visibility;
    }

    public final int getLeft() {
        return this.left;
    }

    public final int getTop() {
        return this.top;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPosition(int left, int top) {
        Displayable foreground;
        boolean needRepaint = false;
        Clip clip = screenClip;
        synchronized (clip) {
            if (this.left != left || this.top != top) {
                needRepaint = true;
                this.left = left;
                this.top = top;
            }
        }
        if (needRepaint && this.visibility && (foreground = this.getActiveForeground()) != null) {
            foreground.requestPaintAll();
        }
    }

    public final Displayable getActiveBackground() {
        return this.activeBackground;
    }

    public final Displayable getActiveForeground() {
        SurfaceScreen result = this.activeForeground;
        return result != null ? result : this.activeBackground;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void update() {
        if (!this.visibility) {
            return;
        }
        int behavior = 0;
        long milliseconds = 0L;
        long period = DeviceManager.getInstance().getSettings().getMinimumPeriod();
        Object object = screenMonitor;
        synchronized (object) {
            long last = lastUpdated;
            long curr = System.currentTimeMillis();
            long prev = last - period;
            long next = last + period;
            if (curr >= prev && curr < last) {
                milliseconds = last - curr;
                behavior = 1;
            } else if (curr >= last && curr < next) {
                lastUpdated = next;
                milliseconds = next - curr;
                behavior = 2;
            } else {
                lastUpdated = curr;
                behavior = 3;
            }
        }
        try {
            switch (behavior) {
                case 1: {
                    Thread.sleep(milliseconds);
                    break;
                }
                case 2: {
                    Thread.sleep(milliseconds);
                }
                case 3: {
                    if (this.visibility) {
                        object = screenClip;
                        synchronized (object) {
                            if (this.visibility) {
                                RasterCanvas screen = RasterCanvas.screen;
                                screen.drawPixels(this.screenBuffer, 0, (Rectangle)this, screenClip);
                                screen.updateScreen();
                            }
                        }
                    }
                    break;
                }
            }
        }
        catch (InterruptedException e) {
            e.printRealStackTrace();
        }
    }

    final void notifyStarted() {
        Run.instance.request(this.serviceStarted);
    }

    final void notifyStopped() {
        Display.removeAppThread(this.serviceThread);
        this.serviceDispatcher = null;
        this.serviceStream = null;
        this.serviceThread = null;
        this.currentBackground = null;
        this.currentForeground = null;
        this.activeBackground = null;
        this.activeForeground = null;
        Run.instance.request(this.serviceStopped);
    }

    final void hideSurfaceScreen() {
        this.currentForeground = null;
        this.activeChanged.request(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int start(String applicationTypeName) {
        int error = 0;
        Thread appthread = null;
        Object object = this.monitor;
        synchronized (object) {
            Requestable stream = this.serviceStream;
            if (stream == Run.instance) {
                error = 1;
            } else if (stream != null) {
                error = 2;
            } else if (applicationTypeName == null) {
                error = 3;
            } else {
                MIDletDispatcher dispatcher;
                this.serviceDispatcher = dispatcher = new MIDletDispatcher(applicationTypeName);
                Display display = this;
                display.getClass();
                ApplicationExecution execution = display.new ApplicationExecution(16, 16, applicationTypeName, dispatcher);
                this.serviceStream = execution;
                Display display2 = this;
                display2.getClass();
                this.serviceThread = appthread = display2.new ApplicationThread(execution);
            }
        }
        if (error != 0) {
            return error;
        }
        Display.addAppThread(appthread);
        appthread.start();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int stop(boolean destroyAppInvoke) {
        int error = 0;
        Object object = this.monitor;
        synchronized (object) {
            Requestable stream = this.serviceStream;
            if (stream == Run.instance) {
                error = 1;
            } else if (stream == null) {
                error = 2;
            } else if (destroyAppInvoke) {
                stream.request((Runnable)new ApplicationTermination(stream, this.serviceDispatcher));
            } else {
                stream.terminate();
            }
        }
        return error;
    }

    final MIDlet application() {
        Thread thread = this.serviceThread;
        return thread instanceof ApplicationThread ? ((ApplicationThread)thread).getApplication() : null;
    }

    final ScreenGraphics graphics() {
        return this.screenGraphics;
    }

    private void showDisplay() {
        this.visibility = true;
        if (Thread.currentThread() == this.serviceThread) {
            Displayable foreground = this.getActiveForeground();
            if (foreground != null) {
                Displayable background = this.getActiveBackground();
                if (background != null && background != foreground) {
                    background.eventShow(this);
                }
                foreground.eventShow(this);
                foreground.requestPaintAll();
            }
            return;
        }
        this.update();
        Requestable stream = this.serviceStream;
        if (stream != null) {
            stream.requestWindowShow();
        }
    }

    private void hideDisplay() {
        this.visibility = false;
        if (Thread.currentThread() == this.serviceThread) {
            Displayable foreground = this.getActiveForeground();
            if (foreground != null) {
                foreground.eventHide();
                Displayable background = this.getActiveBackground();
                if (background != null && background != foreground) {
                    background.eventHide();
                }
            }
            return;
        }
        Requestable stream = this.serviceStream;
        if (stream != null) {
            stream.requestWindowHide();
        }
    }

    private class ActionStream
    extends Requestable
    implements Runnable {
        private final int capacity;
        private final RequestableQueue queue;

        public ActionStream(int initialCapacity, int historyCapacity) {
            this.capacity = historyCapacity;
            this.queue = new RequestableQueue(initialCapacity);
        }

        public synchronized void request(int action, int param1, int param2, int param3) {
            this.queue.addTailElement(null, (long)(action & 0xFFFF) | (long)(param1 & 0xFFFF) << 16 | (long)(param2 & 0xFFFF) << 32 | (long)(param3 & 0xFFFF) << 48);
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void request(Runnable action, long delay) {
            if (delay > 0L) {
                if (action != null) {
                    ActionStream actionStream = this;
                    actionStream.getClass();
                    Scheduler.schedule((Scheduler.Task)actionStream.new DelayedAction(action), (long)delay, (int)2);
                }
                return;
            }
            ActionStream actionStream = this;
            synchronized (actionStream) {
                this.queue.addTailElement(action, -1L);
                this.notify();
            }
        }

        public synchronized void terminate() {
            super.terminate();
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            InputDevice device;
            int historyCapacity = this.capacity;
            int[] ids = InputDevice.getIDs();
            RequestableQueue queue = this.queue;
            KeyboardEvent kbdevent = new KeyboardEvent(historyCapacity);
            PointerEvent ptrevent = new PointerEvent(historyCapacity);
            InputDevice keyboard = null;
            InputDevice pointing = null;
            int len = ids.length;
            int i = 0;
            while (i < len) {
                device = InputDevice.get((int)ids[i]);
                if (!device.isVirtual()) {
                    if (device.sourceSupported(1) && device.getKeyboardType() != 0) {
                        keyboard = device;
                    } else if (device.sourceSupported(2)) {
                        pointing = device;
                    }
                }
                ++i;
            }
            historyCapacity = 0;
            ids = null;
            device = null;
            Display parent = Display.this;
            while (true) {
                Displayable foreground;
                Runnable fromApp;
                long fromUser;
                this.waitAction();
                if (super.terminated()) break;
                ActionStream actionStream = this;
                synchronized (actionStream) {
                    if (queue.isEmpty()) {
                        fromUser = -1L;
                        fromApp = null;
                    } else {
                        fromUser = queue.peekHeadLong();
                        fromApp = queue.peekHeadRunnable();
                        queue.removeHeadElement();
                    }
                }
                if (fromApp != null) {
                    try {
                        fromApp.run();
                    }
                    catch (RuntimeException e) {
                        e.printRealStackTrace();
                    }
                    continue;
                }
                if (fromUser == -1L || (foreground = parent.getActiveForeground()) == null) continue;
                short action = (short)fromUser;
                short param1 = (short)(fromUser >> 16);
                short param2 = (short)(fromUser >> 32);
                short param3 = (short)(fromUser >> 48);
                switch (action) {
                    case 2: {
                        Displayable background = parent.getActiveBackground();
                        if (background != null && background != foreground) {
                            background.eventShow(parent);
                        }
                        foreground.eventShow(parent);
                        foreground.requestPaintAll();
                        break;
                    }
                    case 3: {
                        foreground.eventHide();
                        Displayable background = parent.getActiveBackground();
                        if (background == null || background == foreground) break;
                        background.eventHide();
                        break;
                    }
                    case 5: 
                    case 6: {
                        kbdevent.addStory((int)action, (int)param1, param2 & 0xFFFF | param3 << 16, keyboard, 257, 0L);
                        foreground.eventKeyboard(kbdevent);
                        break;
                    }
                    case 7: {
                        kbdevent.addStory((int)action, (int)param1, 0, keyboard, 257, 0L);
                        foreground.eventKeyboard(kbdevent);
                        break;
                    }
                    case 9: {
                        ptrevent.addStory((int)action, 0, (int)param2, (int)param3, pointing, 8194, 0L);
                        ptrevent.translateReset();
                        foreground.eventPointer(ptrevent);
                        break;
                    }
                    case 10: 
                    case 11: 
                    case 14: 
                    case 15: {
                        ptrevent.addStory((int)action, (int)param1, (int)param2, (int)param3, pointing, 8194, 0L);
                        ptrevent.translateReset();
                        foreground.eventPointer(ptrevent);
                    }
                }
            }
        }

        private synchronized void waitAction() {
            while (true) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printRealStackTrace();
                    continue;
                }
                break;
            }
        }

        private final class DelayedAction
        extends Scheduler.Task {
            private final Runnable action;

            public DelayedAction(Runnable action) {
                this.action = action;
            }

            public void run() {
                ActionStream.this.request(this.action, 0L);
            }
        }
    }

    private final class ApplicationExecution
    extends ActionStream {
        private final String typeName;
        private final MIDletDispatcher dispatcher;

        public ApplicationExecution(int initialCapacity, int historyCapacity, String typeName, MIDletDispatcher dispatcher) {
            super(initialCapacity, historyCapacity);
            this.typeName = typeName;
            this.dispatcher = dispatcher;
        }

        public void run() {
            Display parent = Display.this;
            PrintStream printer = System.out;
            String typeName = this.typeName;
            MIDletDispatcher dispatcher = this.dispatcher;
            printer.println("\u0417\u0430\u043f\u0443\u0441\u043a \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f\u2026 \u041a\u043b\u0430\u0441\u0441 \u043c\u0438\u0434\u043b\u0435\u0442\u0430: ".concat(typeName));
            int status = dispatcher.start();
            parent.notifyStarted();
            if (status != 0) {
                printer.println("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u2013 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0430\u0435\u0442 \u0440\u0430\u0431\u043e\u0442\u0443. \u041a\u043b\u0430\u0441\u0441 \u043c\u0438\u0434\u043b\u0435\u0442\u0430: ".concat(typeName));
                if (status == 1) {
                    dispatcher.stop();
                }
                parent.notifyStopped();
                return;
            }
            printer.println("\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0443\u0449\u0435\u043d\u043e \u0438 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442. \u041a\u043b\u0430\u0441\u0441 \u043c\u0438\u0434\u043b\u0435\u0442\u0430: ".concat(typeName));
            super.run();
            printer.println("\u041f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u043e \u0440\u0430\u0431\u043e\u0442\u0443. \u041a\u043b\u0430\u0441\u0441 \u043c\u0438\u0434\u043b\u0435\u0442\u0430: ".concat(typeName));
            RecordStore.closeAllRecordStores();
            parent.notifyStopped();
        }
    }

    private static final class ApplicationTermination
    implements Runnable {
        private final Requestable stream;
        private final MIDletDispatcher dispatcher;

        public ApplicationTermination(Requestable stream, MIDletDispatcher dispatcher) {
            this.stream = stream;
            this.dispatcher = dispatcher;
        }

        public void run() {
            this.dispatcher.stop();
            this.stream.terminate();
        }
    }

    private final class ApplicationThread
    extends Thread {
        private MIDlet application;

        public ApplicationThread(ActionStream target) {
            super((Runnable)target, "\u041f\u043e\u0442\u043e\u043a \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f, \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u044e\u0449\u0438\u0439 \u0441\u043e\u0431\u044b\u0442\u0438\u044f \u043c\u0438\u0434\u043b\u0435\u0442\u0430");
        }

        public boolean setApplication(MIDlet application) {
            if (this.application == null) {
                this.application = application;
                return true;
            }
            return false;
        }

        public MIDlet getApplication() {
            return this.application;
        }

        public Display parentDisplay() {
            return Display.this;
        }
    }

    static abstract class OneShotAction
    implements Runnable {
        private static final int FREED = 0;
        private static final int REQUESTED = 1;
        private static final int EXECUTING = 2;
        private static final int REPEATED = 3;
        private int state;
        private Object service;
        protected final Object monitor;

        protected OneShotAction() {
            this.monitor = new Object();
        }

        protected OneShotAction(Object monitor) {
            this.monitor = monitor == null ? new Object() : monitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            Object monitor;
            boolean exec = false;
            Object object = monitor = this.monitor;
            synchronized (monitor) {
                if (this.state == 1) {
                    this.state = 2;
                    exec = true;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                if (exec) {
                    this.serviceExecute(monitor);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void service() {
            Object monitor;
            boolean exec = false;
            Object object = monitor = this.monitor;
            synchronized (monitor) {
                if (Thread.currentThread() == this.service) {
                    if (this.state == 1) {
                        this.state = 2;
                        exec = true;
                    }
                } else {
                    while (this.state != 0) {
                        try {
                            monitor.wait();
                        }
                        catch (InterruptedException e) {
                            e.printRealStackTrace();
                        }
                    }
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                if (exec) {
                    this.serviceExecute(monitor);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void request(Display parent) {
            boolean exec;
            block9: {
                if (parent == null) {
                    throw new NullPointerException("OneShotAction.request: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 parent \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
                }
                exec = false;
                Object object = this.monitor;
                synchronized (object) {
                    switch (this.state) {
                        default: {
                            break block9;
                        }
                        case 0: {
                            this.state = 1;
                            break;
                        }
                        case 2: {
                            this.state = 3;
                        }
                    }
                    this.service = parent.serviceThread;
                    exec = true;
                }
            }
            if (exec) {
                parent.callSerially(this);
            }
        }

        protected abstract void execute();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void serviceExecute(Object monitor) {
            try {
                this.execute();
            }
            catch (RuntimeException e) {
                e.printRealStackTrace();
            }
            Object object = monitor;
            synchronized (object) {
                this.state &= 1;
                monitor.notifyAll();
            }
        }
    }
}

